var img_bar = document.createElement('img');
var is_img_bar_loaded = false;


$(function(){
	function state_to_idx(state){
	    if(state == 'OK' || state == 'UP' || state == 'UNKNOWN'){
		return 1;
	    }
	    if(state == 'WARNING'){
                return 2;
            }
	    if(state == 'CRITICAL' ||state == 'DOWN'){
                return 3;
            }
	    return 4;
	    
	}

	function update_bar(name, value, str, state){
	    var c = document.getElementById(name);
	    var ctx = c.getContext("2d");
	    var idx = state_to_idx(state);
	    
	    ctx.drawImage(img_bar, 0, 0, 70, 18, 0, 0, 70, 18);
	    var offset = (value/100)*70;
	    ctx.drawImage(img_bar, 0, 18*idx, offset, 18, 0, 0, offset, 18);
	    ctx.font = "12px Arial";
	    ctx.fillStyle = "#000000";
	    ctx.fillText(str, 20, 15, 70);
	    console.log('text filled');
	}

    
	img_bar.onload=function(){
	    is_img_bar_loaded = true;
	    console.log('LOADED IMAGE');
	    // Load all hbar and initialize them
	    $('.hbar').each(function(idx){
		    var val = $(this).data('value');
		    var str = $(this).data('str');
		    var id  = $(this).attr('id');
		    var state = $(this).data('state');
		    update_bar(id, val, str, state);
		});
	};
	// Always set src AFTER the onload...
	img_bar.src = '/static/cv_mysql/img/bar_horizontal.png';

	/*
	  function refresh_bars(){
	  if(!is_img_bar_loaded){console.log('fail');return;}
	  //update_bar("keycache", 20);
	  }
	
	  setInterval(refresh_bars, 1000/12);
	*/


	// Declare all donuts
	register_all_donuts();
    });
