#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2016:
#    Shinken solutions
import json

from shinken.log import logger

# Global value that will be changed by the main app
app = None


def list_share():
    user = app.get_user_auth()
    
    # Second we look for bdd access.
    collection = app.get_share_collection()
    if not collection:
        logger.info("list_share No more backend for saving data")
        app.abort(500, 'No more backend for saving the data')
        return json.dumps(False)
    
    user_id = user.uuid
    user_group_ids = []
    user_group = app.get_contact_groups(user)
    if user_group:
        for group in user_group:
            user_group_ids.append(group.uuid)
    
    shares = [e for e in collection.find({"$or": [{"owner.uuid": user_id}, {"group.uuid": {"$in": user_group_ids}}, {"type": "global"}]}, {'_id': 0})]
    
    if len(shares) == 0:
        return json.dumps([])
    else:
        for share in shares:
            if share.get('screen', {}):
                screen_type = share['screen'].get('type', None)
                
                if not screen_type:
                    return app.abort(500, " Share structure incorrect : missing key type in screen")
                
                collection_screen = app.get_screen_collection(share['screen']['type'])
                screen = collection_screen.find_one({'uuid': share['screen']['uuid']}, {'state': 1, 'name': 1})
                if screen:
                    share['screen']['name'] = screen['name']
                    if screen.get('state', {}):
                        share['screen']['state'] = screen['state']
                else:
                    share['screen']['state'] = {'not_found': True}
                    share['screen']['name'] = 'no name'
        return json.dumps(shares)


def get_share(uuid):
    logger.debug("call get_share")
    
    # Second we look for bdd access.
    collection = app.get_share_collection()
    if not collection:
        logger.info("get_share No more backend for saving data")
        app.abort(500, 'No more backend for saving the data')
        return json.dumps(False)
    
    # Our main key is the uuid
    share = collection.find_one({'uuid': uuid}, {'_id': 0})
    
    # if no previous entries, None is good
    if share:
        if share.get('screen', {}):
            collection_screen = app.get_screen_collection(share['screen']['type'])
            screen = collection_screen.find_one({'uuid': share['screen']['uuid']}, {'state': 1, 'name': 1})
            if screen:
                share['screen']['state'] = screen['state']
                share['screen']['name'] = screen['name']
            else:
                share['screen']['state'] = {'not_found': True}
                share['screen']['name'] = 'no name'
        return json.dumps(share)
    else:
        logger.info("get_share Share not found")
        app.abort(404, 'Share not found')
        return json.dumps(False)


def save_share_POST():
    save_share()


def save_share(uuid=''):
    logger.debug("call get_share")
    
    # Second we look for bdd access.
    collection = app.get_share_collection()
    if not collection:
        logger.info("save_share No more backend for saving data")
        app.abort(500, 'No more backend for saving the data')
        return json.dumps(False)
    
    if uuid and collection.find({'_id': uuid}, {'uuid': 1}).count() == 0:
        logger.info("save_share They are not share with id : %s" % uuid)
        app.abort(404, "They are not share with id : %s" % uuid)
        return json.dumps(False)
    
    if hasattr(app.request.body, 'getvalue'):
        data = json.loads(app.request.body.getvalue())
    else:  # file?
        data = json.loads(app.request.body.read())
    
    share_uuid = data.get('uuid', '')
    if not share_uuid:
        logger.info("save_share Data to save need a uuid")
        app.abort(422, 'Data to save need a uuid')
        return json.dumps(False)
    
    # Eventually we save the data.
    logger.debug("Share data to save %s", data)
    collection.update({'_id': share_uuid}, data, upsert=True)
    return {}


def del_share(uuid):
    logger.debug("call get_share")
    
    # Second we look for bdd access.
    collection = app.get_share_collection()
    if not collection:
        logger.info("del_share No more backend for saving the data")
        app.abort(500, 'No more backend for saving the data')
        return json.dumps(False)
    
    if not uuid:
        logger.info("del_share Data to save need a uuid")
        app.abort(422, 'Data to save need a uuid')
        return json.dumps(False)
    
    write_result = collection.remove({'_id': uuid})
    nb_del = write_result.get('n', 0)
    logger.info("del_share Nombre de share supprimer %s" % nb_del)
    
    if nb_del == 0:
        logger.info("del_share They are not share with id : %s" % uuid)
        app.abort(404, "They are not share with id : %s" % uuid)
        return json.dumps(False)
    
    return {'delete_share': nb_del}


pages = {
    list_share     : {'routes': ['/share'], 'method': 'GET', 'wrappers': ['auth', 'json']},
    get_share      : {'routes': ['/share/:uuid'], 'method': 'GET', 'wrappers': ['auth', 'json']},
    save_share     : {'routes': ['/share/:uuid'], 'method': 'PUT', 'wrappers': ['auth', 'json']},
    save_share_POST: {'routes': ['/share'], 'method': 'POST', 'wrappers': ['auth', 'json']},
    del_share      : {'routes': ['/share/:uuid'], 'method': 'DELETE', 'wrappers': ['auth', 'json']},
}
