from shinken.log import logger


hst_properties = [
    {'desc':'filter.ok', 'states':['UP']},
    {'desc':'filter.warning', 'states':['WARNING']},
    {'desc':'filter.down', 'states':['DOWN']},
    {'desc':'filter.unknown', 'states':['UNREACHEABLE', 'UNKNOWN']},

]


sst_properties = [
    {'desc':'filter.ok', 'states':['OK']},
    {'desc':'filter.warning', 'states':['WARNING']},
    {'desc':'filter.down', 'states':['CRITICAL']},
    {'desc':'filter.unknown', 'states':['UNKNOWN', 'PENDING']},
]


hp_properties_raw = [
    # Downtime
    {'desc': 'filter.downtime', 'f': lambda i: i.in_scheduled_downtime},
    {'desc': 'filter.not_downtime', 'f': lambda i: not i.in_scheduled_downtime},
    # Acknowledged
    {'desc': 'filter.acknowledged', 'f': lambda i: i.problem_has_been_acknowledged },
    {'desc': 'filter.not_acknowledged', 'f': lambda i: not i.problem_has_been_acknowledged},
    # Check enabled/disabled
    {'desc': 'filter.check_disabled', 'f': lambda i: not i.active_checks_enabled},
    {'desc': 'filter.check_enabled', 'f': lambda i: i.active_checks_enabled},
    # Event Handlers
    {'desc': 'filter.event_handlers_disabled', 'f': lambda i: not i.event_handler_enabled},
    {'desc': 'filter.event_handlers_enabled', 'f': lambda i: i.event_handler_enabled},
    # Flapping
    {'desc': 'filter.flapping_detection_disabled', 'f': lambda i: not i.flap_detection_enabled},
    {'desc': 'filter.flapping_detection_enabled', 'f': lambda i: i.flap_detection_enabled},
    {'desc': 'filter.flapping', 'f': lambda i: i.is_flapping},
    {'desc': 'filter.not_flapping', 'f': lambda i: not i.is_flapping},
    # Notifications
    {'desc': 'filter.notifications_disabled', 'f': lambda i: not i.notifications_enabled},
    {'desc': 'filter.notifications_enabled', 'f': lambda i: i.notifications_enabled},
    # Passive checks
    {'desc': 'filter.passive_checks_disabled', 'f': lambda i: not i.passive_checks_enabled},
    {'desc': 'filter.passive_checks_enabled', 'f': lambda i: i.passive_checks_enabled},
    # HARD/SOFT
    {'desc': 'filter.hard', 'f': lambda i: i.state_type == 'HARD'},
    {'desc': 'filter.soft', 'f': lambda i: i.state_type == 'SOFT'},
    # NOT TRIVIAL
    {'desc': 'filter.in_check_period'},         {'desc': 'filter.outside_check_period'},
    {'desc': 'filter.in_notification_period'},  {'desc': 'filter.outside_notification_period'},
    {'desc': 'filter.has_modified_attributes'}, {'desc': 'filter.no_modified_attributes'},
]


# Services are alike hosts in fact
sp_properties_raw = hp_properties_raw

hp_properties = []
for v in hp_properties_raw:
    d = {}
    hp_properties.append(d)
    for (k2, v2) in v.iteritems():
        if not callable(v2):
            d[k2] = v2

sp_properties = hp_properties

# Match host by looking at their state
def match_hst(app, i, op, value):
    # A service is not interesting, look at its host instead
    if i.__class__.my_type == 'service':
        i = i.host
    # Ok real host now
    state = i.state
    idx = 0
    j = 0
    for d in hst_properties:
        if state in d['states']:
            idx = j
        j += 1

    mask = 1 << idx   # Look for the idx bit
    m = value & mask
    if m != 0:
        return True
    else:
        return False



# Match services by looking at their state
def match_sst(app, i, op, value):
    # An host is always OK there
    if i.__class__.my_type == 'host':
        return True
    # Ok real host now
    state = i.state
    idx = 0
    j = 0
    for d in sst_properties:
        if state in d['states']:
            idx = j
        j += 1

    mask = 1 << idx   # Look for the idx bit
    m = value & mask
    if m != 0:
        return True
    else:
        return False



# Match host by looking at their state
def match_hp(app, i, op, value):
    # A service is not interesting, look at its host instead
    if i.__class__.my_type == 'service':
        return True
    
    j = -1
    for d in hp_properties_raw:
        j += 1
        mask = 1 << j #
        m = value & mask
        # If we do not look for this entry, by pass it
        if m == 0:
            continue
        f = d.get('f', None)
        if not f:
            continue
        b = f(i)
        return b
    return True


# Match host by looking at their state
def match_sp(app, i, op, value):
    # A service is not interesting, look at its host instead
    if i.__class__.my_type == 'host':
        return True
    
    j = -1
    for d in sp_properties_raw:
        j += 1
        mask = 1 << j #
        m = value & mask
        # If we do not look for this entry, by pass it
        if m == 0:
            continue
        f = d.get('f', None)
        if not f:
            continue
        b = f(i)
        return b
    return True


# Search by the full name
# TODO: manage op
def match_search(app, i, op, value):
    name = i.get_full_name()
    return value in name


# Search by the full name
def match_hg(app, i, op, value):
    o = i
    if i.__class__.my_type == 'service':
        o = i.host
    if op == '=':
        for hg in o.hostgroups:
            if hg.get_name().startswith(value):
                return True
        # By default if search only for, negative is False
        return False
    if op == '!=':
        for hg in o.hostgroups:
            if hg.get_name().startswith(value):
                return False
        # If search for ALL but, means if not, True
        return True


# TODO: manage op better
def match_check_period(app, i, op, value):
    tp = i.check_period

    # If we got no timeperiod, the only Tue result
    # is when the value is void
    if not tp:
        return not value

    tpname = tp.get_name()
    return value == tpname
    

def match_contact(app, i, op, value):
    contacts = i.contacts
    
    for c in contacts:
        cname = c.get_name()
        if value in cname:
            return True
    return False




# Search by the full name
# TODO: manage op
def match_root_problem(app, i, op, value):
    logger.error('ASKING'+i.get_full_name()+' if '+str(i.is_problem)+' '+op+' '+str(value)+' '+str(type(value)))
    if value == '1':
        return i.is_problem
    else:
        return not i.is_problem


# Search by the full name
# TODO: manage op
def match_business_impact(app, i, op, value):
    print "COMPARE", op, value, i.business_impact, type(value)
    if op == '<=':
        return i.business_impact <= value
    if op == '<':
        return i.business_impact < value
    if op == '>=':
        return i.business_impact >= value
    if op == '>':
        return i.business_impact > value
    if op == '==':
        return i.business_impact == value
    if op == '!=':
        return i.business_impact != value
    return True




# Search by the full name
def match_host(app, i, op, value):
    o = i
    if i.__class__.my_type == 'service':
        o = i.host
    if op == '=':
        if o.get_name().lower() == value.lower():
            return True
        return False
    if op == '!=':
        if o.get_name().lower() == value.lower():
            return False
        return True
    if op == '~':
        if value.lower() in o.get_name().lower():
            return True
        return False
    if op == '!~':
        if value.lower() not in o.get_name().lower():
            return True
        return False


# Search by the full name
def match_realm(app, i, op, value):
    o = i
    if i.__class__.my_type == 'service':
        o = i.host

    if op == '=':
        if o.realm.lower() == value.lower():
            return True
        return False
    if op == '!=':
        if o.realm.lower() == value.lower():
            return False
        return True
    

# Search by the full name
def match_parent(app, i, op, value):
    o = i
    if i.__class__.my_type == 'service':
        o = i.host
    my_parents = getattr(o, 'my_parents', None)
    if my_parents is None: # oh first related build for this host? do it so :)
        my_parents = set()
        _ = [my_parents.add(p.get_name().lower()) for p in o.parents if p.__class__.my_type == 'host']
        _ = [my_parents.add(p.get_name().lower()) for p in o.parent_dependencies if p.__class__.my_type == 'host']
        _ = [my_parents.add(p.get_name().lower()) for p in o.child_dependencies if p.__class__.my_type == 'host']
        o.my_parents = list(my_parents)
        o.my_parents.sort()

    for p in o.my_parents:
        if op == '=':
            if p == value.lower():
                return True
        if op == '!=':
            if p == value.lower():
                return False

    if op == '=' or op == '~':
        return False
    else:
        return True




# Search by the full name
def match_service(app, i, op, value):
    o = i
    if i.__class__.my_type != 'service':
        return False

    if op == '=':
        if o.get_name().lower() == value.lower():
            return True
        return False
    if op == '!=':
        if o.get_name().lower() == value.lower():
            return False
        return True
    if op == '~':
        if value.lower() in o.get_name().lower():
            return True
        return False
    if op == '!~':
        if value.lower() in o.get_name().lower():
            return False
        return True
    


# Search by the full name
def match_servicegroup(app, i, op, value):
    o = i
    # and hot won't mathc this...
    if i.__class__.my_type != 'service':
        return False
    
    for p in o.servicegroups:
        if op == '=':
            if p.get_name().lower() == value.lower():
                return True
        if op == '!=':
            if p.get_name().lower() == value.lower():
                return False
        if op == '~':
            if value.lower() in p.get_name().lower():
                return True
        if op == '!~':
            if value.lower() not in p.get_name().lower():
                return True

    if op == '=' or op == '~':
        return False
    else:
        return True




# Search by the full name
def match_tag(app, i, op, value):
    o = i
    if i.__class__.my_type == 'service':
        o = i.host

    if op == '=':
        for t in o.tags:
            if t.lower() == value.lower():
                return True
    if op == '!=':
        for t in o.tags:
            if t.lower() == value.lower():
                return False
        return True
    if op == '~':
        for t in o.tags:
            if value.lower() in t.lower():
                return True
    if op == '!~':
        for t in o.tags:
            if value.lower() in t.lower():
                return False
        return True
    
    if op == '=' or op == '~':
        return False
    else:
        return True
