var engine = new Engine3D();
var scene = null;
var camera = null;
var renderer = null;
var sphere = null;
var c3d = null;

var camera_init_position = null;
var camera_init_rotation = null;


var spheres = {};
var d3_lines = {};
var side_planes = {};
var hit_boxes = [];

var controls;


var controller;
var got_controller = false;


$(function () {

    // Add tooltips to items
    $('.applytooltip').tooltip({html: true});


    // Try to detect a leap motion controller
    if(typeof Leap != 'undefined') {
        controller = new Leap.Controller ();

        controller.on ( 'deviceConnected', function () {
            $ ( '#leap-gauge' ).show ();
            $ ( '#leap_detection' ).html ( 'connected' );
            got_controller = true;
        } );

        controller.on ( 'deviceDisconnected', function () {
            $ ( '#leap-gauge' ).hide ();
            $ ( '#leap_detection' ).html ( 'missing' );
            got_controller = false;
        } );

        controller.connect ();
    }


    // Ok we can now put the #waiting into a no more loading state
    $('#waiting').html(_('threed.computingNodes'));

    function init_3d() {
        // get the DOM element to attach to
        // - assume we've got jQuery to hand
        var $container = $('#container');
        var html_cont = document.getElementById('container');

        // Resize the container for vertical thing
        var height_ratio = 0.9;
        if (typeof inside_widget != 'undefined' && inside_widget) {
            height_ratio = 1;
        }
        $container.css('height', Math.floor($(window).height() * height_ratio));

        // set the scene size
        var WIDTH = $container.width();
        HEIGHT = $container.height();
        //HEIGHT = $(window).height()*0.8;
        //$('#container').attr('height', HEIGHT);

        // set some camera attributes
        var VIEW_ANGLE = 45,
            ASPECT = WIDTH / HEIGHT,
            NEAR = 0.1,
            FAR = 10000;


        // create a WebGL renderer, camera
        // and a scene
        if (Detector.webgl) {
            renderer = new THREE.WebGLRenderer({antialias: true/*HIVE, alpha:true*/});
        } else {
            renderer = new THREE.CanvasRenderer({antialias: false});
        }
        renderer.sortObjects = true;
        renderer.autoClear = true;
        /*HIVE: renderer.setClearColor( 0x000000, 0 );*/
        renderer.setClearColor(0xEFECE5, 1);

        camera = new THREE.PerspectiveCamera(VIEW_ANGLE,
            ASPECT,
            NEAR,
            FAR);

        // Create the scene and add it to our 3d engine
        scene = new THREE.Scene();
        engine.add_scene(scene);


        // Initialize the control for the mouse, and the leap
        controls = new THREE.TrackballControls(camera, html_cont);
        controls.rotateSpeed = 1.0;
        controls.zoomSpeed = 1.2;
        controls.panSpeed = 0.8;
        controls.noZoom = false;
        controls.noPan = false;
        controls.staticMoving = false;
        controls.dynamicDampingFactor = 0.3;
        controls.keys = [65, 83, 68];


        // the camera starts at 0,0,0 so pull it back
        camera.position.z = 900;

        // start the renderer
        renderer.setSize(WIDTH, HEIGHT);

        // attach the render-supplied DOM element
        $container.append(renderer.domElement);


        // and the camera
        scene.add(camera);

        // create a point light
        var pointLight = new THREE.PointLight(0xFFFFFF);

        // set its position
        pointLight.position.x = 10;
        pointLight.position.y = 50;
        pointLight.position.z = 630;

        // add to the scene
        //scene.add(pointLight);

        var ambientLight = new THREE.AmbientLight(0xFFFFFF);
        scene.add(ambientLight);

        // draw!
        renderer.render(scene, camera);
    }

    init_3d();


    function init_controls() {
        //	configuration of 3D
        c3d = {camz: 900, ang: 0, d: 0};


        w = window.innerWidth - 20;
        //h = $('#container').height();
        h = renderer.domElement.height;//$(window).height()*0.8;
        //console.log('W' + w + 'H' + h);
        hw = w / 2;
        hh = h / 2;
        labels = false;
        g = new Grapher2D();
        $('#container').mousedown(on_click);//look_for_selection);
        $('#container').dblclick(on_double_click);

        rebuildGraph();
        onEF();
        // Maybe the graphi is void? if so hook this
        if (data_graph.length == 0) {
            $('#waiting').html(_('threed.no_graph_data'));
        }
    }

    init_controls();


});



