# !/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.


class MassiveChangeData(object):
    def __init__(self, name, item, sources):
        self.name = name
        self.items_list = []
        self.sources_list = []
        self.add_item(item)
        self.add_sources(sources)
    
    
    def get_name(self):
        return self.name
    
    
    def get_items_list(self):
        return self.items_list
    
    
    def get_templates_list(self):
        return self.sources_list
    
    
    def add_item(self, item):
        if item not in self.items_list:
            self.items_list.append(item)
    
    
    def add_sources(self, sources):
        for src in sources:
            if not src in self.sources_list:
                self.sources_list.append(src)
