#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.


class MassiveChangeItemWithData(object):
    def __init__(self, name, uuid=""):
        self.name = name
        self.extra_class = ""
        self.set_uuid(uuid)
        self.data_list = []
    
    
    def get_name(self):
        return self.name
    
    
    def get_extra_class(self):
        return self.extra_class
    
    
    def set_uuid(self, to_set):
        self.uuid = to_set
        if self.uuid == "___ALL___":
            self.extra_class = "shinken-active"
    
    
    def get_uuid(self):
        return self.uuid
    
    
    def get_data_list(self):
        return self.data_list
    
    
    def get_data_number(self):
        return len(self.data_list)
    
    
    def add_data(self, data):
        if data not in self.data_list:
            self.data_list.append(data)
