#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

from .sourceinfoproperty import SourceInfoProperty
from ...dao.helpers import get_property_separator


class SourceInfo(object):
    
    @staticmethod
    def from_dict(source_dict, item_type):
        info = source_dict["_info"]
        if isinstance(source_dict["_info"], dict):
            info = {}
            for property_name, value in source_dict["_info"].iteritems():
                _separator = get_property_separator(item_type, property_name)
                info[property_name] = SourceInfoProperty.from_dict(value, _separator)
        
        return SourceInfo(item_type, _info=info)
    
    
    def as_dict(self):
        return {
            "_info": self.get_info_dict(),
        }
    
    
    def __init__(self, item_type, _info=None):
        self._info = _info or {}
        self._item_type = item_type
    
    
    def get_info(self):
        return self._info
    
    
    def get_info_dict(self):
        info_dict = {}
        for key, value in self._info.iteritems():
            info_dict[key] = value.as_dict()
        return info_dict
    
    
    def update_field(self, property_name, value, source, field_type=SourceInfoProperty.UNIQUE_TYPE, overwrite=False, force=False):
        _separator = get_property_separator(self._item_type, property_name)
        if property_name not in self._info.keys() or overwrite is True:
            self._info[property_name] = SourceInfoProperty(_separator, property_name=property_name, field_type=field_type, force=force)
        self._info[property_name].update(value, source)
    
    
    def get_property(self, property_name):
        _separator = get_property_separator(self._item_type, property_name)
        return self._info.get(property_name, SourceInfoProperty(_separator, property_name=property_name))
