#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.
from ..def_items import ITEM_TYPE
from contactitem import ContactItem
from misc_items import HostItem, ClusterItem, ServiceTemplateItem, HostGroupItem, ServiceItem, ContactTemplateItem, ContactGroupItem

from baseitem import BaseItem

TYPE_TO_CLASS = {
    ITEM_TYPE.CONTACTS           : ContactItem,
    ITEM_TYPE.CONTACTTPLS        : ContactTemplateItem,
    ITEM_TYPE.CONTACTGROUPS      : ContactGroupItem,
    
    ITEM_TYPE.CLUSTERS           : ClusterItem,
    ITEM_TYPE.CLUSTERTPLS        : ClusterItem,
    
    ITEM_TYPE.HOSTTPLS           : HostItem,
    ITEM_TYPE.HOSTS              : HostItem,
    ITEM_TYPE.HOSTGROUPS         : HostGroupItem,
    
    ITEM_TYPE.SERVICESHOSTS      : ServiceItem,
    ITEM_TYPE.SERVICESCLUSTERS   : ServiceItem,
    ITEM_TYPE.SERVICETPLS        : ServiceItem,
    
    ITEM_TYPE.SERVICESHOSTTPLS   : ServiceTemplateItem,
    ITEM_TYPE.SERVICESCLUSTERTPLS: ServiceTemplateItem,
    
}


def get_item_instance(item_type, default=None):
    ItemClass = TYPE_TO_CLASS.get(item_type, BaseItem)
    if default:
        return ItemClass(default)
    return ItemClass()
