var ITEM_TYPE = {
    ELEMENTS: 'elements',
    
    CLUSTERS   : 'clusters',
    CLUSTERTPLS: 'clustertpls',
    
    HOSTS     : 'hosts',
    HOSTTPLS  : 'hosttpls',
    HOSTGROUPS: 'hostgroups',
    
    SERVICESHOSTS      : 'serviceshosts',
    SERVICESHOSTTPLS   : 'serviceshosttpls',
    SERVICESCLUSTERS   : 'servicesclusters',
    SERVICESCLUSTERTPLS: 'servicesclustertpls',
    SERVICETPLS        : 'servicetpls',
    
    CONTACTS     : 'contacts',
    CONTACTTPLS  : 'contacttpls',
    CONTACTGROUPS: 'contactgroups',
    
    ESCALATIONS              : 'escalations',
    NOTIFICATIONWAYS         : 'notificationways',
    COMMANDS                 : 'commands',
    BUSINESSIMPACTMODULATIONS: 'businessimpactmodulations',
    MACROMODULATIONS         : 'macromodulations',
    RESULTMODULATIONS        : 'resultmodulations',
    TIMEPERIODS              : 'timeperiods',
    PACK                     : 'packs',
    PLUGIN                   : 'plugins',
    
    // These 2 object types are used to have a distinction between "my objects" and "all objects"
    WORKING_AREA   : 'working_area',
    MY_WORKING_AREA: 'my_working_area'
};
var AREAS     = {
    STAGING        : 'staging',
    WORKING_AREA   : 'working_area',
    MY_WORKING_AREA: 'my_working_area'
};
var CONTEXTS  = {
    success: "success",
    warning: "warning",
    error  : "error",
    beware : "beware",
    unknown: "unknown"
};
var MESSAGES  = {
    same: _( "element.tooltip_same" ),
    max : _( "element.tooltip_max" ),
    min : _( "element.tooltip_min" )
};
var REGEXS    = {
    MISSING_GLOBAL        : /__MISSING_GLOBAL__/g,
    MISSING_ARGN          : /__MISSING_ARGN__/g,
    UNKNOWN_DATA          : /__UNKNOWN_DATA__/g,
    MISSING_DFE           : /__MISSING_DFE__/g,
    PROTECTED_PASSWORD    : /__PROTECTED_PASSWORD__/g,
    DOUBLEDOLLAR          : /__DOUBLEDOLLAR__/g,
    // parse_dfe:       /\s*([^,]+?)\s*(?:\$\((.+?)\)\$)*(?:[,]|$)/g,
    parse_dfe             : /\s*([^,]+?)\s*(?:\$\((?:.+?)\)\$)*\s*(?:[,]|$)/g, // Allows to get the $key$ and is group of args.
    parse_dfe_args        : /\s*(?:\$\((.+?)\)\$)\s*/g, // Allows to match value in the group of args.
    parse_dfe_args_reverse: /\s*(?:\)\$(.+?)\$\()\s*/g, // Allows to match value out of the group of args, it mean the syntax  is not valid.
    parse_arguments       : /(\$.*?\$)/g
};

var App = {};
App.Elements = {};
App.Scope = (function ( self ) {
    "use strict";
    
    // Verbose levels
    var _debug = 0,
        _v     = (_debug >= 1),
        _vv    = (_debug >= 2),
        _vvv   = (_debug >= 3);
    
    // Public
    /**
     * Generate something that it look like to a uid.
     * @returns {string}
     */
    self.generateUuid = function () {
        function s4 () {
            return Math.floor( (1 + Math.random()) * 0x10000 )
                       .toString( 16 )
                       .substring( 1 );
        }
        
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    };
    /**
     * Translate tool, allows to add variable easily in text.
     * @returns {*}
     */
    self.format = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.isInteger = function ( x ) {
        return (typeof x === 'number') && (x % 1 === 0);
    };
    /**
     * Allows to adjust the size of the $bottom contained in $container, relative to the $top.
     * @param $top
     * @param $bottom
     * @param $container
     * @param forceTop
     */
    self.adjustHeight = function ( $top, $bottom, $container, forceTop ) {
        forceTop         = (forceTop === false || forceTop) ? forceTop : true;
        var topHeight    = ($top.height() == 0) ? 0 : $top.outerHeight( true );    // Give the height with the margin and padding if the element is not display: none.
        var bottomHeight = ($bottom.height() == 0) ? 0 : $bottom.outerHeight( true ); // Give the height with the margin and padding if the element is not display: none.
        
        var containerHeight       = $container.height(); // Give the size with the padding.
        var height_already_adjust = (bottomHeight + topHeight) !== containerHeight;
        
        if ( height_already_adjust ) {
            if ( forceTop ) {
                $bottom.css( 'top', topHeight );
            }
            // We get the margin apply to the container.
            var marginTop    = $bottom.css( 'margin-top' );
            var marginBottom = $bottom.css( 'margin-bottom' );
            marginTop        = (marginTop) ? marginTop.replace( 'px', '' ) : 0;
            marginBottom     = (marginBottom) ? marginBottom.replace( 'px', '' ) : 0;
            
            var margin = parseInt( marginTop ) + parseInt( marginBottom );
            $bottom.css( 'height', (containerHeight - topHeight) - margin );
        }
    };
    self.resetAdjustHeight = function ( $target ) {
        $target.css( 'height', '' );
        $target.removeAttr( 'style' );
    };
    // TODO: Temp
    self.adjustHeightMulti = function ( $top, $bottom, $container, forceTop ) {
        for ( var i = 0, l = $top.length; i > l; i++ ) {
            var _$top           = $top[ i ],
                _$bottom        = $bottom[ i ],
                _$container     = $container[ i ];
            forceTop            = (forceTop === false || forceTop) ? forceTop : true;
            var topHeight       = _$top.outerHeight( true ),    // Give the height with the margin.
                bottomHeight    = _$bottom.outerHeight( true ); // Give the height with the margin.
            var containerHeight = _$container.height(), // Give the size with the padding.
                calcul          = (bottomHeight + topHeight);
            // console.log( 'app new', containerHeight, '-', topHeight, '=', containerHeight - topHeight );
            if ( calcul !== containerHeight ) {
                if ( forceTop ) {
                    _$bottom.css( 'top', topHeight );
                }
                // We get the margin apply to the container.
                var margin       = 0,
                    marginTop    = _$bottom.css( 'margin-top' ),
                    marginBottom = _$bottom.css( 'margin-bottom' );
                marginTop        = (marginTop) ? marginTop.replace( 'px', '' ) : 0;
                marginBottom     = (marginBottom) ? marginBottom.replace( 'px', '' ) : 0;
                margin           = parseInt( marginTop ) + parseInt( marginBottom );
                _$bottom.css( 'height', (containerHeight - topHeight) - margin );
            }
        }
    };
    
    /**
     * Sort JavaScript Object
     * order = 'asc' or 'desc'
     */
    self.sortObj = function ( obj, order ) {
        var keys    = Object.keys( obj ),
            tempObj = {};
        keys.sort(
            function ( a, b ) {
                return a.toLowerCase().localeCompare( b.toLowerCase() );
            }
        );
        if ( order === 'desc' ) {
            for ( var i = keys.length - 1; i >= 0; i-- ) {
                tempObj[ keys[ i ] ] = obj[ keys[ i ] ];
            }
        }
        else {
            for ( var i = 0, l = keys.length; i < l; i++ ) {
                tempObj[ keys[ i ] ] = obj[ keys[ i ] ];
            }
        }
        return tempObj;
    };
    // TODO todo logger system
    self.debug = function ( text ) {
        if ( level < 1 ) {
            console.log( text );
        }
    };
    self.info  = function ( text ) {
        if ( level < 2 ) {
            console.log( text );
        }
    };
    self.error = function ( text ) {
        if ( level < 3 ) {
            console.log( text );
        }
    };
    
    
    return self;
})( App.Scope || {} );
/**
 *
 * @deprecated V02.06
 */
App.Scope.Tags = (function ( self, Tooltip ) {
    "use strict";
    
    var config = {
        defaults: {
            id     : '',
            class  : '',
            clear  : false,
            context: 'error',
            message: '',
            html   : true,
            auto   : true,
            show   : 'mouseenter',
            hide   : 'mouseleave'
        }
    };
    
    // Public
    self.create  = function ( label, options ) {
        return this.set( $( '<span/>' ), label, options );
    };
    self.set     = function ( $tag, label, options ) {
        options = options || {};
        options = $.extend( {}, config.defaults, options );
        
        (options.html) ? $tag.html( label ) : $tag.text( label );
        
        if ( options.id ) {
            $tag.attr( 'id', options.id );
        }
        
        $tag.removeClass( 'tag-success tag-info tag-warning tag-error tag-beware' );
        $tag.addClass( (!options.clear) ? 'tag tag-' + options.context + ' tag-btn-js '.concat( options.class ) : options.class );
        
        if ( options.message ) {
            $tag.on( options.show, function () {
                Tooltip.reset();
                Tooltip.create( $( this ), options.message, { context: options.context } );
            } );
            if ( options.auto === true ) {
                $tag.on( options.hide, function () {
                    Tooltip.destroy( $( this ) );
                } );
            }
        }
        return $tag;
    };
    self.destroy = function ( element ) {
        element.remove();
    };
    
    return self;
})( App.Scope.Tags || {}, App.Scope.Tooltips || {} );
/**
 * Scope MANAGER helpers.
 */
App.StorageManager = (function ( self ) {
    "use strict";
    
    var config = {
        defaults: {
            isPersistent: false,
            prefix      : 'shinken_'
        }
    };
    
    // Private
    var _list  = [ localStorage, sessionStorage ],
        _param = function ( options ) {
            options = options || {};
            return $.extend( {}, config.defaults, options );
        };
    
    // Public
    self.setItem          = function ( id, value, options ) {
        options = _param( options );
        var storage = (options.isPersistent) ? localStorage : sessionStorage;
        try {
            storage.setItem( options.prefix.concat( id ), JSON.stringify( value ) );
        }
        catch ( e ) {
            storage.clear();
        }
        
        return value;
    };
    self.getItem          = function ( id, options ) {
        options = _param( options );
        
        var result = null;
        for ( var i = 0, l = _list.length; i < l; i++ ) {
            var storage = _list[ i ];
            result      = JSON.parse( storage.getItem( options.prefix.concat( id ) ) );
            if ( result ) {
                break;
            }
        }
        return result;
    };
    self.removeItem       = function ( id, options ) {
        options     = _param( options );
        var storage = (options.isPersistent) ? localStorage : sessionStorage;
        storage.getItem( options.prefix.concat( id ) );
    };
    self.clear            = function () {
        sessionStorage.clear();
        localStorage.clear();
    };
    self.getSizeOfStorage = function () {
        var _lsTotal = 0,
            total,
            _xLen,
            _x;
        for ( var i = 0, l = _list.length; i < l; i++ ) {
            var storage = _list[ i ];
            for ( _x in storage ) {
                _xLen = ((storage[ _x ].length + _x.length) * 2);
                _lsTotal += _xLen;
                // console.log( (_xLen / 1024).toFixed( 2 ) + " KB = " + ((i == 1) ? 'localStorage: ' : 'sessionStorage: ') + _x.substr( 0, 50 ) );
            }
        }
        total = (_lsTotal / 1024).toFixed( 2 );
        // console.log( "Total = " + total + " KB" );
        return total;
    };
    
    return self;
})( App.StorageManager || {} );
App.HistoryManager = (function ( self, Scope, Storage ) {
    "use strict";
    
    var config = {
        defaults: {
            url   : '/',                // Default page if no previous page.
            prefix: 'shinken_history_', // The cookie or storage prefix.
            limit : '50'                // The number of pages that can be traced.
        }
    };
    
    // Private
    var _uid      = null,
        _handlers = null;
    
    // Verbose levels
    var _debug = 0,
        _v     = (_debug >= 1), // public
        _vv    = (_debug >= 2), // private
        _vvv   = (_debug >= 3); // other
    
    var _getRootUrl        = function () {
        var _urlName  = window.location.pathname,
            _urlParam = window.location.search;
        return (_urlParam) ? _urlName.concat( _urlParam ) : _urlName;
    };
    var _getHistoryStorage = function ( id, valueDefault, options ) {
        var data = Storage.getItem( id, options );
        if ( !data ) {
            Storage.setItem( id, data = valueDefault || '', options );
        }
        return data;
    };
    var _getHandlers       = function ( attr ) {
        if ( _handlers && (_uid in _handlers) && (attr in _handlers[ _uid ]) ) {
            return _handlers[ _uid ][ attr ];
        }
        else {
            console.error( Scope.format( 'History, the {0} asked does not exist', attr ) );
        }
    };
    var _setTime           = function () {
        var now                     = new Date().getTime();
        _handlers[ _uid ][ 'time' ] = now;
        return now;
    };
    var _getDate           = function ( date ) {
        var date    = new Date( date ),
            hours   = date.getHours(),
            minutes = "0" + date.getMinutes(),
            seconds = "0" + date.getSeconds();
        // Will display time in 10:30:23 format.
        return hours + ':' + minutes.substr( -2 ) + ':' + seconds.substr( -2 );
    };
    
    // Get history of last tab to put it in the new one.
    var _initListenerActiveTab  = function () {
        // Set the name of the hidden property and the change event for visibility
        var hidden,
            visibilityChange;
        if ( typeof document.hidden !== "undefined" ) { // Opera 12.10 and Firefox 18 and later support
            hidden           = "hidden";
            visibilityChange = "visibilitychange";
        }
        else if ( typeof document.msHidden !== "undefined" ) {
            hidden           = "msHidden";
            visibilityChange = "msvisibilitychange";
        }
        else if ( typeof document.webkitHidden !== "undefined" ) {
            hidden           = "webkitHidden";
            visibilityChange = "webkitvisibilitychange";
        }
        
        var handleVisibilityChange = function () {
            if ( !document[ hidden ] ) {
                // Tab is active
                // Save
                self.setHandlers();
            }
        };
        
        // Warn if the browser doesn't support addEventListener or the Page Visibility API
        if ( typeof document.addEventListener === "undefined" || typeof document[ hidden ] === "undefined" ) {
            console.error( "This browser doesn't support the Page Visibility API" );
        }
        else {
            // Handle page visibility change
            document.addEventListener( visibilityChange, handleVisibilityChange, false );
        }
    };
    var _getLastActiveTab       = function () {
        var tabs = Object.keys( _handlers ),
            time = new Date( '1980-01-01' ).getTime();
        
        // uid of the last used tab.
        var resultUid = _uid; //.slice(0, -1) ; // Clone for be sure.
        for ( var i = 0, l = tabs.length; i < l; i++ ) {
            var uid = tabs[ i ];
            if ( _uid === uid ) { // it's me.
                continue;
            }
            if ( time < _handlers[ uid ][ 'time' ] ) {
                time      = _handlers[ uid ][ 'time' ];
                resultUid = uid; //.slice(0, -1); // Clone for be sure.
                // console.info( 'lastActive =', resultUid,' - ', time, _getDate(time));
            }
        }
        return resultUid;
    };
    var _cloneActiveTabToNewOne = function () {
        var uid = _getLastActiveTab();
        if ( _uid !== uid ) {
            _handlers[ _uid ][ 'histories' ] = _handlers[ uid ][ 'histories' ];
        }
    };
    
    // Public
    self.uid         = function () {
        return _uid = "shinken-history";
    };
    self.setUid      = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::setUid' );
        }
        return Storage.setItem( 'uid', _uid, { prefix: config.defaults.prefix } );
    };
    self.handlers    = function () {
        _handlers = (_handlers) ? _handlers : _getHistoryStorage( 'handlers', {}, { prefix: config.defaults.prefix, isPersistent: true } );
        if ( !_handlers[ _uid ] ) {
            _handlers[ _uid ] = {
                histories: [],
                page     : 0, //-1, // => config.defaults.url;
                time     : (new Date().getTime())
            };
            // Check if other tab and clone it.
            _cloneActiveTabToNewOne();
            this.setHandlers();
        }
        return _handlers;
    };
    self.setHandlers = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::setHandlers' );
            console.info( 'App.HistoryManager::setHandlers', _handlers[ _uid ], ' at', _getDate( _handlers[ _uid ][ 'time' ] ), true );
        }
        return Storage.setItem( 'handlers', _handlers, { prefix: config.defaults.prefix, isPersistent: true } );
    };
    
    // Getter of handlers object.
    self.histories = function () {
        return _getHandlers( 'histories' );
    };
    self.page      = function () {
        return _getHandlers( 'page' );
    };
    self.time      = function () {
        return _getHandlers( 'time' );
    };
    
    /***************************
     * INITIALIZATION
     ***************************/
    self.init = function () {
        if ( typeof localStorage === 'undefined' ) {
            console.error( "This browser doesn't support the localStorage" );
        }
        if ( typeof sessionStorage === 'undefined' ) {
            console.error( "This browser doesn't support the sessionStorage" );
        }
        if ( App.StorageManager.getSizeOfStorage() >= 1000 ) { // If size >= 1 Mo
            Storage.clear();
            console.info( 'App.HistoryManager::init - The storage has been cleaned' );
        }
        this.uid();
        this.handlers();
        
        if ( _v ) {
            console.info( 'App.HistoryManager::init ', _handlers[ _uid ], ' at', _getDate( _handlers[ _uid ][ 'time' ] ) );
            if ( _vvv ) {
                console.log( 'App.HistoryManager::init - uid      ( sessionsStorage ) ', _uid );
                console.log( 'App.HistoryManager::init - handlers ( localStorage )    ', _handlers );
                console.log( 'App.HistoryManager::init - handlers.uid.history', _handlers[ _uid ][ 'histories' ] );
                console.log( 'App.HistoryManager::init - handlers.uid.page', _handlers[ _uid ][ 'page' ] );
            }
            window.ShinkenHistory = App.HistoryManager;
        }
        
        this.save();
        _initListenerActiveTab();
    };
    
    self.save     = function () {
        // Same page or what!
        if ( this.current() !== _getRootUrl() ) {
            var histories = this.histories();
            // Allows to put a limit to the history.
            if ( histories.length > config.defaults.limit - 1 ) {
                histories.shift();
            }
            histories.push( _getRootUrl() );
            // set time
            _setTime();
            // _setPage(0);
            // Save
            this.setHandlers(); // Save
            if ( _v ) {
                console.info( 'App.HistoryManager::save', true );
            }
        }
        else {
            if ( _v ) {
                console.info( 'App.HistoryManager::save', false );
            }
        }
    };
    self.getUrl   = function ( indice ) {
        if ( _v ) {
            console.log( 'App.HistoryManager::get - indice', indice );
        }
        
        if ( (indice) ? true : (indice === 0) ) {
            if ( indice !== parseInt( indice, 10 ) ) {
                return config.defaults.url;
            }
            
            var histories = this.histories(),
                l         = histories.length,
                index     = 0; // this.page() + indice;
            
            if ( indice <= 0 ) {
                index = l + indice - 1;
            }
            
            if ( histories.hasOwnProperty( index ) ) { // In the array
                return histories[ index ];
            }
            else { // Out the array.
                return config.defaults.url;
            }
        }
        else {
            console.error( 'History::get, Missing arg indice.' );
        }
    };
    self.setUrl   = function ( indice, url ) {
        var histories = this.histories(),
            l         = histories.length,
            index     = 0;
        
        if ( indice <= 0 ) {
            index = l + indice - 1;
        }
        
        if ( histories.hasOwnProperty( index ) ) { // In the array
            _handlers[ _uid ][ 'histories' ][ index ] = url;
            this.setHandlers(); // Save
        }
        else { // Out the array.
            console.error( 'History::set, Previous url is missing, can\'t be update.' );
        }
    };
    self.rollback = function () {
        if ( _v ) {
            console.log( 'App.HistoryManager::rollback' );
        }
        this.histories().pop();
        this.setHandlers();
    };
    
    /**
     * TODO
     **/
    // // Action save or delete in histories array.
    // self.save     = function() {
    //     var histories = this.histories(),
    //         page      = this.page();
    //
    //     // Same page or what!
    //     if ( this.current() !== _getRootUrl() ) {
    //         // Allows to put a limit to the history.
    //         console.log('save', histories, ' - ', histories.length, ' > ', config.defaults.limit - 1 )
    //         if ( histories.length > config.defaults.limit - 1 ) {
    //             histories.shift();
    //         }
    //         // Allows to remove all urls after the current page.
    //         if ( histories.length && page !== histories.length - 1 ) { // No the last index.
    //             histories.length = page + 1;
    //         }
    //
    //         // Set
    //         histories.push( _getRootUrl() );
    //         _setPage( +1 );
    //         _setTime();
    //         this.setHandlers(); // Save
    //
    //         if ( _v ) {
    //             console.info( 'App.HistoryManager::save', true );
    //         }
    //     } else {
    //         if ( _v ) {
    //             console.info( 'App.HistoryManager::save', false );
    //         }
    //     }
    // };
    // self.rollback = function() {
    //     if ( _v ) {
    //         console.log( 'App.HistoryManager::rollback' );
    //     }
    //     // Set
    //     this.histories().pop();
    //     _setPage( -1 );
    //     _setTime();
    //     this.setHandlers(); // Save
    // };
    //
    // // Allows to retrieve or change a specific url.
    // self.getUrl = function( indice ) {
    //     var index     = _getPage( indice ),
    //         histories = this.histories();
    //     if ( histories.hasOwnProperty( index ) ) { // In the array
    //         return histories[ index ];
    //     } else { // Out the array.
    //         return config.defaults.url;
    //     }
    // };
    // self.setUrl = function( indice, url ) {
    //     var index     = _getPage( indice ),
    //         histories = this.histories();
    //     if ( histories.hasOwnProperty( index ) ) { // In the array
    //         _handlers[ _uid ][ 'histories' ][ index ] = url;
    //         this.setHandlers(); // Save
    //     } else { // Out the array.
    //         console.error( 'History::set, Previous url is missing, can\'t be update.' );
    //     }
    // };
    
    // Getter Urls
    self.previous = function () {
        return this.getUrl( -1 );
    };
    self.current = function () {
        return this.getUrl( 0 );
    };
    self.next    = function () {
        return this.getUrl( +1 );
    };
    
    // Redirection - Go to Url
    self.back    = function () {
        location.assign( this.previous() );
    };
    self.forward = function () {
        location.assign( this.next() );
    };
    
    /**
     * TODO
     **/
    // self.back    = function() {
    //     _setPage( -1 );
    //     _setTime();
    //     this.setHandlers(); // Save
    //     location.assign( this.previous() );
    // };
    // self.forward = function() {
    //     var histories = this.histories().length,
    //         page      = this.page();
    //     console.log('page', page+1, 'loo', histories.length);
    //     if ( histories.length && page+1 > histories.length ) { // No the last index.
    //         var url = this.next();
    //         _setPage( +1 );
    //         _setTime();
    //         this.setHandlers(); // Save
    //         location.assign( url );
    //     } else {
    //         location.assign( config.defaults.url );
    //     }
    // };
    
    return self;
})( App.HistoryManager || {}, App.Scope || {}, App.StorageManager || {} );

// Call directly - Closure
(function () {
    "use strict";
    App.HistoryManager.init();
})();

// Call went the DOM is loaded.
$( document ).ready( function () {
    var _initEvents = function () {
        $( 'body' ).on( 'click', function ( e ) {
            // Did not click a element with tooltip, so we hide all.
            if ( typeof $( e.target ).data( 'original-title' ) === 'undefined' ) {
                $( ".tooltip-custom" ).hide();
            }
            SHINKEN_TOOLTIP.hideTooltip();
        } );
    };
    _initEvents();
    
    /**
     * History - exceptionSetBackUrl - After created a new elements,
     * we changes every time the back url to "my_working_area"
     */
    (function () {
        var isNewElement  = false,
            isWorkingArea = false;
        
        if ( typeof(is_new_object) !== "undefined" ) {
            isNewElement = is_new_object;
        }
        if ( typeof(working_area) !== "undefined" ) {
            isWorkingArea = working_area;
        }
        var $form = $( document.forms[ 'form-element' ] ),
            type  = $form.data( 'type' );
        //if ( isWorkingArea && !isNewElement ) {
        //    type    = (type) ? type : 'hosts'; // TODO: Temp
        //    var url = '/elements/working_area/'.concat( type );
        //    // Set the back url.
        //    App.HistoryManager.setUrl( -1, url );
        //}
    })();
} );

