g_ask_menu_update_on_going = false;

function ask_menu_update() {
    if ( g_ask_menu_update_on_going || SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
        return;
    }
    g_ask_menu_update_on_going = true;
    
    function call_for_stats() {
        $.ajax( {
            url    : '/stats/configuration?ts=' + Date.now(),
            success: function( data ) {
                if ( typeof hook_call_configuration == 'function' ) {
                    hook_call_configuration( data );
                }
                _menu_update_stats( data );
                g_ask_menu_update_on_going = false;
            },
            error  : function( data, txt ) {
                console.error( 'Got bad result for asking changes stats (' + txt + ')' );
                SHINKEN.COMMUNICATION.handleResponse( data.status );
                _menu_update_stats( data );
                g_ask_menu_update_on_going = false;
            }
        } );
    }
    
    setTimeout( call_for_stats, 500 );
}


function getCounterMenuNumber( name, type, configuration_stats ) {
    var _to_return;
    switch ( name ) {
        case 'elements':
            if ( type == 'proposed' ) {
                _to_return = configuration_stats[ 'detail' ][ name ][ type ][ 1 ];
            }
            else {
                _to_return = configuration_stats[ 'detail' ][ name ][ type ] - configuration_stats[ 'detail' ][ 'hosts' ][ type ];
            }
            break;
        default:
            if ( type == 'proposed' ) {
                _to_return = configuration_stats[ 'detail' ][ name ][ type ][ 1 ];
            }
            else {
                _to_return = configuration_stats[ 'detail' ][ name ][ type ];
            }
            break;
    }
    return _to_return;
}

function getCounterHeaderNumber( counter_name, configuration_stats ) {
    var _to_return = "";
    if ( counter_name === 'working-area-edition' ) {
        _to_return = configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 0 ] + configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 1 ];
    }
    else if ( counter_name === 'working-area-rejected' ) {
        _to_return = configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 0 ] + configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 1 ];
    }
    else if ( counter_name === 'working-area-new' ) {
        _to_return = configuration_stats[ 'detail' ][ 'hosts' ][ 'new' ];
    }
    else if ( counter_name === 'working-area-difference' ) {
        _to_return = configuration_stats[ 'detail' ][ 'hosts' ][ 'change' ];
    }
    else if ( counter_name === 'stagging-area-new' ) {
        _to_return = configuration_stats[ 'overall' ][ 'new' ] - configuration_stats[ 'detail' ][ 'hosts' ][ 'new' ];
    }
    else if ( counter_name === 'stagging-area-difference' ) {
        _to_return = configuration_stats[ 'overall' ][ 'change' ] - configuration_stats[ 'detail' ][ 'hosts' ][ 'change' ];
    }
    else if ( counter_name === 'stagging-area-proposed' ) {
        _to_return = configuration_stats[ 'overall' ][ 'proposed' ][ 1 ];
    }
    else if ( counter_name === 'apply' ) {
        _to_return = configuration_stats[ 'overall' ][ 'to_apply' ];
    }
    
    return _to_return;
}

function getCounterHeaderLabel( counter_name, configuration_stats, number ) {
    var _to_return = "";
    switch ( counter_name ) {
        case 'working-area-edition':
            var _filters = '?filter=type:!' + _( 'element.new' ) + '~working_area_status:' + _( 'element.WORKING' );
            _to_return   = "[<span class='shinken-counter-hover' onclick=\"SHINKEN.HIGHWAY.goTo('/elements/my_working_area/hosts'" + _filters + ", event);\">" + configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 0 ] + "</span>/<span class=\"shinken-counter-hover\">" + configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 1 ] + "</span>]";
            break;
        case 'working-area-rejected':
            var _filters = '?filter=working_area_status:' + _( 'element.WORKING' );
            _to_return   = "[<span class='shinken-counter-hover' onclick=\"SHINKEN.HIGHWAY.goTo('/elements/my_working_area/hosts" + _filters + ", event);\">" + configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 0 ] + "</span>/<span class=\"shinken-counter-hover\">" + configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 1 ] + "</span>]";
            break;
        case 'apply':
            _to_return = "<span class='shinken-counter-hover'>" + number + "</span>";
            break;
        default:
            _to_return = "[<span class='shinken-counter-hover'>" + number + "</span>]";
    }
    return _to_return;
}

function getCounterHeaderTooltip( counter_name, configuration_stats ) {
    var _to_return = "";
    switch ( counter_name ) {
        case 'working-area-edition':
            _to_return = SHINKEN.TOOLS.STRING.format( _( "header.working_hover_text" ), configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 0 ], configuration_stats[ 'detail' ][ 'hosts' ][ 'working_area' ][ 1 ] );
            break;
        case 'working-area-rejected':
            _to_return = SHINKEN.TOOLS.STRING.format( _( "header.rejected_hover_text" ), configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 0 ], configuration_stats[ 'detail' ][ 'hosts' ][ 'rejected' ][ 1 ] );
            break;
    }
    return _to_return;
}

function updateheaderCounter( counter_name, configuration_stats ) {
    var _counter = MANAGER.__instance_counter_distributor.findCounter( counter_name );
    if ( !_counter ) {
        console.warn( "[app.js]", "[update_counter]", "counter not found", counter_name );
        return;
    }
    var _number = getCounterHeaderNumber( counter_name, configuration_stats );
    if ( !_number ) {
        _counter.update( "counter", "" );
        return;
    }
    _counter.update( "counter", getCounterHeaderLabel( counter_name, configuration_stats, _number ), getCounterHeaderTooltip( counter_name, configuration_stats ) );
}

function _menu_update_stats( _data ) {
    if ( _data[ 'error' ] ) {
        console.error( "_menu_update_stats", _data );
        return;
    }
    if ( !_data[ 'detail' ] ) {
        return;
    }
    // WORK AREA ZONE
    updateheaderCounter( 'working-area-edition', _data );
    updateheaderCounter( 'working-area-rejected', _data );
    if ( MANAGER.__instance_element_distributor.current_user.is_admin ) {
        updateheaderCounter( 'working-area-new', _data );
        updateheaderCounter( 'working-area-difference', _data );
    }
    // STAGGING ZONE
    if ( MANAGER.__instance_element_distributor.current_user.is_admin ) {
        updateheaderCounter( 'stagging-area-new', _data );
        updateheaderCounter( 'stagging-area-difference', _data );
    }
    updateheaderCounter( 'stagging-area-proposed', _data );
    //PRODUCTION
    updateheaderCounter( 'apply', _data );
    if ( MANAGER.__instance_element_distributor.current_user.is_admin ) {
        var _keys = Object.keys( _data[ 'detail' ] );
        var _current_key;
        var _current_menu;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            
            _current_menu     = MANAGER.__instance_window_distributor.findWindow( 'menu-' + _current_key, true );
            var _keys_counter = Object.keys( _current_menu.counters );
            for ( var k = 0, _size_k = _keys_counter.length; k < _size_k; k++ ) {
                _current_menu.updateCounter( _keys_counter[ k ], getCounterMenuNumber( _current_key, _keys_counter[ k ], _data ) );
            }
        }
    }
}

