SHINKEN.TOOLS.TEST_AUTO_LIST_ALL = (function ( self ) {
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.getMassActionContainer              = function () {
        return document.getElementById( "id-shinken-select-mass-action" );
    };
    self.getMassActionSelector               = function () {
        return self.getMassActionContainer().querySelector( ".shinken-select-selector" );
    };
    self.getMassActionOptions                = function () {
        return self.getMassActionContainer().querySelectorAll( ".shinken-option" );
    };
    //********************************************  ACTION   **************************************************//
    self.selectShinkenElement                = function ( timeout, test_type ) {
        setTimeout( function () {
            if ( !test_type ) {
                test_type = __shinken_test_type;
            }
            switch ( test_type ) {
                case "00067":
                case "00068":
                case "00069":
                case "00070":
                case "00071":
                case "00072":
                case "00073":
                case "00074":
                case "00075":
                case "00076":
                case "00077":
                case "00078":
                case "00079":
                case "00080":
                case "00082":
                case "00083":
                case "00092":
                case "00093":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    break;
                case "00082-3":
                case "00082-6":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000002" ).click();
                    document.getElementById( "01000000000000000000000000000000" ).click();
                    break;
                case "00083-3":
                case "00083-6":
                case "00083-8":
                    document.getElementById( "00000000000000000000000000000001" ).click();
                    document.getElementById( "00000000000000000000000000000002" ).click();
                    break;
                default:
                    document.getElementById( "all-changes-checkbox" ).click();
                    break;
            }
        }, timeout );
        return 300;
    };
    self.selectMassAction                    = function ( timeout, mass_action_name ) {
        setTimeout( function () {
            document.querySelector( "#id-shinken-select-mass-action .shinken-option[data-key-name='" + mass_action_name + "']" ).click();
        }, timeout );
        return 100;
    };
    self.clickOnExecuteMassAction            = function ( timeout ) {
        setTimeout( function () {
            var _button = document.getElementById( 'btn-action-launch' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO.getNextPhaseLink();
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            
        }, timeout );
        return 1000;
    };
    self.clickOnExecuteMassActionWithComment = function ( timeout ) {
        setTimeout( function () {
            document.getElementById( "btn-action-launch" ).click();
        }, timeout );
        return 1000;
    };
    self.simulatePressEnterToValid           = function ( timeout, filter_name, _avoid_next_phase ) {
        setTimeout( function () {
            setTimeout( function () {
                if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                    if ( !_avoid_next_phase ) {
                        SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO.getNextPhaseLink() );
                    }
                    var _dom_element = MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.dom_element;
                    SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _dom_element, 'click' );
                    setTimeout( function (  ) {
                        SHINKEN.TOOLS.TEST_AUTO.___dispatchEnterKeyEvent( _dom_element, "keydown" );
                    }, 300 )
                }
            }, 1000 );
        }, timeout );
        return 3000;
    };
    self.switchMassActionSelectorState       = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.getMassActionSelector() );
        }, timeout );
        return 100;
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.enterFilter                         = function ( filter_name, value ) {
        MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules = MANAGER.__instance_filter_distributor.getElement( filter_name ).component.input.validation_rules_not_focus;
        MANAGER.__instance_filter_distributor.getElement( filter_name ).setValue( value );
        MANAGER.__instance_filter_distributor.getElement( filter_name ).askComputeAfterChange();
    };
    //********************************************  TEST   **************************************************//
    self.testElementsNumber                  = function ( timeout, nb_total, nb_new, nb_diff ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-list-element-number" ), nb_total, "nb élement total de la liste" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-new-list-element-number" ), nb_new, "nb élement total de la liste en nouveau" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "id-shinken-total-diff-list-element-number" ), nb_diff, "nb élement total de la liste en difference" );
        }, timeout );
        return 50;
    };
    self.testFilterValidation                = function ( timeout, filter_name, value, nb_error_expected, _nb_warning_expected ) {
        setTimeout( function () {
            self.enterFilter( filter_name, value );
            SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER.validation_value( 300, filter_name, nb_error_expected, _nb_warning_expected, value );
        }, timeout );
        return 1000;
    };
    self.validMassActionsOptions             = function ( timeout, nb_actions ) {
        setTimeout( function () {
            self.switchMassActionSelectorState( 0 );
            var _options = self.getMassActionOptions();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _options, nb_actions, "nb options" );
            for ( var i = 0, _size_i = _options.length; i < _size_i; i++ ) {
                self.__validMassActionOptionCounter( _options[ i ] );
                SHINKEN.TOOLS.TEST_AUTO.___dispatchMouseEvent( _options[ i ], 'mouseenter' );
            }
        }, timeout );
        return 100;
    };
    //********************************************  PRIVATE   **************************************************//
    self.__validMassActionOptionCounter      = function ( option ) {
        var _value          = "";
        var _display        = "block";
        var _pointer_events = "none";
        var _case           = __shinken_test_type + "-" + __phase + "-" + option.dataset.keyName + "-" + option.dataset.state;
        var _under_filter   = '';
        switch ( option.dataset.keyName ) {
            case ACTIONS.NONE:
                _display = 'none';
                break;
        }
        switch ( _case ) {
            case "00082-7-submit-mass-action-work-area":
            case "00082-7-unlock-mass-action-work-area":
            
            case "00082-8-submit-mass-action-work-area":
            case "00082-8-unlock-mass-action-work-area":
            
            case "00082-9-submit-mass-action-work-area":
            case "00082-9-unlock-mass-action-work-area":
                _display = 'none';
                break;
        }
        switch ( _case ) {
            case "00082-2-massive_change-mass-action-work-area":
            case "00082-2-disable-mass-action-work-area":
            case "00082-2-delete-mass-action-work-area":
            case "00082-2-clone-mass-action-work-area":
            case "00082-2-create_from-mass-action-work-area":
            
            case "00082-3-enable-mass-action-work-area":
            case "00082-3-disable-mass-action-work-area":
            case "00082-3-import-mass-action-work-area":
            
            case "00082-5-massive_change-mass-action-work-area":
            case "00082-5-enable-mass-action-work-area":
            case "00082-5-delete-mass-action-work-area":
            case "00082-5-clone-mass-action-work-area":
            case "00082-5-create_from-mass-action-work-area":
            case "00082-5-submit-mass-action-work-area":
            case "00082-5-unlock-mass-action-work-area":
            
            case "00082-6-massive_change-mass-action-work-area":
            case "00082-6-enable-mass-action-work-area":
            case "00082-6-delete-mass-action-work-area":
            case "00082-6-import-mass-action-work-area":
            case "00082-6-apply-mass-action-work-area":
            case "00082-6-reject-mass-action-work-area":
            
            case "00082-8-clone-mass-action-work-area":
            case "00082-8-create_from-mass-action-work-area":
            case "00082-8-apply-mass-action-work-area":
            case "00082-8-reject-mass-action-work-area":
            
            case "00082-9-massive_change-mass-action-work-area":
            case "00082-9-enable-mass-action-work-area":
            case "00082-9-delete-mass-action-work-area":
            case "00082-9-clone-mass-action-work-area":
            case "00082-9-create_from-mass-action-work-area":
            
            case "00083-2-massive_change-mass-action-work-area":
            case "00083-2-disable-mass-action-work-area":
            case "00083-2-delete-mass-action-work-area":
            case "00083-2-clone-mass-action-work-area":
            case "00083-2-create_from-mass-action-work-area":
            
            case "00083-3-enable-mass-action-work-area":
            case "00083-3-disable-mass-action-work-area":
            
            case "00083-5-massive_change-mass-action-work-area":
            case "00083-5-enable-mass-action-work-area":
            case "00083-5-delete-mass-action-work-area":
            case "00083-5-clone-mass-action-work-area":
            case "00083-5-create_from-mass-action-work-area":
            
            case "00083-6-massive_change-mass-action-work-area":
            case "00083-6-enable-mass-action-work-area":
            case "00083-6-delete-mass-action-work-area":
            case "00083-6-apply-mass-action-work-area":
            case "00083-6-reject-mass-action-work-area":
            
            case "00083-8-enable-mass-action-work-area":
            case "00083-8-disable-mass-action-work-area":
            
            case "00085-2-import-mass-action":
                _value = 1;
                break;
            case "00082-3-massive_change-mass-action-work-area":
            case "00082-3-delete-mass-action-work-area":
            case "00082-3-clone-mass-action-work-area":
            case "00082-3-create_from-mass-action-work-area":
            
            case "00083-3-massive_change-mass-action-work-area":
            case "00083-3-delete-mass-action-work-area":
            case "00083-3-clone-mass-action-work-area":
            case "00083-3-create_from-mass-action-work-area":
            
            case "00082-6-clone-mass-action-work-area":
            case "00082-6-create_from-mass-action-work-area":
            
            case "00083-6-clone-mass-action-work-area":
            case "00083-6-create_from-mass-action-work-area":
            
            case "00083-8-massive_change-mass-action-work-area":
            case "00083-8-delete-mass-action-work-area":
            case "00083-8-clone-mass-action-work-area":
            case "00083-8-create_from-mass-action-work-area":
                _value = 2;
                break;
            case "00084-2-enable-mass-action-work-area":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_disabled;
                break;
            case "00084-2-disable-mass-action-work-area":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host - SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_disabled;
                break;
            case "00084-2-delete-mass-action-work-area":
            case "00084-2-clone-mass-action-work-area":
            case "00084-2-create_from-mass-action-work-area":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host;
                break;
            case "00084-2-enable-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tlp_disabled;
                break;
            case "00084-2-disable-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tpl - SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tlp_disabled;
                break;
            case "00084-2-delete-mass-action":
            case "00084-2-clone-mass-action":
            case "00084-2-create_from-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tpl;
                break;
            case "00084-2-import-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tpl_new;
                break;
            case "00085-2-enable-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tlp_disabled;
                break;
            case "00085-2-disable-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tpl - SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tlp_disabled;
                break;
            case "00085-2-massive_change-mass-action":
            case "00085-2-delete-mass-action":
            case "00085-2-clone-mass-action":
            case "00085-2-create_from-mass-action":
                _value = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE.list_filter.nb_host_tpl;
                break;
        }
        switch ( _case ) {
            case "00082-2-massive_change-mass-action-work-area":
            case "00082-2-disable-mass-action-work-area":
            case "00082-2-delete-mass-action-work-area":
            case "00082-2-clone-mass-action-work-area":
            case "00082-2-create_from-mass-action-work-area":
            
            case "00082-3-massive_change-mass-action-work-area":
            case "00082-3-enable-mass-action-work-area":
            case "00082-3-disable-mass-action-work-area":
            case "00082-3-delete-mass-action-work-area":
            case "00082-3-clone-mass-action-work-area":
            case "00082-3-create_from-mass-action-work-area":
            case "00082-3-import-mass-action-work-area":
            
            case "00082-5-massive_change-mass-action-work-area":
            case "00082-5-enable-mass-action-work-area":
            case "00082-5-delete-mass-action-work-area":
            case "00082-5-clone-mass-action-work-area":
            case "00082-5-create_from-mass-action-work-area":
            case "00082-5-submit-mass-action-work-area":
            case "00082-5-unlock-mass-action-work-area":
            
            case "00082-6-massive_change-mass-action-work-area":
            case "00082-6-enable-mass-action-work-area":
            case "00082-6-delete-mass-action-work-area":
            case "00082-6-clone-mass-action-work-area":
            case "00082-6-create_from-mass-action-work-area":
            case "00082-6-import-mass-action-work-area":
            
            case "00082-8-clone-mass-action-work-area":
            case "00082-8-create_from-mass-action-work-area":
            case "00082-8-apply-mass-action-work-area":
            case "00082-8-reject-mass-action-work-area":
            
            case "00082-9-massive_change-mass-action-work-area":
            case "00082-9-enable-mass-action-work-area":
            case "00082-9-delete-mass-action-work-area":
            case "00082-9-clone-mass-action-work-area":
            case "00082-9-create_from-mass-action-work-area":
            
            case "00083-6-apply-mass-action-work-area":
            case "00083-6-reject-mass-action-work-area":
            
            case "00084-2-enable-mass-action":
            case "00084-2-disable-mass-action":
            case "00084-2-delete-mass-action":
            case "00084-2-clone-mass-action":
            case "00084-2-create_from-mass-action":
            case "00084-2-import-mass-action":
            
            case "00085-2-massive_change-mass-action":
            case "00085-2-enable-mass-action":
            case "00085-2-disable-mass-action":
            case "00085-2-delete-mass-action":
            case "00085-2-clone-mass-action":
            case "00085-2-create_from-mass-action":
            case "00085-2-import-mass-action":
                _pointer_events = "all";
                break;
            
        }
        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( option.querySelector( ".shinken-counter" ), _value, "counter de l'action " + option.dataset.keyName + " [" + option.dataset.state + "]" );
        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( option, "pointerEvents", _pointer_events );
        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( option, "display", _display );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST_ALL || {} );

SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER = (function ( self ) {
    self.validation_value = function ( timeout, filter_name, nb_error_expected, nb_warning_expected, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            if ( !value ) {
                value = _filter.component.input.dom_element.value;
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterError().getValue(), nb_error_expected, "Error pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterWarning().getValue(), nb_warning_expected, "Warning pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            if ( nb_error_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _filter.component.input.dom_element, "backgroundColor", "rgb(253, 3, 0)" );
            }
            else if ( nb_warning_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _filter.component.input.dom_element, "backgroundColor", "rgb(253, 132, 3)" );
            }
        }, timeout );
        return 1000;
    };
    self.hasValue         = function ( timeout, filter_name, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( _filter.component.input.dom_element, 'value', value, filter_name + " :" );
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIST_FILTER || {} );

