SHINKEN.TOOLS.TEST_AUTO_SOURCE = (function ( self ) {
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.getDomWrapper                = function () {
        return document.getElementById( 'wrapper' );
    };
    self.getWindowGroupDom            = function () {
        return document.querySelector( ".shinken-source-navigation-container .shinken-window-group" );
    };
    self.getWindowsDom                = function () {
        return self.getWindowGroupDom().querySelectorAll( ".shinken-window-element" );
    };
    self.getForceImportButton         = function () {
        return document.querySelector( ".shinken-play-import-source" );
    };
    //********************************************  ACTION   **************************************************//
    self.switchSourceActivity         = function ( timeout, source_name ) {
        setTimeout( function () {
            MANAGER.EventManager.clickOnActivatedSource( source_name );
        }, timeout );
        return 5000;
    };
    self.navigateInTab                 = function ( timeout, tab_name ) {
        setTimeout( function () {
            document.getElementById( WINDOW.CONST.ID.TAB_PANE + tab_name ).click();
        }, timeout );
        return 100;
    };
    self.forceImport                  = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.getForceImportButton() );
        }, timeout );
        return 100;
    };
    //********************************************  TEST   **************************************************//
    self.validNumberTabs              = function ( timeout, nb_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.getWindowsDom(), nb_expected, "nb windows element" );
        }, timeout );
        return 100;
    };
    self.validForceImportButtonStatus = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _dom = self.getForceImportButton();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom, "Button force import" );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.5" );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
            }
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE || {} );



