//__lib__ lib_external
'use strict';

COMPONENT.Checkbox           = function ( dom_element ) {
    // dom_element
    // is_checked
    // checkbox_user
    // checkbox_inherited
    this.init( dom_element );
};
COMPONENT.Checkbox.prototype = {
    init      : function ( dom_element ) {
        this.dom_element        = dom_element;
        this.checkbox_user      = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-user"));
        this.checkbox_inherited = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-inherited"));
        this.checkbox_default = new OBJECT.ElementCheckbox(dom_element.querySelector(".shinken-checkbox-default"));
    },
    setCheckedUser      : function ( to_set) {
        this.checkbox_user.setChecked(to_set);
    },
    setCheckedInheritance      : function (to_set) {
        this.checkbox_inherited.setChecked(to_set);
    },
    isCheckedUser      : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance      : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault      : function () {
        return this.checkbox_default.isChecked();
    }
};