'use strict';

COMPONENT.TimePeriodDayLine           = function ( parent, dom_element, separator_key_value_saved, separator_key_value_html ) {
    this.separator_key_value_saved = separator_key_value_saved;
    this.separator_key_value_html  = separator_key_value_html;
    this.init( parent, dom_element );
};
COMPONENT.TimePeriodDayLine.prototype = {
    initSpecific    : function () {
        this.inputs[ 'shinken-value-line' ] = 0;
        this.selectors[ 'week' ]            = PROPERTY.CONST.TYPES.SINGLE_SELECT;
        this.selectors[ 'month' ]           = PROPERTY.CONST.TYPES.SINGLE_SELECT;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue        : function () {
        var _to_return = this.inputs[ 'shinken-value-line' ].getValue();
        if ( !_to_return ) {
            this.updateCfgDomElement();
            return _to_return;
        }
        _to_return += this.separator_key_value_saved;
        _to_return += this.selectors[ 'week' ].getValue();
        var _month = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_saved;
            _to_return += _month;
        }
        this.updateCfgDomElement();
        return _to_return;
    },
    setValueFromUser: function ( value ) {
        var _elements = value.split( this.separator_key_value_saved );
        var _size     = _elements.length;
        this.setInputValue( _elements[ 0 ] );
        this.setWeek( _elements[ 1 ] );
        if ( _size === 3 ) {
            this.setWeek( _elements[ 2 ] );
        }
    },
    setInputValue   : function ( to_set ) {
        this.inputs[ 'shinken-value-line' ].setValueFromJs(to_set);
    },
    setWeek         : function ( to_set ) {
        if ( this.selectors[ 'week' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'week' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'week' ].computeTitle();
        }
    },
    setMonth        : function ( to_set ) {
        if ( this.selectors[ 'month' ].list_element.getListSelectElement( to_set ) ) {
            this.selectors[ 'month' ].clickOnItemSelector( "", to_set );
            this.selectors[ 'month' ].computeTitle();
        }
    },
    //********************************************  UPDATE VIEW  **************************************************//
    getCfgValue     : function () {
        var _to_return = this.parent_name + this.separator_key_value_html + this.selectors[ 'week' ].getValue();
        var _month     = this.selectors[ 'month' ].getValue();
        if ( _month !== PROPERTY.CONST.TIMEPERIOD.NO_MONTH ) {
            _to_return += this.separator_key_value_html + _month;
        }
        _to_return += this.separator_key_value_html + this.inputs[ 'shinken-value-line' ].getValue();
        return _to_return;
    }
};
COMPONENT.getInterfaceLinePrototype( COMPONENT.TimePeriodDayLine, 'COMPONENT.TimePeriodDayLine' );