'use strict';

COMPONENT.RadioList           = function ( dom_element ) {
    // list_radio_button
    // active_button
    // mapping_radio_button
    this.init( dom_element );
};
COMPONENT.RadioList.prototype = {
    init           : function ( dom_element ) {
        this.mapping_radio_button = {};
        this.initRadioList( dom_element );
    },
    initRadioList  : function ( dom_element ) {
        var _list_dom_radio_button = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current_button;
        
        for ( var i = 0, size_list_button = _list_dom_radio_button.length; i < size_list_button; i++ ) {
            _current_button                                         = new COMPONENT.Button( _list_dom_radio_button[ i ] );
            this.mapping_radio_button[ _current_button.getValue() ] = _current_button;
            if ( _current_button.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current_button;
            }
        }
        
    },
    clickOnRadioBtn: function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getRadioButton( value );
        this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
    },
    getRadioButton : function ( value ) {
        return this.mapping_radio_button[ value ];
    },
    getValue       : function () {
        return this.active_button.getValue();
    },
    isDefaultOn    : function () {
        var _button = this.getRadioButton( PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
        if ( _button ) {
            return _button.isOn();
        }
        return false;
    },
};