'use strict';

OBJECT.ListTemplate           = function ( data ) {
    // list_template
    // list_template_mapping
    // list_template_computed
    // size
    // size_computed
    this.init( data );
};
OBJECT.ListTemplate.prototype = {
    init               : function ( data ) {
        this.list_template         = [];
        this.list_template_mapping = {};
        this.list_use_by_name      = {};
        if ( !data ) {
            this.size = 0;
            return;
        }
        this.initData( data );
        this.computeListUseFinal();
        this.buildTemplateStatus();
        this.buildComputedList();
    },
    initData           : function ( data ) {
        this.size = data.length;
        var object;
        for ( var i = 0; i < this.size; i++ ) {
            object                                         = new OBJECT.Template( data[ i ] );
            this.list_template[ i ]                        = object;
            this.list_template_mapping[ object.getUuid() ] = i;
        }
    },
    computeListUseFinal: function () {
        var _current;
        for ( var i = this.size - 1; i >= 0; i-- ) {
            _current = this.list_template[ i ];
            this._computeUse( _current );
        }
    },
    buildTemplateStatus: function () {
        var _current;
        var _current_tested;
        
        for ( var i = 1; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            for ( var j = 0; j < i; j++ ) {
                _current_tested = this.list_template[ j ];
                
                if ( this.list_use_by_name[ _current_tested.getName() ][ _current.getName() ] ) {
                    _current.setStatus( OBJECT.CONST.TEMPLATE.STATUS.USELESS, _current_tested.getName() );
                    break;
                }
            }
        }
    },
    buildComputedList  : function () {
        this.list_template_computed = [];
        var _current;
        for ( var i = 0; i < this.size; i++ ) {
            _current = this.list_template[ i ];
            if ( _current.isStatus( OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) ) {
                this.list_template_computed.push( _current );
            }
        }
        this.size_computed = this.list_template_computed.length;
    },
    getTemplateByTag   : function ( tag ) {
        var _to_return;
        _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( tag.element.uuid );
        
        if ( !_to_return ) {
            _to_return = MANAGER.__instance_element_distributor.list_templates.getTemplateByName( tag.element.name );
        }
        return _to_return;
    },
    getTemplateByUuid  : function ( uuid ) {
        var _index = this.list_template_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getTemplateByIndex( _index );
    },
    getTemplateByName  : function ( name ) {
        if ( !name ) {
            return null;
        }
        return SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.list_template, OBJECT.CONST.TEMPLATE.FIELD.NAME, name );
    },
    getTemplateByIndex : function ( index ) {
        return this.list_template[ index ];
    },
    isEmpty            : function () {
        return !this.size;
    },
    _computeUse        : function ( template ) {
        var _level_template_already_used;
        var _current_name_template_use;
        var _keys_already_used;
        var _size_already_used;
        var _current_template;
        
        var _name = template.getName();
        if ( !this.list_use_by_name[ _name ] ) {
            this.list_use_by_name[ _name ] = {};
        }
        if ( !template.isEnabled() ) {
            return;
        }
        var _current_use      = template[ OBJECT.CONST.TEMPLATE.FIELD.USE ];
        var _size_current_use = _current_use.length;
        
        for ( var i = 0; i < _size_current_use; i++ ) {
            _current_name_template_use = _current_use[ i ];
            if ( this.list_use_by_name[ _name ][ _current_name_template_use ] ) {
                this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
                continue;
            }
            this.list_use_by_name[ _name ][ _current_name_template_use ] = 1;
            
            if ( !this.list_use_by_name[ _current_name_template_use ] ) {
                continue;
            }
            
            _keys_already_used = Object.keys( this.list_use_by_name[ _current_name_template_use ] );
            _size_already_used = _keys_already_used.length;
            
            for ( var j = 0; j < _size_already_used; j++ ) {
                _level_template_already_used = this.list_use_by_name[ _current_name_template_use ][ _keys_already_used[ j ] ];
                if ( this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] ) {
                    continue;
                }
                this.list_use_by_name[ _name ][ _keys_already_used[ j ] ] = _level_template_already_used + 1;
            }
            _current_template = this.getTemplateByName( _current_name_template_use );
            template.completeTemplateWithUse( _current_template );
        }
    },
    getIndexForCompute      : function ( template ) {
        for ( var i = 0; i < this.size_computed; i++ ) {
            if ( template.uuid === this.list_template_computed[i].uuid ){
                return i;
            }
        }
        return -1;
    },
    getProperties: function ( name ) {
        var _to_return    = [];
        var _stop_compute = false;
        var _current;
        var _current_property;
        
        for ( var i = 0; i < this.size_computed; i++ ) {
            _current = this.list_template_computed[ i ];
            
            _current_property = _current.properties[ name ];
            
            if ( !_current_property ) {
                continue;
            }
            
            if ( !_current_property.isEmpty() ) {
                _to_return.push( _current_property );
            }
            
            if ( _stop_compute ) {
                _current_property.setIsStopped( true );
                continue;
            }
            if ( !_current_property.hasPlus() ) {
                _stop_compute = true;
            }
        }
        
        
        var _size = _to_return.length;
        if ( _size ) {
            _to_return[ _size - 1 ].setIsLast( true );
        }
        else {
            _to_return = null;
        }
        return _to_return;
    },
    finalyzeView : function () {
        var _current;
        var _current_state;
        var _current_template;
        var _use = MANAGER.__instance_property_distributor.getElement( PROPERTY.CONST.NAME.USE );
        if ( !_use ) {
            return;
        }
        for ( var i = 0; i < _use.getSelector().list_element_selected.size_tags; i++ ) {
            _current          = _use.getSelector().list_element_selected.getTagByIndex( i );
            _current_state    = _current.getState();
            _current_template = this.getTemplateByTag( _current );
            if ( _current_state === COMPONENT.CONST.TAG.STATE.HIDDEN ) {
                continue;
            }
            if ( _current_state === COMPONENT.CONST.TAG.STATE.NEW && _current_template.status === OBJECT.CONST.TEMPLATE.STATUS.USEFUL ) {
                _current.setState( OBJECT.CONST.TEMPLATE.STATUS.NEW );
            }
            else {
                if ( !_current.element.item_type ) {
                    _current.element.setItemType( _current_template.item_type );
                }
                _current.setState( _current_template.status );
                _current.setTooltip( _current_template.status_tooltip );
            }
        }
        _use.checkErrorWarning();
    }
};