%import difflib
%from shinken.synchronizer.dao.def_items import DEF_ITEMS, ITEM_TYPE
%from shinken.synchronizer.dao.helpers import get_name_from_type, unescape_XSS
%from shinken.synchronizer.plugins.apply.apply import filter_diffs

%if 'configuration_stats' not in locals():
%    from shinken.synchronizer.business.sync_ui_common import syncuicommon
%    configuration_stats = syncuicommon.get_configuration_stats(user)
%end
%include( "__shinken-lib", type="APPLY")
%rebase( "layout_skonf", title=app._('apply.title'))

%proposed_stats = configuration_stats['overall']['proposed'][1]

<div id="left-column" class="small-left-area" data-state="">
    <div id="action-area-apply" class="action-area">
        <div id="error-container-no-arbiter">
            <div class="error-title">{{app._('apply.error')}}</div>
            <div class="info-title">{{app._('apply.please')}}</div>
            <div class="error-content">
                <div class="error-message">
                    <div class="message arbiter-message-reloading primary">
                        <div>{{app._('apply.arbiter_is_reloading')}}</div>
                        <div class="floatingBarsG text-center">
                            <div class="block rotate-01"></div>
                            <div class="block rotate-02"></div>
                            <div class="block rotate-03"></div>
                            <div class="block rotate-04"></div>
                            <div class="block rotate-05"></div>
                            <div class="block rotate-06"></div>
                            <div class="block rotate-07"></div>
                            <div class="block rotate-08"></div>
                        </div>
                    </div>
                    <div class="message arbiter-message-master primary">{{app._('apply.arbiter_is_down')}}</div>
                    <div class="message arbiter-message-spare">{{app._('apply.arbiter_spare_is_present')}}</div>
                    <div class="message arbiter-message-master">{{app._('apply.arbiter_actions_not_available')}}</div>
                </div>

                <button id="check-proposed-btn" class="button-apply btn btn-inverse" data-number-propose="{{proposed_stats}}" onclick="click_on_check_configuration_propose(this);">
                    <span>{{app._('apply.check_proposed')}}</span>
                    <span class="working-area-proposed">{{app._('element.proposed')}} [{{proposed_stats}}]</span>
                </button>
                <button id="check-btn" class="button-apply btn btn-inverse" onclick="click_on_check_configuration(this);">
                    {{app._('apply.check')}}
                </button>
                <button id="force-btn" class="button-apply btn btn-inverse btn-disabled" onclick="click_on_force_configuration(this);">
                    {{app._('apply.force')}}
                </button>
                <button id="restart-btn" class="button-apply btn btn-inverse btn-disabled" onclick="click_on_restart_configuration(this);">
                    {{app._('apply.apply')}}
                </button>
            </div>
        </div>
    </div>

    <div id="saving-log-verification" data-state="">
        <table id="checking-in-progress" class="alert-success">
            <tr>
                <td id="commiting-configuration">{{app._( 'apply.commiting_configuration' )}}</td>
                <td id="checking-in-progress-check">{{app._( 'apply.configuration_progress' )}}</td>
                <td id="checking-in-progress-apply">{{app._( 'apply.reload_progress' )}}</td>
                <td id="checking-loader">
                    <div class="floatingBarsG">
                        <div class="block rotate-01"></div>
                        <div class="block rotate-02"></div>
                        <div class="block rotate-03"></div>
                        <div class="block rotate-04"></div>
                        <div class="block rotate-05"></div>
                        <div class="block rotate-06"></div>
                        <div class="block rotate-07"></div>
                        <div class="block rotate-08"></div>
                    </div>
                </td>
            </tr>
        </table>

        <div id="checking-is-ok" class="alert-success">
            {{!app._( 'apply.configuration_ok' )}}
        </div>
        <div id="checking-is-nok" class="alert-error"></div>

        <div id="apply-force-is-ok" class="alert-success">
            {{!app._( 'apply.configuration_force_ok' )}}
        </div>
        <div id="apply-force-is-nok" class="alert-error"></div>

        <div id="reload-is-ok" class="alert-success">
            <b>{{!app._( 'apply.reload_ok' )}}</b>
        </div>
    </div>

    <div id="left-panel-error" class="span12">
        <div class="pull-right" style="position:relative;top:0;right:4px;">
            <a href="javascript:click_on_toggle_error_panel_size();" title="{{app._('apply.reduce_this_panel')}}">
                <i class="icon-arrow-left"></i>
                <i class="icon-arrow-right"></i>
            </a>
            <a href="javascript:click_on_close_error_panel_size();" title="{{app._('apply.close_this_panel')}}"><i class="icon-remove"></i></a>
        </div>
        <div id="left-panel-error-header"></div>
        <div id="left-panel-error-content"></div>
    </div>
</div>

<script>
    //var __shinken_element_list = {};
    var g_nb_elements = {};
    var hasChange = false;
    %parts = ['new', 'changed', 'removed']
    %APP_DATA_KEYS = DEF_ITEMS.keys()

    %for p in parts:
        g_nb_elements['{{p}}'] = {};
        %for t in APP_DATA_KEYS:
            g_nb_elements['{{p}}']['{{t}}'] = {{len(filter_diffs(diffs[t][p])) if p == 'changed' else len(diffs[t][p])}};
        %end
    %end
</script>

<div id="main-right">
    <div class="main-header">
        <div class="production-title-panel">
            <div>
                <span class="production-icon title-icon">
                    <i class="shinkon shinkon-chevron-right-circle icon"></i>
                </span>
                <span class="production-title-text">Production</span>
            </div>
        </div>


        <div class="show_changes_title">
            {{app._('apply.page_title')}} >
        </div>
    </div>

    <div class="main-content">
        <div id="apply_filter_area">
            <div class="tabbable tabs-left top-box-gray">
                <div class='shinken-tab-statut-container filter-box top-box-gray tabs-left span12'>
                    %include("__print_top_left_title_bloc", text='%s >'%app._('apply.status'), margin=False, app=app)
                    <ul class="nav nav-tabs span12 no-margin gray-back">
                        <li id='li-to-part-all' class="li-filter tab-label">
                            <a href="javascript:set_filter_part('all');">
                                <div class='element-number' id='nb-all'></div>
                                <div class='element-type'> {{app._('apply.all')}}</div>
                            </a>
                        </li>
                        <li id='li-to-part-new' class="li-filter tab-label">
                            <a href="javascript:set_filter_part('new');">
                                <div class='element-number' id='nb-new'></div>
                                <div class='element-type'> {{app._('apply.new_elements')}}</div>
                            </a>
                        </li>
                        <li id='li-to-part-changed' class="li-filter tab-label">
                            <a href="javascript:set_filter_part('changed');">
                                <div class='element-number' id='nb-changed'></div>
                                <div class='element-type'> {{app._('apply.changed_elements')}}</div>
                            </a>
                        </li>
                        <li id='li-to-part-removed' class="li-filter tab-label">
                            <a href="javascript:set_filter_part('removed');">
                                <div class='element-number' id='nb-removed'></div>
                                <div class='element-type'> {{app._('apply.removed_elements')}}</div>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class='shinken-tab-type-container filter-box top-box-gray tabs-left span12'>
                    %include("__print_top_left_title_bloc", text='%s >'%app._('apply.type'), margin=False, app=app)
                    <ul class="shinken-nav-tabs-type gray-back nav nav-tabs full-height span12 no-margin" style="margin-bottom:0px;">
                        <li class="li-filter tab-label" id='li-to-type-all'>
                            <a id='a-to-all' href="javascript:set_filter_type('all');" class='show-objs'>
                                <div class='element-number' id='nb-all'></div>
                                <div class='element-type'>{{app._('apply.all')}}</div>
                            </a>
                        </li>
                        %types = APP_DATA_KEYS
                        %types.sort()
                        %for item_type in types:
                        <li class="li-filter tab-label" id='li-to-type-{{item_type}}'>
                            <a id='a-to-{{item_type}}' href="javascript:set_filter_type('{{item_type}}');" class='show-objs' data-id='-{{item_type}}'>
                                <div class='element-number' id='nb-{{item_type}}'></div>
                                <div class='element-type'>{{app._('type.%s'% item_type)}}</div>
                            </a>
                        </li>
                        %end
                    </ul>
                </div>
            </div>

            <div class="span6 tabbable tabs-left gray-back top-box-gray" style="margin-left:0px;display:none;">
                <div class="tab-content degraded-back">
                    %parts = ['new', 'changed', 'removed']

                    %for part in parts:
                        %nb = 0
                        %active = ''
                        %if part == 'new':
                            %active = 'active'
                        %end

                        <div class="tab-pane {{active}}" id="{{part}}">
                            <div class="span12 tabbable tabs-left" style="margin-left:0px;">
                                <div class="tab-content degraded-back" style="min-height:500px;margin-bottom:0px;">
                                    %for item_type in DEF_ITEMS.keys():
                                        <div class="tab-pane " id="{{part}}-{{item_type}}" style='width: 99%;'>
                                            %if part == 'changed':
                                                %diff_entries = filter_diffs(diffs[item_type][part])
                                            %else:
                                                %diff_entries = diffs[item_type][part]
                                            %end

                                            %diff_entries.sort(lambda x,y : sort_stagging(x,y,item_type))
                                            %nb += len(diff_entries)
                                            <div class='span12 no-margin apply-element-block' data-part="{{part}}" data-type="{{item_type}}" data-nb-elements="{{len(diff_entries)}}">
                                                <ul style='list-style-type: none;' class='apply-element-list'>
                                                    %for diff_entry in diff_entries:
                                                        %stag = diff_entry['stagging']
                                                        %if not stag:
                                                            %stag = diff_entry['production']
                                                            %if not stag:
                                                                %continue
                                                            %end
                                                        %end

                                                        %name = get_name_from_type(item_type,stag)
                                                        %_id = stag.get('_id', stag.get('_ID', 'unknown'))
                                                        %stpl = ''
                                                        %if stag.get('register', '1') == '0':
                                                            %stpl = ' (tpl)'
                                                        %end


                                                        <li style='margin-top: 10px;'>
                                                            %# only put a link on new or changed, because on a remove it's useless
                                                            %if part != 'removed':
                                                            <!--<script>__shinken_element_list['{{_id}}'] = {item_type : '{{item_type}}', name: '{{name}}'} </script>-->
                                                            <a href='/elements/{{item_type}}/{{_id}}'>
                                                                %end
                                                                <span class='shinken-space line-{{part}}'>{{name}}{{stpl}}</span>
                                                                %if part == 'changed':
                                                                %_id = stag.get('_id')
                                                                %_stag = diff_entry['stagging']
                                                                %_prod = diff_entry['production']
                                                                <a class='apply_type_collapse_{{item_type}}' title="{{app._('apply.collapse_element')}}" data-id='{{_id}}' data-collasped="false" data-type='{{item_type}}' href='#' onclick='toggle_change_table("{{_id}}");'>
                                                                    <i id='i-changes-table-{{_id}}' class="icon-minus"></i>
                                                                </a>
                                                                {{app.helper.get_modification_info(diff_entry['modification_info'])}}
                                                                <br/>
                                                                <span class='' id="{{_id}}">
                                                                    <table class='table-striped table-bordered table-hover shinken-table-apply'>
                                                                        <thead class="shinken-table-apply-header">
                                                                            <tr>
                                                                                <th>{{app._('element.import_key')}}</th>
                                                                                <th>{{app._('apply.property')}}</th>
                                                                                <th>{{app._('apply.previous')}}</th>
                                                                                <th></th>
                                                                                <th>{{app._('apply.new')}}</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            %for property_name in diff_entry['changed']:
                                                                                %if _prod.get(property_name, '') != _stag.get(property_name, ''):
                                                                                    %__previous, __new_value, __is_password_protected = app.helper.diff_to_display(property_name, item_type, _prod.get(property_name, '') , _stag.get(property_name, ''))
                                                                                    %__prev_class=''
                                                                                    %__new_class=''
                                                                                    %if __is_password_protected:
                                                                                        %if __previous == app._('element.password_protected'):
                                                                                            %__prev_class='shinken-protected-password'
                                                                                        %end
                                                                                        %if __new_value == app._('element.password_protected'):
                                                                                            %__new_class='shinken-protected-password'
                                                                                        %end
                                                                                    %end
                                                                                    <tr>
                                                                                        %if property_name.startswith('_'):  # if a data, special display
                                                                                           %_k_display = '%s [%s]' % (property_name[1:], app._('element.data'))
                                                                                        %else:
                                                                                            %_k_display = app._('%s.%s'% (item_type,property_name))
                                                                                            %if 'TO_TRAD(' in _k_display:
                                                                                                %_k_display = '<span class="circle" style="display: inline-block;vertical-align: middle;"><i class="shinkon-question"></i></span>'
                                                                                                %_k_display += '<span style="display: inline-block;vertical-align: middle;width: 70%;">' +app._('element.unknown_import_key') + '</span>'
                                                                                            %end
                                                                                        %end
                                                                                        <td class="shinken-property-key-cell">{{property_name}}</td>
                                                                                        <td class="shinken-property-name-cell">{{!_k_display}}</td>
                                                                                        <td class="shinken-previous-value-cell"><span class='shinken-space {{__prev_class}}'>{{unescape_XSS(__previous)}}&nbsp;</span></td>
                                                                                        <td class="shinken-arrow-cell"><i class="icon-arrow-right"></i></td>
                                                                                        <td class="shinken-next-value-cell"><span class="shinken-space {{__new_class}}">{{unescape_XSS(__new_value)}}</span></td>
                                                                                    </tr>
                                                                                %end
                                                                            %end
                                                                        </tbody>
                                                                    </table>
                                                                </span>
                                                                %end
                                                                %if part != 'removed':
                                                            </a>
                                                            %end
                                                            %if part != 'changed':
                                                                {{app.helper.get_modification_info(diff_entry['modification_info'])}}
                                                            %end
                                                        </li>
                                                    %end
                                                </ul>

                                                %# by default the whole distant block is hide, show it if need
                                                <script>
                                                    if ( (parseInt("{{len(diff_entries)}}") > 0) && !hasChange) {
                                                        hasChange = true;
                                                        $('#force-btn').removeClass('btn-disabled');
                                                        $('#restart-btn').removeClass('btn-disabled');
                                                    }
                                                    g_nb_elements['{{part}}']['{{item_type}}'] = {{len(diff_entries)}};
                                                </script>
                                            </div>
                                        </div>
                                    %end
                                    %if nb == 0:
                                        <script>$(function(){ $('#li-to-{{part}}').addClass('disabled') });</script>
                                    %end

                                </div>
                            </div>
                        </div>
                    %end

                    <div class="tab-pane" id="check">
                        <span class='span10'>
                            <span id='saving_log' class='hide' style='color:black;'></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div id='apply-right-block'>
            <div class="block-header">
                <h4>{{app._('apply.elements')}}</h4>
            </div>
            %parts = ['new', 'changed', 'removed']
            %for part in parts:
            <div id="apply-right-block-{{part}}" class="block-content well span12 block-grp-part" data-part="{{part}}">
                <h4>{{app._('apply.%s'%part).capitalize()}}<span id="apply-right-nb-{{part}}"></span></h4>
                %for item_type in APP_DATA_KEYS:
                <div id="apply-right-block-{{part}}-{{item_type}}" class="span12 block-grp" data-part="{{part}}" data-type="{{item_type}}">
                    <div class="span6 block-grp-header"><b>{{app._('type.%s'%item_type).capitalize()}} <span id='apply-right-nb-{{part}}-{{item_type}}'></span></b>
                        %if part == 'changed':
                        <a href='javascript:apply_collapse_all("{{item_type}}");' title="{{app._('apply.collapse_all_element')}}"><i class="icon-minus" id="i-collapse-type-{{item_type}}"></i></a>
                        %end
                    </div>
                </div>
                %end
            </div>
            %end
        </div>
    </div>
</div>

<script>
    $( function() {
        $( '.show-objs' ).on( 'show', function( e ) {
            update_layout();
        } );
    } );
</script>
