%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS, WORKING_AREA_STATUS, WORKING_AREA_LAST_ACTION, ITEM_STATE

%if 'is_new_object' not in locals():
    %is_new_object=False
%end

%if 'working_area' not in locals():
    %working_area=False
%end

%title="%s %s" % (app._('type.%s'%item_type), item.get(DEF_ITEMS[item_type]['key_name'], app._('element.unknown')))
%rebase( "elements_base", title=title,  css=['elements/css/jquery-ui.css', 'elements/css/elements.css'], js=[])

%presence_protection = item.get('presence_protection', '0') == '1'


%# is the element globaly editable or just the name that is restricted
%is_disabled = item.get('editable', '1') == '0'

%is_admin = user.is_admin()


%must_save_in_work_area = (item_type == ITEM_TYPE.HOSTS) or working_area
<script>
    var shinken_link_tpl = 'hosttpls';
    // We will load the documentation from the js/docs/XXX.js
    var is_tag_exist = [];

    var working_area = {{"true" if working_area else "false"}};
    var __is_working_area__ = {{"true" if working_area else "false"}};
    var must_save_in_work_area = {{"true" if must_save_in_work_area else "false"}};

    %for use in item.get("use", "" ).split(','):
        is_tag_exist["{{use}}"] = {{"true" if app.is_tag_exist(use) else "false"}};
    %end

    // keep the can_edit information as a global, for the DATA display
    var g_can_edit = {{'true' if can_edit else 'false'}};

</script>

%can_submit = item.get('work_area_info',{}).get('can_submit',False)
%item_state = ITEM_STATE.NEW if pending or is_new_object else ITEM_STATE.STAGGING
%work_area_status = WORKING_AREA_STATUS.get_work_area_status(item, item_state)
%work_area_last_action = WORKING_AREA_LAST_ACTION.get_work_area_action(item, item_state)
%have_propose = work_area_status == WORKING_AREA_STATUS.PROPOSED
%print_button_propose = have_propose and not working_area
%display_changes = is_admin and changes

%list_tab_for_element = ['generic','datas','user-rights','monitoring','checks','notifications','advanced']
%if display_changes:
    %list_tab_for_element.append('changes')
%end
%if is_admin and have_propose:
    %list_tab_for_element.append('proposed')
%end

%selected_tab = app.request.GET.get('tab', '')
%if not selected_tab :
    %selected_tab = 'proposed' if have_propose and is_admin else 'generic'
%end
%if selected_tab not in list_tab_for_element :
    %selected_tab = list_tab_for_element[0]
%end

%propose_delete = 'true' if item.get('work_area_info',{}).get('submit_del_item',False) else 'false'

%working_area_class = 'class="working-area"' if working_area else ''

<div id="left-column" data-type={{item_type}}>
    %include( "__print_element_left_buttons", pending=pending, is_disabled=is_disabled,  changes=display_changes, is_new_object=is_new_object, presence_protection=presence_protection, app=app, must_save_in_work_area=must_save_in_work_area, can_submit=can_submit, have_propose=print_button_propose, propose_delete=propose_delete, working_area=working_area, work_area_last_action=work_area_last_action)
    %include( "__print_right_help_bloc", changes=display_changes, app=app)
</div>





<div id="right-column" {{!working_area_class}} data-workarea-status="{{block_acl_cause}}" data-editable="{{not(is_disabled)}}">
    %include( "__print_saving_log")
    <div id="loading_page"></div>
    <div class="container_host_info shinken-container-host-info">
        %include( "__print_top_title_item", item_id=item.get('_id') )
        %include( "edition_element_form/%s" % item_type )
    </div>
</div>


