#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceResultModulation(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'resultmodulation_name',
        'uuid',
        'definition_order',
        'modulation_period',
        'exit_code_modulation',
        'compiled_rules',
        'output_rules',
        'imported_from',
        'exit_codes_match'
    ]
    
    
    def __init__(self):
        super(SourceResultModulation, self).__init__()
        self.item_type = ITEM_TYPE.RESULTMODULATIONS
