#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta, abstractmethod

from shinken.log import PartLogger
from shinkensolutions.api.synchronizer import SourceTranslatePart
from shinkensolutions.api.synchronizer.source.route.route import AbstractRoute
from shinkensolutions.api.synchronizer.source.source_info import SourceInfo



class AbstractTab(AbstractRoute):
    __metaclass__ = ABCMeta
    
    
    @abstractmethod
    def __init__(self, logger, translator, source_name, name, displayed_name, source_info):
        # type: (PartLogger, SourceTranslatePart, str, str, str, SourceInfo) -> None
        super(AbstractTab, self).__init__(logger, source_name, name, source_info, have_http_template=True)
        self.translator = translator
        self.displayed_name = displayed_name
        self.errors = 0
        self.warnings = 0
