var is_edit_mode_on = false;

function submit_form ( with_change, submit_to_stagging, comment_txt ) {
    MANAGER.__instance_element_distributor.current_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.ON_SAVING );
    disable_page_off_warning();
    
    var item_dump = get_current_object( with_change, comment_txt );
    
    delete item_dump[ "protect_fields__activate_interface_encryption" ];
    delete item_dump[ "protect_fields__substrings_matching_fields" ];
    $.post( '/sources/' + SOURCE_NAME + '/synchronizer-linker/save/', item_dump ).success( form_success_network_range ).error( form_errors_linker );
}

//********************************************  SOURCE RANGE     *********************************************************//
function form_success_network_range ( is_delete ) {
    var current_time = new Date();
    var message      = is_delete ? _( 'element.object_deleted' ) : _( 'element.object_saved' );
    message += ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM ) + '.';
    show_saving_log( message, '', 'alert-success', false );
    setTimeout( function () {
        backToSourceList();
    }, 1200 );
}

function form_errors_linker ( arg1 ) {
    var _class;
    var _text;
    var _data = JSON.parse( arg1.responseText );
    switch ( _data.type ) {
        case "save_with_warning":
            var current_time = new Date();
            var message      = "<span class='shinken-success-message-saving'>" + _( 'element.object_saved' ) + ' ' + _( 'element.at' ) + ' ' + DATE_TIME.FORMAT.getTime( current_time, DATE_TIME.FORMAT.TIME.HH_MM )
                               + '.' + "</span></br>" + _data.message;
            var msg          = {
                'type'         : 'warning',
                'is_persistent': true,
                'title'        : message
            };
            sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
            var _url = "/sources/" + SOURCE_NAME + "/synchronizer-linker/" + MANAGER.__instance_element_distributor.current_element.getUUID();
            setTimeout( "location.assign('" + _url + "');", 1000 );
            break;
        default:
            _text  = _( 'element.error_save' ) + '</br>' + _data.message;
            _class = "alert-error";
            show_saving_log( _text, '', _class, false );
    }
}

function submit_delete_discovery_form () {
    var data = { _id: MANAGER.__instance_element_distributor.current_element.getUUID() };
    $.post( '/sources/' + SOURCE_NAME + '/synchronizer-linker/delete/', data ).success( form_success_network_range( true ) ).error( form_errors_network_range );
}

function action_when_resizing () {
    
    var _height_header     = DOM.Service.getBoundingClientRect( document.querySelector( '.shinken-content-header' ), 'height' );
    var _height_commnets_1 = DOM.Service.getBoundingClientRect( document.querySelector( '.tab-title-commentary-box' ), 'height' );
    var _height_example    = DOM.Service.getBoundingClientRect( document.querySelector( '.shinken-source-example-conf-container' ), 'height' );
    var _height_logs       = DOM.Service.getBoundingClientRect( document.getElementById( 'saving-log' ), 'height' ) + 25;
    
    var _dom_right_column_xx          = document.getElementById( 'right-column' );
    _dom_right_column_xx.style.height = "calc(100vh - " + _height_header + "px)";
    
    var _dom_form          = document.getElementById( "id-shinken-form-element" );
    _dom_form.style.height = "calc(100vh - " + (_height_header + _height_commnets_1 + _height_logs) + "px)";
    
    var _dom_generic          = document.getElementById( "generic" );
        _dom_generic.style.height = "calc(100vh - " + (_height_header + _height_commnets_1 + _height_example + _height_logs + 40) + "px)";
    
    //
    /**************************************
     * Page Edition element - Resize HELP
     **************************************/
    var _dom_info_area     = $( '.info-area' );
    var _dom_info_box_help = $( '.info-box.help' );
    var _dom_action_area   = $( '.action-area' );
    var _dom_left_column   = $( '#left-column' );
    
    // ----- Level 1
    App.Scope.adjustHeight( _dom_action_area, _dom_info_area, _dom_left_column, false );
    // ----- Level 2
    App.Scope.adjustHeight( $( '#shinken-box-content-legend' ), _dom_info_box_help, _dom_info_area, false );
    // ----- Level 3
    App.Scope.adjustHeight( $( '#shinken-help-title' ), $( '#shinken-help-content' ), _dom_info_box_help, false );
    
}

//********************************************  EVENT SPECIFIC MANAGER     *********************************************************//
function deleteSynchronizerLinker () {
    delete_ui_entry( true );
    backToSourceList();
}

function backToSourceList () {
    var _current_params                 = window.parent.window.SHINKEN.HIGHWAY.getParams();
    delete _current_params['source-name'];
    delete _current_params['synchronizer-id'];
    window.parent.location.href = window.parent.window.SHINKEN.HIGHWAY.getPath() + window.parent.window.SHINKEN.HIGHWAY.buildParamsToUrl( _current_params );
}

//********************************************  DOM IS READY   ******************************************************//
var doActionWhenDomReady           = function ( e ) {
    MANAGER.__instance_loading.showLoading( _( 'element.load_in_progress' ) );
    initAllShinkenElement();
    addElementEditionEventListener();
    updateALLTemplateAndCheckDatas( true );
};
var initAllShinkenElement          = function () {
    var _shinken_element = new OBJECT.ShinkenElement();
    _shinken_element.updateData( JSON.parse( SHINKEN.TOOLS.STRING.b64Decode( current_shinken_element ) ) );
    MANAGER.__instance_element_distributor.setCurrentElement( _shinken_element );
    _shinken_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.VIEWING );
    current_shinken_element = null;
};
var addElementEditionEventListener = function () {
    var nb_max_btn = $( '.action-area-inside' ).children( ':not(#empty-separator)' ).size();
    $( '#left-column' ).addClass( "max-btn-" + nb_max_btn );
    
    /***********************
     * History Events
     **********************/
    var $btnCancel = $( '#element-btn-cancel' ),
        $btnSave   = $( '#element-btn-save' );
    
    // We clean the url to put the real one.
    $btnCancel.find( 'a' ).attr( 'href', App.HistoryManager.previous() );
    $btnCancel.on( 'click', function ( e ) {
        e.preventDefault();
        if ( is_edit_mode_on ) {
            var result = confirm( _( 'element.warn_unsave' ) );
            if ( result ) {
                window.onbeforeunload = function () {
                }; // Fix SEF-1712
                App.HistoryManager.back();     // Go to the previous page
                App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
            }
        }
        else {
            App.HistoryManager.back();     // Go to the previous page
            App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
        }
    } );
    $btnSave.on( 'click', function ( e ) {
        App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
    } );
    
    document.addEventListener( 'keydown', function ( event ) {
        MANAGER.EventManager.keydown( event );
    } );
    document.addEventListener( "click", function ( e ) {
        MANAGER.__instance_property_distributor.hidePopups();
    } );
    window.onbeforeunload = function () {
        if ( is_edit_mode_on ) {
            return _( 'element.warn_unsave' );
        }
    };
};
var updateALLTemplateAndCheckDatas = function ( firstTime ) {
    MANAGER.__instance_loading.showLoading( _( 'element.load_in_progress' ) );
    initAllShinkenProperty( firstTime );
    
    $( window ).trigger( 'resize' );
    MANAGER.__instance_loading.setIsReady( true );
    MANAGER.__instance_loading.removeLoading();
};
var initAllShinkenProperty         = function ( is_init ) {
    var _elements = document.querySelectorAll( '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
    for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
        var _current = _elements[ i ];
        var _name    = _current.dataset.name;
        var _element = MANAGER.__instance_property_distributor.findElement( _name );
        _element.updateWithTemplate( MANAGER.__instance_element_distributor.list_templates, !is_init );
    }
    if ( is_init ){
        MANAGER.__instance_property_distributor.finalyzeModel();
    }
};
$( window ).unbind( 'resize' );
$( window ).resize( action_when_resizing );