#!/usr/bin/python
# -*- coding: utf-8 -*-

# python 2.6, missing function, copy from the 2.7 version, just a helper function
# Fichier placé à l'installation de Shinken se trouvant dans dependencies/vmware/files
# With fix : https://github.com/vmware/pyvmomi/issues/347 & https://github.com/vmware/pyvmomi/issues/627
# (Yes this API don't handle timeout)

import re
import sys

from pyVim.connect import __FindSupportedVersion, _rx, SetSi, GetLocalTicket
from pyVmomi import vim, vmodl, SoapStubAdapter
from pyVmomi.VmomiSupport import GetServiceVersions, versionMap
from pyVmomi.SoapAdapter import CONNECTION_POOL_IDLE_TIMEOUT_SEC, HTTPSConnectionWrapper, UnixSocketConnection
from six import reraise
from six.moves import http_client
from six.moves.urllib.parse import urlparse

class HTTPSConnectionWrapperWithSocketTimeout(HTTPSConnectionWrapper):
    def __init__(self, *args, **kwargs):
        wrapped = http_client.HTTPSConnection(*args, **kwargs)
        # Extract ssl.wrap_socket param unknown to httplib.HTTPSConnection,
        # and push back the params in connect()
        self._sslArgs = {}
        tmpKwargs = kwargs.copy()
        for key in ["server_side", "cert_reqs", "ssl_version", "ca_cers",
                    "do_handshake_on_connect", "suppress_ragged_eofs",
                    "ciphers","timeout"]:
            if key in tmpKwargs:
                self._sslArgs[key] = tmpKwargs.pop(key)
        self._wrapped = wrapped


class SoapStubAdapterWithSocketTimeout(SoapStubAdapter):
    def __init__(self, host='localhost', port=443, ns=None, path='/sdk',
                 url=None, sock=None, poolSize=5,
                 certFile=None, certKeyFile=None,
                 httpProxyHost=None, httpProxyPort=80, sslProxyPath=None,
                 thumbprint=None, cacertsFile=None, version=None,
                 acceptCompressedResponses=True,
                 connectionPoolTimeout=CONNECTION_POOL_IDLE_TIMEOUT_SEC,
                 samlToken=None, socketTimeout=None):
        SoapStubAdapter.__init__(self, host, port, ns, path, url, sock, poolSize, certFile, certKeyFile, httpProxyHost, httpProxyPort, sslProxyPath, thumbprint, cacertsFile, version, acceptCompressedResponses, connectionPoolTimeout, samlToken)

        if sock:
            self.scheme = UnixSocketConnection
            # Store sock in the host member variable because that's where
            # the UnixSocketConnection ctor expects to find it -- see above
            self.host = sock
        elif url:
            scheme, self.host, urlpath = urlparse(url)[:3]
            # Only use the URL path if it's sensible, otherwise use the path
            # keyword argument as passed in.
            if urlpath not in ('', '/'):
                path = urlpath
            self.scheme = scheme == "http" and http_client.HTTPConnection \
                          or scheme == "https" and HTTPSConnectionWrapperWithSocketTimeout
        else:
            port, self.scheme = port < 0 and (-port, http_client.HTTPConnection) \
                                or (port, HTTPSConnectionWrapperWithSocketTimeout)

        if socketTimeout:
            self.schemeArgs['timeout'] = socketTimeout


def __Login(host, port, user, pwd, service, adapter, version, path, keyFile, certFile, connectionPoolTimeout, socketTimeout):
    # XXX remove the adapter and service arguments once dependent code is fixed
    if adapter != "SOAP":
        raise ValueError(adapter)
    
    # Create the SOAP stub adapter
    stub = SoapStubAdapterWithSocketTimeout(host, port, version=version, path=path, certKeyFile=keyFile, certFile=certFile, connectionPoolTimeout=connectionPoolTimeout, socketTimeout=socketTimeout)
    
    # Get Service instance
    si = vim.ServiceInstance("ServiceInstance", stub)
    try:
        content = si.RetrieveContent()
    except vmodl.MethodFault:
        raise
    except Exception as e:
        # NOTE (hartsock): preserve the traceback for diagnostics
        # pulling and preserving the traceback makes diagnosing connection
        # failures easier since the fault will also include where inside the
        # library the fault occurred. Without the traceback we have no idea
        # why the connection failed beyond the message string.
        (type, value, traceback) = sys.exc_info()
        if traceback:
            fault = vim.fault.HostConnectFault(msg=str(e))
            reraise(vim.fault.HostConnectFault, fault, traceback)
        else:
            raise vim.fault.HostConnectFault(msg=str(e))
    
    # Get a ticket if we're connecting to localhost and password is not specified
    if host == 'localhost' and not pwd:
        try:
            (user, pwd) = GetLocalTicket(si, user)
        except:
            pass  # This is not supported against vCenter, and connecting
            # with an empty password is fine in debug builds
    
    # Login
    try:
        x = content.sessionManager.Login(user, pwd, None)
    except vim.fault.InvalidLogin:
        raise
    except Exception as e:
        raise
    return si, stub


def Connect(host='localhost', port=443, user='root', pwd='', service="hostd", adapter="SOAP", namespace=None, path="/sdk", version=None, keyFile=None, certFile=None, connectionPoolTimeout=900, socketTimeout=None):
    try:
        info = re.match(_rx, host)
        if info is not None:
            host = info.group(1)
            if host[0] == '[':
                host = info.group(1)[1:-1]
            if info.group(2) is not None:
                port = int(info.group(2)[1:])
    except ValueError as ve:
        pass
    
    if namespace:
        assert (version is None)
        version = versionMap[namespace]
    elif not version:
        version = "vim.version.version6"
    si, stub = __Login(host, port, user, pwd, service, adapter, version, path, keyFile, certFile, connectionPoolTimeout, socketTimeout)
    SetSi(si)
    
    return si


def SmartConnect(protocol='https', host='localhost', port=443, user='root', pwd='', service="hostd", path="/sdk", preferredApiVersions=None, connectionPoolTimeout=900, socketTimeout=None):
    if preferredApiVersions is None:
        preferredApiVersions = GetServiceVersions('vim25')
    
    supportedVersion = __FindSupportedVersion(protocol, host, port, path, preferredApiVersions)
    if supportedVersion is None:
        raise Exception("%s:%s is not a VIM server" % (host, port))
    
    portNumber = protocol == "http" and -int(port) or int(port)
    
    return Connect(host=host, port=portNumber, user=user, pwd=pwd, service=service, adapter='SOAP', version=supportedVersion, path=path, connectionPoolTimeout=connectionPoolTimeout, socketTimeout=socketTimeout)


class SmartConnectNoSSL(object):
    def __init__(self, protocol='https', host='localhost', port=443, user='root', pwd='', service="hostd", path="/sdk", preferredApiVersions=None, connectionPoolTimeout=900, socketTimeout=None):
        self.session = SmartConnect(protocol=protocol, host=host, port=port, user=user, pwd=pwd, service=service, path=path, preferredApiVersions=preferredApiVersions, connectionPoolTimeout=connectionPoolTimeout, socketTimeout=socketTimeout)

    def smartConnectTestConnection(self, logger, translate):
        if len(self.session._stub.pool) < 1:
            msg = translate('vmware_error.connection_timeout')
            logger.error(msg)
            raise Exception(msg)
    