#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2013:
#    Gabes Jean, j.gabes@shinken-solutions.com
#
# This file is part of Shinken enterprise, all rigths reserved


from shinken.misc.perfdata import PerfDatas

app = None


def fancy_units(num):
    for x in ['', 'KB', 'MB', 'GB']:
        if num < 1024.0 and num > -1024.0:
            return "%3.1f%s" % (num, x)
        num /= 1024.0
    return "%3.1f%s" % (num, 'TB')


def get_metric(h, desc, mname):
    s = h.find_service_by_name(desc)
    if not s:
        return 0
    
    perfdatas = PerfDatas(s.perf_data)
    if not mname in perfdatas:
        return 0

    return perfdatas[mname].value


def get_srv_state(h, desc):
    s = h.find_service_by_name(desc)
    if not s:
        return 'UNKNOWN'
    return s.state.upper()


def get_page(hname):
    h = app.datamgr.get_host(hname)

    m = get_metric(h, 'Mysql-connection', 'connection_time')
    
    return {'app': app, 'h': h, 'm': m, 'get_metric': get_metric, 'get_srv_state': get_srv_state}


# Void plugin
pages = {
    get_page: {'routes': ['/cv/mysql/:hname'], 'view': 'cv_mysql', 'static': True},
}
