var DETAIL_GRAPHS_CALL = true;

function change_timerange_detail ( new_timerange, isInit ) {
    _first_date_parse_data = undefined;
    loadAllDomElement();
    var rangeSelector = __instanceCharts.rangeSelector;
    
    switch ( new_timerange ) {
        case '-1d':
            set_xAxis_min_range( 60 * 60 * 1000 );
            rangeSelector.buttons[ 0 ].show( false );
            rangeSelector.buttons[ 1 ].hide( false );
            rangeSelector.buttons[ 2 ].hide( false );
            rangeSelector.buttons[ 3 ].hide( false );
            break;
        case '-1w':
            set_xAxis_min_range( 3 * 60 * 60 * 1000 );
            rangeSelector.buttons[ 0 ].hide( false );
            rangeSelector.buttons[ 1 ].show( false );
            rangeSelector.buttons[ 2 ].hide( false );
            rangeSelector.buttons[ 3 ].hide( false );
            break;
        case '-1month':
            set_xAxis_min_range( 12 * 60 * 60 * 1000 );
            rangeSelector.buttons[ 0 ].hide( false );
            rangeSelector.buttons[ 1 ].show( false );
            rangeSelector.buttons[ 2 ].show( false );
            rangeSelector.buttons[ 3 ].hide( false );
            break;
        case '-1y':
            set_xAxis_min_range( 7 * 24 * 60 * 60 * 1000 );
            rangeSelector.buttons[ 0 ].hide( false );
            rangeSelector.buttons[ 1 ].hide( false );
            rangeSelector.buttons[ 2 ].show( false );
            rangeSelector.buttons[ 3 ].show( false );
            break;
    }
    set_timerange( new_timerange );
    // refresh ();
    setResetExtremes( true );
    if ( !isInit ) {
        __instance_detail_graph_host.reInit();
    }
}

function trending_detail () {
    var btn_trending = document.getElementById( 'btn-trending' );
    var wasActive    = btn_trending.classList.contains( 'active' );
    var trending     = !wasActive;
    btn_trending.classList.toggle( 'active' );
    
    set_show_trending( trending );
    re_init();
}

function cleanErrorMessage () {
    $( '#container' ).highcharts().setTitle( { text: "" }, {}, false );
}

function load_graphs () {
    load_theme();
    setTimeout( function () {
        var $graph_container = $( '#container' );
        // set_default_zoom_select ( 4 );
        $graph_container.highcharts( 'StockChart', {
            scrollbar    : {
                enabled: false
            },
            credits      : {
                enabled: false
            },
            xAxis        : {
                ordinal : false,
                minRange: 5 * 60 * 10000
            },
            yAxis        : {
                startOnTick: false
            },
            rangeSelector: {
                allButtonsEnabled: true,
                selected         : 4,
                buttons          : [
                    {
                        type : 'minute',
                        count: 70,
                        text : _( 'graphics.hour' )
                    },
                    {
                        type : 'minute',
                        count: 1500,
                        text : _( 'graphics.day' )
                    },
                    {
                        type : 'day',
                        count: 8,
                        text : _( 'graphics.week' )
                    },
                    {
                        type : 'day',
                        count: 35,
                        text : _( 'graphics.month' )
                    },
                    {
                        type: 'all',
                        text: _( 'graphics.all' )
                    }
                ]
            },
            series       : [
                {
                    name: 'todel',
                    data: [ 0, 1, 2, 3 ]
                }
            ]
        } );
        
        loadAllDomElement();
        var rangeSelector = __instanceCharts.rangeSelector;
        rangeSelector.buttons[ 0 ].show( false );
        rangeSelector.buttons[ 1 ].hide( false );
        rangeSelector.buttons[ 2 ].hide( false );
        rangeSelector.buttons[ 3 ].hide( false );
        __instanceCharts.series[ 0 ].remove( false );
        __instanceCharts.series[ 0 ].remove( true );
        
        if ( __selected_metric ) {
            __instance_detail_graph_host.addSelectedMetric( JSON.parse( b64Decode( __selected_metric ) ) );
        }
        
        change_timerange_detail( '-1d', true );
        $( '.select_timerange' ).button();
        computeSizeGraphic();
    }, 50 );
}

//============================================================//
function computeSizeGraphic () {
    __instance_detail_graph_container.setWidth( __instance_detail_graph_host.getWidth() );
    __instanceCharts.reflow();
}

function removeCheckDetail ( check_id ) {
    cleanErrorMessage();
    setResetExtremes( false );
    __instance_detail_graph_host.removeCheckDetail( check_id );
}

function addCheckDetail ( check_id ) {
    __instance_detail_graph_host.addCheckDetail( check_id );
}

function removeMetricDetail ( check_id, metric_id ) {
    cleanErrorMessage();
    __instance_detail_graph_host.removeMetricDetail( check_id, metric_id );
}

function addMetricDetail ( check_id, metric_id ) {
    __instance_detail_graph_host.addMetricDetail( check_id, metric_id );
}

function addThresholdDetail ( check_id, metric_id, threshold_type ) {
    __instance_detail_graph_host.addThresholdDetail( check_id, metric_id, threshold_type );
}

function removeThresholdDetail ( check_id, metric_id, threshold_type ) {
    __instance_detail_graph_host.removeThresholdDetail( check_id, metric_id, threshold_type );
}

//*********************	SEPARATOR RESIZER      ****************************************************************************//
function separatorDragStart ( event ) {
    document.getElementById( 'cv_graphics_cont' ).classList.add( 'dragging-separator' );
    __instance_detail_graph_host.dragStart();
    __instance_detail_graph_separator.dragStart( event );
    SHINKEN_TOOLTIP.hideTooltip();
}

function separatorDragEnd ( event ) {
    if ( __instance_detail_graph_separator.isDragging ) {
        document.getElementById( 'cv_graphics_cont' ).classList.remove( 'dragging-separator' );
        __instance_detail_graph_separator.dragEnd( event );
        __instance_detail_graph_host.changeWidth( __instance_detail_graph_separator.getDeltaX() );
        __instance_detail_graph_host.changeWidth( __instance_detail_graph_separator.getDeltaX() );
        setTimeout( computeSizeGraphic(), 1000 );
        window.parent.newDetailGraphWidth( __instance_detail_graph_host.getWidth() );
        SHINKEN_TOOLTIP.hideTooltip();
    }
    
    
}

function separatorDragging ( event ) {
    if ( __instance_detail_graph_separator.isDragging ) {
        __instance_detail_graph_separator.dragging( event );
        __instance_detail_graph_host.changeWidth( __instance_detail_graph_separator.getDeltaX() );
        __instance_detail_graph_container.setWidth( __instance_detail_graph_host.getWidth() );
        SHINKEN_TOOLTIP.hideTooltip();
    }
}

window.addEventListener( "resize", function () {
    computeSizeGraphic();
} );