Highcharts.theme = {
    colors                    : [ '7FCAFF', '7F97FF', 'A77FFF', 'E77FFF', 'FF7FB0', 'FF9C7E', 'FFBD7E', 'FFD77E', 'FFF17E', 'F3FF7E', 'CAF562', '62F5C8', '7FCAFF', '83C5D1', 'B2D9D6', '798287', 'C3D7BF', 'C7DAD4', 'FCD6E1', 'F0E5E1', 'E3E2F0', 'F1D9FB' ],
    global                    : {
        useUTC        : true,
        timezoneOffset: __offset_time_zone_backend
    },
    chart                     : {
        backgroundColor    : {
            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 }, // I do not want a background at all
            stops         : [ [ 0, 'rgba(96, 96, 96, 0)' ], [ 1, 'rgba(16, 16, 16, 0)' ] ]
        },
        borderWidth        : 0,
        borderRadius       : 4,
        plotBackgroundColor: null,
        plotShadow         : false,
        plotBorderWidth    : 0,
        marginBottom       : 5,
        animation          : false
    },
    title                     : {
        style: { color: '#FF0000', font: '16px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif' }
    },
    subtitle                  : {
        style: { color: '#DDD', font: '12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif' }
    },
    xAxis                     : {
        showEmpty    : true,
        gridLineWidth: 0,
        lineColor    : 'black',
        tickColor    : 'black',
        labels       : {
            style: { color: 'black', fontWeight: 'bold' }
        },
        title        : {
            style: { color: '#AAA', font: 'bold 12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif' }
        }
    },
    yAxis                     : {
        opposite      : false,
        lineWidth     : 1,
        visible       : true,
        showEmpty     : true,
        gridLineColor : '#999999',
        showFirstLabel: true,
        showLastLabel : true,
        
        labels: {
            x        : 2,
            y        : -2,
            align    : 'left',
            useHTML  : false,
            formatter: function () {
                return this.value;
            },
            style    : {
                color     : 'black',
                fontWeight: 'bold'
            }
        },
        title : {
            style: {
                color: 'black',
                font : 'bold 12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'
            }
        }
    },
    legend                    : {
        itemStyle      : { color: '#CCCCCC' },
        itemHoverStyle : { color: '#FFFFFF' },
        itemHiddenStyle: { color: '#333333' }
    },
    labels                    : {
        style: { color: '#CCC' }
    },
    tooltip                   : {
        backgroundColor: 'rgba(0,0,0,0.5)',
        borderWidth    : 0,
        style          : { color: '#FFFFFF' },
        positioner     : function ( labelWidth, labelHeight, point ) {
            if ( point.plotX * 2 > this.chart.plotBox.width ) {
                return { x: 10, y: 40 };
            }
            else {
                return { x: this.chart.plotBox.x + this.chart.plotBox.width - 230, y: 40 };
            }
        },
        shared         : true,
        useHTML        : true,
        formatter      : function () {
            return shinken_graph_tooltip_header( this.x ) + shinken_graph_tooltip_table_data( this.points );
        }
    },
    plotOptions               : {
        series     : {
            shadow: true,
            states: {
                hover: {
                    animation    : false,
                    enabled      : true,
                    //halo         : false,
                    lineWidthPlus: 0
                    // lineWidth : 1
                }
            }
        },
        line       : {
            dataLabels  : { color: '#CCC' },
            marker      : { lineColor: '#333' },
            dataGrouping: {
                enabled: false
            }
        },
        spline     : {
            marker      : { lineColor: '#333' },
            dataGrouping: {
                enabled: false
            }
        },
        scatter    : {
            marker: { lineColor: '#333' }
        },
        candlestick: { lineColor: 'white' }
    },
    toolbar                   : {
        itemStyle: { color: '#CCC' }
    },
    navigation                : {
        buttonOptions: {
            symbolStroke     : '#DDDDDD',
            hoverSymbolStroke: '#FFFFFF',
            theme            : {
                fill  : {
                    linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                    stops         : [ [ 0.4, '#606060' ], [ 0.6, '#333333' ] ]
                },
                stroke: '#000000'
            }
        }
    },
    // scroll charts
    rangeSelector             : {
        inputEnabled: false,
        buttonTheme : {
            stroke: '#000000',
            r     : 3,
            width : 40,
            height: 17,
            style : {
                color: '#000000'
            },
            fill  : {
                linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                stops         : [ [ 0, '#D8D8D8' ], [ 1, '#CBCBCB' ] ]
            },
            states: {
                hover : {
                    fill  : {
                        linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                        stops         : [ [ 0, '#BBBBBB' ], [ 1, '#888888' ] ]
                    },
                    stroke: '#000000',
                    style : { color: '#000000' }
                },
                select: {
                    fill : {
                        linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                        stops         : [ [ 0, '#38C0FF' ], [ 1, '#0597DA' ] ]
                    },
                    style: {
                        color     : '#FFFFFF',
                        fontWeight: 'normal'
                    }
                }
            }
        },
        inputStyle  : {
            backgroundColor: '#333',
            color          : 'silver'
        },
        labelStyle  : {
            color: 'silver'
        }
    },
    navigator                 : {
        xAxis       : {
            labels: {
                style: {
                    'text-shadow': '-1px -1px 0 #FFFFFF,1px -1px 0 #FFFFFF, -1px 1px 0 #FFFFFF,1px 1px 0 #FFFFFF',
                    color        : '#999999'
                }
            }
        },
        handles     : {
            backgroundColor: '#666666',
            borderColor    : '#AAAAAA'
        },
        outlineColor: '#CCC',
        maskInside  : false,
        maskFill    : 'rgba(16, 16, 16, 0.5)',
        margin      : 40
    },
    scrollbar                 : {
        enabled: false
    },
    lang                      : {
        rangeSelectorZoom: _( 'graphics.rangeSelectorZoom' ),
        months           : _( 'graphics.months' ),
        shortMonths      : _( 'graphics.shortMonths' ),
        weekdays         : _( 'graphics.weekdays' )
    },
    // special colors for some of the demo examples
    legendBackgroundColor     : 'rgba(48, 48, 48, 0.8)',
    legendBackgroundColorSolid: 'rgb(70, 70, 70)',
    dataLabelsColor           : '#444',
    textColor                 : '#E0E0E0',
    maskColor                 : 'rgba(255,255,255,0.3)'
};

function load_theme () {
    Highcharts.setOptions( Highcharts.theme );
}