'use strict';

SHINKEN_METRIC.Object           = function () {
    // uuid
    // uuid_host
    // name
    // host_name
    // metric_id
    // check_name
    // critical
    // warning
    // status
    // main_serie
    // critical_serie
    // warning_serie
};
SHINKEN_METRIC.Object.prototype = {
    init                   : function ( data ) {
        this.uuid_check          = data.uuid;
        this.uuid_host           = data.uuid_host;
        this.metric              = data.metric;
        this.host_name           = data.host_name;
        this.service_description = data.service_description;
        this.main_serie          = new SHINKEN_METRIC.Serie( data, SHINKEN_METRIC.CONST.SERIE.MAIN.KEY );
        if ( data[ SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY ] ) {
            this.critical_serie = new SHINKEN_METRIC.Serie( data, SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY );
        }
        if ( data[ SHINKEN_METRIC.CONST.SERIE.WARNING.KEY ] ) {
            this.warning_serie = new SHINKEN_METRIC.Serie( data, SHINKEN_METRIC.CONST.SERIE.WARNING.KEY );
        }
    },
    initWithDomElement     : function ( dom_element, data ) {
        this.metric_id                                  = dom_element.dataset.metricId;
        data[ SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY ] = dom_element.dataset.thresholdCrit === "True";
        data[ SHINKEN_METRIC.CONST.SERIE.WARNING.KEY ]  = dom_element.dataset.thresholdWarn === "True";
        data[ 'uuid' ]                                  = dom_element.dataset.checkUuid;
        data[ 'metric' ]                                = dom_element.dataset.metricName;
        this.init( data );
        var _self = this;
        _self.main_serie.setDomElement( dom_element );
    },
    initThresholds         : function ( dom_element ) {
        var _threshold_lines = dom_element.querySelectorAll( '.shinken-threshold-line[data-metric-id="' + this.metric_id + '"]' );
        var _current;
        for ( var i = 0, _size = _threshold_lines.length; i < _size; i++ ) {
            _current = _threshold_lines[ i ];
            switch ( _current.dataset.thresholdType ) {
                case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                    this.critical_serie.setDomElement( _current );
                    this.critical_serie.computeStyleThresholdLine();
                    break;
                case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                    this.warning_serie.setDomElement( _current );
                    this.warning_serie.computeStyleThresholdLine();
                    break;
            }
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    removeMetricDetail     : function () {
        this.removeMetricSeries();
        this.main_serie.setActive( false );
        if ( this.critical_serie ) {
            this.critical_serie.setActive( false );
        }
        if ( this.warning_serie ) {
            this.warning_serie.setActive( false );
        }
    },
    addMetricDetail        : function () {
        if ( this.main_serie.isActive() ) {
            return;
        }
        var is_metric_in_graph = is_serie_in_graphs( this.host_name, this.service_description, this.metric );
        if ( is_metric_in_graph ) {
            return;
        }
        setResetExtremes( false );
        this.main_serie.setActive( true );
        this.loadMetric( timerange, show_trending );
    },
    addThresholdDetail     : function ( check_id, threshold_type ) {
        switch ( threshold_type ) {
            case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                if ( this.critical_serie.isActive() ) {
                    return;
                }
                this.critical_serie.setActive( true );
                break;
            case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                if ( this.warning_serie.isActive() ) {
                    return;
                }
                this.warning_serie.setActive( true );
                break;
        }
        this.main_serie.setActive( true );
        this.loadMetric( timerange, show_trending );
    },
    removeThresholdDetail  : function ( threshold_type ) {
        switch ( threshold_type ) {
            case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                this.critical_serie.setActive( false );
                break;
            case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                this.warning_serie.setActive( false );
                break;
        }
    },
    removeMetricSeries     : function () {
        this.main_serie.removeSerie();
        if ( this.critical_serie ) {
            this.critical_serie.removeSerie();
        }
        if ( this.warning_serie ) {
            this.warning_serie.removeSerie();
        }
    },
    reInit                 : function () {
        if ( !this.main_serie.isActive() ) {
            return;
        }
        this.removeMetricSeries();
        this.loadMetric( timerange, show_trending );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getUUID                : function () {
        return this.uuid_check;
    },
    getMetricId            : function () {
        return this.metric_id;
    },
    getSeries              : function () {
        var _to_return  = [];
        _to_return[ 0 ] = this.main_serie;
        if ( this.warning_serie ) {
            _to_return[ 1 ] = this.warning_serie;
        }
        if ( this.critical_serie ) {
            _to_return.push( this.critical_serie );
        }
        return _to_return;
    },
    getMetric              : function () {
        return this.metric;
    },
    setMetricError         : function ( error ) {
        var _status = error.status;
        switch ( _status ) {
            case 401:
            case 403:
            case 404:
            case 500:
            case 512:
            case 513:
                this.setStatus( _status );
                break;
        }
    },
    setStatus              : function ( status ) {
        this.status = status;
        var _series = this.getSeries();
        for ( var i = 0, _size = _series.length; i < _size; i++ ) {
            _series[ i ].setStatus( status );
        }
    },
    setDisabledSeries      : function ( to_set, status ) {
        if ( this.warning_serie ) {
            this.warning_serie.setIsValid( to_set );
            this.warning_serie.setStatus( status );
        }
        if ( this.critical_serie ) {
            this.critical_serie.setIsValid( to_set );
            this.critical_serie.setStatus( status );
        }
        this.main_serie.setIsValid( to_set );
        this.main_serie.setStatus( status );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    loadMetric             : function ( timerange, show_trending ) {
        var self    = this;
        var _metric = DETAIL_GRAPHS_CALL ? this.metric : this.metric.name;
        var jqxhr   = $.getJSON( '/api/graphs/data/' + this.uuid_check + '?metric=' + _metric + '&from=' + timerange + '&trending=' + show_trending, function ( data ) {
            var _series = self.create_series_from_data( data );
            push_series_to_highstock( _series, true );
        } );
        jqxhr.fail( function ( obj ) {
            self.setMetricError( obj );
        } );
    },
    create_series_from_data: function ( data ) {
        var series = [];
        for ( var i = 0, _size_data = data.length; i < _size_data; i++ ) {
            var e                     = data[ i ];
            var serie                 = {};
            var warn                  = endsWith( e.name, '_warn' );
            var crit                  = endsWith( e.name, '_crit' );
            var trending              = e.trending;
            var real_metric           = !(warn || crit || trending);
            serie.name_server         = e.name;
            serie.name                = name_serie_formatter( e.host_name, e.check_name, e.metric_name, real_metric, warn, crit, trending );
            serie.display_name        = e.metric_name + " (" + e.check_name + ") (" + e.host_name + ")";
            serie.data_server         = clone_object( e.values );
            serie.interval            = e.interval;
            serie.data                = parseDataForGraph( e.values, serie.interval );
            // serie.data         = serie.data_server ;
            serie.uuid                = e.uuid;
            serie.hname               = e.host_name;
            serie.host_name           = e.host_name;
            serie.sdesc               = e.check_name;
            serie.service_description = e.check_name;
            serie.metric              = e.metric_name;
            serie.real_metric         = real_metric;
            serie.warn                = warn;
            serie.crit                = crit;
            serie.trending            = trending;
            serie.has_value           = e.has_value;
            
            if ( real_metric ) {
                if ( serie.has_value ) {
                    $( '#container' ).highcharts().setTitle( { text: "" }, {}, false );
                }
                else {
                    $( '#container' ).highcharts().setTitle( { text: _( 'graphics.no_data' ) + e.check_name + "/" + e.metric_name }, {}, false );
                }
            }
            
            if ( serie.warn && this.warning_serie ) {
                if ( DETAIL_GRAPHS_CALL ) {
                    if ( this.warning_serie.isActive() && !is_serie_in_graphs( this.host_name, this.service_description, serie.metric ) ) {
                        series.push( serie );
                    }
                }
                else {
                    this.warning_serie.setIsValid( true );
                    series.push( serie );
                }
            }
            else if ( serie.crit && this.critical_serie ) {
                if ( DETAIL_GRAPHS_CALL ) {
                    if ( this.critical_serie.isActive() && !is_serie_in_graphs( this.host_name, this.service_description, serie.metric ) ) {
                        series.push( serie );
                    }
                }
                else {
                    this.critical_serie.setIsValid( true );
                    series.push( serie );
                }
            }
            else if ( serie.real_metric ) {
                if ( DETAIL_GRAPHS_CALL && is_serie_in_graphs( this.host_name, this.service_description, serie.metric ) ) {
                    continue;
                }
                this.main_serie.setIsValid( true );
                this.updateAllSeriesLabel( e.host_name, e.check_name );
                series.push( serie );
            }
        }
        return series;
    },
    isActive               : function () {
        return this.main_serie.isActive();
    },
    updateAllSeriesLabel   : function ( host_name, service_description ) {
        if ( this.main_serie.host_name === host_name && this.main_serie.service_description === service_description ) {
            return;
        }
        
        this.main_serie.updateLabel( host_name, service_description );
        if ( this.critical_serie ) {
            this.critical_serie.updateLabel( host_name, service_description );
        }
        if ( this.warning_serie ) {
            this.warning_serie.updateLabel( host_name, service_description );
        }
    },
    refreshSeries          : function ( data ) {
        for ( var i = 0, _size_data = data.length; i < _size_data; i++ ) {
            var _current_serie = data[ i ];
            var warn           = endsWith( _current_serie.name, '_warn' );
            var crit           = endsWith( _current_serie.name, '_crit' );
            var trending       = _current_serie.trending;
            var real_metric    = !(warn || crit || trending);
            
            if ( warn && this.warning_serie ) {
                this.warning_serie.setStatus( 200 );
                this.warning_serie.setIsValid( true );
            }
            else if ( crit && this.critical_serie ) {
                this.critical_serie.setStatus( 200 );
                this.critical_serie.setIsValid( true );
            }
            else if ( real_metric ) {
                if ( !this.main_serie.is_valid ) {
                    console.log( "window.location.reload" );
                    window.location.reload();
                }
                this.updateAllSeriesLabel( _current_serie.host_name, _current_serie.check_name );
                this.main_serie.setStatus( 200 );
                this.main_serie.setIsValid( true );
            }
        }
        
    }
};