%import time
%import json
%now = time.time()
%helper = app.helper
%datamgr = app.datamgr

%top_right_banner_state = datamgr.get_overall_state()

%_ = app._

<script type="text/javascript">
    var page = '{{page}}';
    var cols = {{cols}};
    var tab_nb_elts = {{tab_nb_elts}};
</script>


<script type="text/javascript">
    $(function(){
        // When the user is clicking on the background we close the possible panels. They should be outside #mainpart
        // of course because we don't want to close them when the user is clicking into them :)
        $('#main_part').on('click', function(){
            close_table_options();
        });
    });
</script>

%# Look for actions if we must show them or not
%global_disabled = ''
%if app.manage_acl and not helper.can_action(user):
    %global_disabled = 'disabled-link'
    <script type="text/javascript">
        var actions_enabled = false;
    </script>
%else:
    <script type="text/javascript">
        var actions_enabled = true;
    </script>
%end

%if toolbar=='hide':
    <script type="text/javascript">
        var toolbar_hide = true;
    </script>
%else:
    <script type="text/javascript">
        var toolbar_hide = false;
    </script>
%end

<script type="text/javascript">
    function submitform()  {
        document.forms["search_form"].submit();
    }

    /* Catch the key ENTER and launch the form
    Will be link in the password field
    */
    function submitenter ( myfield, e ) {
        var keycode;
        if ( window.event ) {
            keycode = window.event.keyCode;
        }
        else if ( e ) {
            keycode = e.which;
        }
        else {
            return true;
        }

        if ( keycode == 13 ) {
            submitform ();
            return false;
        }
        else {
            return true;
        }
    }

    $ ( '.typeahead' ).typeahead ( {
        // note that "value" is the default setting for the property option
        source:   function ( typeahead, query ) {
            $.ajax ( {
                url:     "/lookup/" + query,
                success: function ( data ) {
                    typeahead.process ( data )
                }
            } );
        },
        onselect: function ( obj ) {
            $ ( "ul.typeahead.dropdown-menu" ).find ( 'li.active' ).data ( obj );
        }
    } );

    var active_filters = [];

    // List of the bookmarks
    var bookmarks = [];
    var bookmarksro = [];

    // Ok not the best way to restrict the admin functions to admin, but I can't find another way around.
    %if user.is_admin:
        var advfct=1;
    %else:
        var advfct=0;
    %end

    %for b in bookmarks:
        declare_bookmark("{{!b['name']}}","{{!b['uri']}}");
    %end
    %for b in bookmarksro:
        declare_bookmarksro("{{!b['name']}}","{{!b['uri']}}");
    %end

</script>


<script type="text/javascript">
    // We will create here our new filter options
    // This should be outside the "pageslide" div. I don't know why
    new_filters = [];

    %tfilters = []
    %for (t, s) in filters.iteritems():
        %if len(s) > 0:
            %tfilters.append({'type':t, 'value':s[0]})
        %end
    %end
    current_filters = {{!json.dumps(tfilters)}};
</script>

<div id="pageslide" style="display:none">
  <div class='row'>
    <span class='span8'><h2>Filtering options</h2></span>
    <span class='span3 pull-right'><a class='btn btn-danger' href="javascript:$.pageslide.close()"><i class="icon-remove"></i> Close</a></span>
  </div>
  <div class='in_panel_filter'>
    <h3>Names</h3>
    <form name='namefilter' class='form-horizontal'>
      <input name='name'></input>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_name_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <h3>Hostgroup</h3>
    <form name='hgfilter' class='form-horizontal'>
      <select name='hg'>
	%for hg in datamgr.get_hostgroups_sorted():
	<option value='{{hg.get_name()}}'> {{hg.get_name()}} ({{len(hg.members)}})</option>
	%end
      </select>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_hg_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <h3>Tag</h3>
    <form name='htagfilter' class='form-horizontal'>
      <select name='htag'>
	%for (t, n) in datamgr.get_host_tags_sorted():
	<option value='{{t}}'> {{t}} ({{n}})</option>
	%end
      </select>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_htag_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <h3>Realms</h3>
    <form name='realmfilter' class='form-horizontal'>
      <select name='realm'>
	%for r in datamgr.get_realms():
	<option value='{{r}}'> {{r}}</option>
	%end
      </select>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_realm_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <h3>States</h3>
    <form name='ack_filter' class='form-horizontal'>

      <span class="help-inline">Ack </span>
      %if page=='problems':
      <input type='checkbox' name='show_ack'></input>
      %else:
      <input type='checkbox' name='show_ack' checked></input>
      %end

      <span class="help-inline">Both ack states</span>
      <input type='checkbox' name='show_both_ack'></input>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_state_ack_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <form name='downtime_filter' class='form-horizontal'>
      <span class="help-inline">Downtime</span>
      %if page=='problems':
      <input type='checkbox' name='show_downtime'></input>
      %else:
      <input type='checkbox' name='show_downtime' checked></input>
      %end
      <span class="help-inline">Both downtime states</span>
      <input type='checkbox' name='show_both_downtime'></input>
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_state_downtime_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <form name='criticity_filter' class='form-horizontal'>
      <span class="help-inline">Critical Only</span>
      %if page=='problems':
      <input type='checkbox' name='show_critical'></input>
      %else:
      <input type='checkbox' name='show_critical' checked></input>
      %end
      <p class='pull-right'><a class='btn btn-success pull-right' href="javascript:save_state_criticity_filter();"> <i class="icon-chevron-right"></i> Add</a></p>
    </form>

    <span><p>&nbsp;</p></span>


  </div>
  <div class='row'>
    <span class='pull-left'><a id='remove_all_filters' class='btn btn-inverse' href="javascript:clean_new_search();"> <i class="icon-remove"></i> Remove all filters</a></span>
    <span class='pull-right'><a id='launch_the_search' class='btn btn-warning' href="javascript:launch_new_search('/{{page}}');"> <i class="icon-play"></i> Launch the search!</a></span>
    <span><p>&nbsp;</p></span>
  </div>
  <div id='new_search'>
  </div>

  <!-- We put a final touch at the filters and buttons of this panel -->
  <script>refresh_new_search_div();</script>

</div>

<script >
    $(function(){
        $ ( ".slidelink" ).pageslide ( { direction: "right", modal: true } );
        // When the user ask for the panel, he don't want to refresh now
        $ ( ".slidelink" ).click ( function () {
            reinit_refresh ();
        } );
    } );

    $ ( function () {
        // We prevent the drpdown to close when we go on a form into it.
        $ ( '.form_in_dropdown' ).on ( 'click', function ( e ) {
            e.stopPropagation ()
        } );
    } );
</script>

%include mainmenu globals(), enable_search=True

%# Use to enable old or new filtering place
<div id='filter-left-panel' class='' style='overflow:visible;'>
    %include tabular_filters globals()
    <button onclick="toggle_left_panel()" class="btn btn-default btn-sm shinkon shinkon-arrow-left"></button>
</div>


<div id='main_part' style='margin-top:60px; margin-left:0px;min-height:1080px;'>
    <span id='progress-bar' style="margin-left:-4%; background-color: #4C3EFD; position: absolute; top:60px; height: 3px;font-size: 1px;width: 0%;box-shadow: 0 2px 2px rgba(0,0,0,.25);">b</span>

    <div style='background-color: #FF4C4C;  border-color: #FF0026;  color: #FFFFFF;' class='alert alert-error hide' id='global_backend_error'></div>

    <div id='toolbar' class='gray-back top-box-gray hide' style='position:relative;'>
        <img src="/static/{{app.http_start_time}}/eltdetail/images/corner-bottom-right.png" style="position:absolute;right:0%;bottom:0%;">
        <div id='global_bookmarks'>
            <h3>Quick search</h3>
            <ul class="unstyled">
            %for e in quick_searches:
                <li><i class="icon-tag"></i><a href="{{e['path']}}">{{e['display']}}</a></li>
            %end
            </ul>
        </div>
        <div id='bookmarks'></div>
        <script>
            $ ( function () {
                refresh_bookmarks ();
            } );
        </script>
    </div>


    <!-- Start of the Right panel, with all problems -->
    <div class=" no-leftmargin">
        <div class='span12'>
            <!-- Keep to make the span2 NOt the first-->
            <div></div>
            <div class='span6' style='min-height:40px;'>
                <div class="btn-toolbar">
                    %# REVERSE: remove this span to reverse to the old select combo mode
                    <span style='display:none;'>'
                        <a id='select_all_btn' style="display:inline;" href="javascript:select_all_problems()" data-toggle="tooltip" data-placement="bottom" data-original-title="Select all" class="btn btn_hide_when_selection applytooltip"><i class="icon-check"></i></a>
                        <a id='unselect_all_btn' data-toggle="tooltip" data-placement="bottom" data-original-title="Unselect all"  style="display:inline;" href="javascript:unselect_all_problems()" class="btn btn_show_when_selection applytooltip"><i class="icon-minus"></i></a>
                    </span>

                    <div class="btn-group" style='display:none;'>
                        <a href='javascript:toggle_filters_panel();' style="display:inline;" class='btn applytooltip' data-toggle="tooltip" data-placement="bottom" data-original-title="Filter" id='filters_panel_btn'>filter</a>
                    </div>

                    <div class="btn-group btn_show_when_selection" style='display:none;'>
                        <a class="btn applytooltip" style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.recheck_now')}}" href="javascript:recheck_now_all()"><i class="icon-repeat icon-white"></i></a>
                        <a class="btn applytooltip" style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.acknowledge')}}" href="javascript:acknowledge_all('{{user.get_name()}}')"><i class="icon-ok icon-white"></i></a>
                        <a class="btn applytooltip" style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.try_to_fix')}}" href="javascript:try_to_fix_all();"><i class="icon-pencil icon-white"></i></a>
                        <a class="btn applytooltip" style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.submit_ok_result')}}" href="javascript:submit_check_ok_all()"><i class="icon-share-alt icon-white"></i></a>
                    </div>
                </div>
            </div>
            <div class='span5'>
	            %include pagination_element navi=navi, app=app, page=page, div_class="center no-side-margin bottommargin1 topmmargin1"
            </div>
            <div class='span1 pull-right' style="right: 89px;  position: absolute;min-width: 100px;">
                <div class="btn-toolbar">
                    <div class="btn-group" style='box-shadow: 0 5px 15px rgba(0,0,0,.25);'>
                        <a style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.options')}}" class="btn applytooltip" href="javascript:toggle_table_options();"><i id='btn-options' class="icon-cog"></i></a>
                    </div>
                    <div class="btn-group" style='box-shadow: 0 5px 15px rgba(0,0,0,.25);'>
                        <a style="display:inline;" data-toggle="tooltip" data-placement="bottom" data-original-title="{{app._('list.refresh')}}" class="btn btn_hide_when_selection applytooltip" href='javascript:force_refresh();'> <i class="icon-refresh"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <div id="accordion" class="" style='margin-left: 35px;'>

            %# " We remember the last hname so see if we print or not the host for a 2nd service"
            %last_hname = ''

            %# " We try to make only importants things shown on same output "
            %last_output = ''
            %nb_same_output = 0
            %if app.datamgr.get_nb_problems() > 0 and page == 'problems' and app.play_sound:
                <EMBED src="/static/{{app.http_start_time}}/sound/alert.wav" autostart=true loop=false volume=100 hidden=true>
            %end

	        %# Main table
            <table class='table-striped table-bordered table-hover pull-left tabular_table ' style='box-shadow: 0 5px 15px rgba(0,0,0,.25);margin-top:5px;margin-bottom: 20px;margin-right:10px;'>
                <thead style="background-color: #c2c2c2; /*color:#a2a2a2;*/">
                    <tr>
                        <th class='tick' style="cursor:pointer;" onclick="toggle_select_all_btn()">
                            <div style="background-color:#dfdfdf;">
                                <img id="ALL-selector" class="img_tick" src="/static/{{app.http_start_time}}/images/tick.png" style="display: none;margin-top: -5px;">
                            </div>
                        </th>
                        <th class='th-tag'>{{app._('list.icon')}}</th>
                        <th id='th-summary' class='th-summary'>{{app._('list.context')}} <i onclick="javascript:unset_tab_option('summary');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-state' class='th-state'>{{app._('list.status')}} <i onclick="javascript:unset_tab_option('state');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-type' class='th-type'>{{app._('list.type')}}</th>
                        <th id='th-host' class='hostname'>{{app._('list.host_name')}}</th>
                        <th id='th-check' class='srvdescription'>{{app._('list.check_name')}}</th>
                        <th id='th-display-name' class='th-display-name' style='min-width: 150px;'>{{app._('list.display_name')}} <i onclick="javascript:unset_tab_option('display-name');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-address' class='th-address' style='min-width: 150px;'>{{app._('list.address')}} <i onclick="javascript:unset_tab_option('address');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-business-impact' class='th-business-impact' style='min-width: 150px;'>{{app._('list.business_impact')}} <i onclick="javascript:unset_tab_option('business-impact');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-realm' class='th-realm' style='min-width: 80px;'>{{app._('list.realm')}} <i onclick="javascript:unset_tab_option('realm');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-tag' class='th-tags' style='min-width: 90px;'>{{app._('list.host_templates')}} <i onclick="javascript:unset_tab_option('tags');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-hostgroups' class='th-hostgroups' style='min-width: 90px;'>{{app._('list.hostgroups')}} <i onclick="javascript:unset_tab_option('hostgroups');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-servicegroups' class='th-servicegroups'>{{app._('list.servicegroups')}} <i onclick="javascript:unset_tab_option('servicegroups');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-contacts' class='th-contacts' style='min-width: 100px;'>{{app._('list.contacts')}} <i onclick="javascript:unset_tab_option('contacts');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-parents' class='th-parents' style='min-width: 110px;'>{{app._('list.link_to')}} <i onclick="javascript:unset_tab_option('parents');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-state-type' class='th-state-type' style='min-width: 90px;'>{{app._('list.confirmed')}} <i onclick="javascript:unset_tab_option('state-type');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-last-check' class='th-last-check' style='min-width: 100px;'>{{app._('list.last_check')}} <i onclick="javascript:unset_tab_option('last-check');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-attempts' class='th-attempts' style='min-width: 90px;'>{{app._('list.attempts')}} <i onclick="javascript:unset_tab_option('attempts');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-duration' class='th-duration' style='min-width: 90px;'>{{app._('list.duration')}} <i onclick="javascript:unset_tab_option('duration');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-root-problem' class='th-root-problem' style='min-width: 120px;'>{{app._('list.is_root_problem')}} <i onclick="javascript:unset_tab_option('root-problem');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-acknowledged' class='th-acknowledged' style='min-width: 120px;'>{{app._('list.is_acknowledged')}}<i onclick="javascript:unset_tab_option('acknowledged');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-downtime' class='th-downtime' style='min-width: 110px;'>{{app._('list.in_downtime')}} <i onclick="javascript:unset_tab_option('downtime');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-output' class='th-output'>{{app._('list.output')}} <i onclick="javascript:unset_tab_option('output');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-long_output' class='th-long_output'>{{app._('list.long_output')}} <i onclick="javascript:unset_tab_option('long_output');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                        <th id='th-impact' class='th-impactt'>{{app._('list.impact')}} <i onclick="javascript:unset_tab_option('impact');" style="cursor:pointer;opacity:0.6;" class="icon-remove th-close-icon"></i></th>
                    </tr>
                </thead>
                <tbody>
                    <!-- First TR about filtering -->
                    <tr id='quick-filtering'>
                        <td colspan=2>
                            <div class='input-prepend'><span class="add-on" style='width: 100%;padding-right:0px; padding-left:0px;'><i onclick="javascript:search_tab_header('');" style="cursor:pointer;opacity:0.6;" class="icon-search"></i></span></div>
                        </td>
                        <td class='td-summary'>
                            <div class="input-prepend" id='search-summary'>
                                <select id='input-summary-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Context'>
                                    <option value=''></option>
                                    <option value='DOWNTIME'>In Downtime</option>
                                    <option value='NO-DOWNTIME'>Not In Downtime</option>
                                    <option value='ACKNOWLEDGED'>Acknowledged</option>
                                    <option value='NO-ACKNOWLEDGED'>Not Acknowledged</option>
                                    <option value='FLAPPING'>In Flapping</option>
                                    <option value='NO-FLAPPING'>Not In Flapping</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-state'>
                            <div class="input-prepend" id='search-state-bloc'>
                                <select id='input-state-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Status'>
                                    <option value=''></option>
                                    <option value='OK-UP' style='color:#2a9a3d;font-weight: bold;'>OK/UP</option>
                                    <option value='WARNING'  style='color:#e48c19' >WARNING</option>
                                    <option value='CRITICAL-DOWN'  style='color:#dc2020'>CRITICAL/DOWN</option>
                                    <option value='UNKNOWN-PENDING-UNREACHEABLE'  style='color:#54676C;font-weight: bold;'>UNKNOWN</option>
                                </select>
                            </div>
                        </td>
                        <td>
                            <div class="input-prepend" id='search-type-bloc'>
                                <select id='input-type-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Type'>
                                    <option value=''></option>
                                    <option value='CLUSTER'>Cluster</option>
                                    <option value='HOST'>Host</option>
                                    <option value='CHECK'>Check</option>
                                </select>
                            </div>
                        </td>
                        <td>
                            <div class="input-prepend" id='search-host-bloc'>
                                <input id='input-host-search' type="text" class='' style='width:100%; padding-left:0px; padding-right:0px;' placeholder='{{app._("list.filter_host")}}'>
                            </div>
                        </td>
                        <td>
                            <div class="input-prepend" id='search-check-bloc'>
                                <input id='input-check-search' type="text" class='' style='width:100%; padding-left:0px; padding-right:0px;' placeholder='{{app._("list.filter_check")}}'>
                            </div>
                        </td>
                        <td class='td-display-name'>
                            <div class="input-prepend" id='search-display-name-bloc'>
                                <input id='input-display-name-search' type="text" class='' style='width:100%; padding-left:0px; padding-right:0px;' placeholder='{{app._("list.filter_description")}}'>
                            </div>
                        </td>
                        <td class='td-address'>
                            <div class="input-prepend" id='search-address-bloc'>
                                <input id='input-address-search' type="text" class='' style='width:100%; padding-left:0px; padding-right:0px;' placeholder='{{app._("list.filter_address")}}'>
                            </div>
                        </td>
                        <td class='td-business-impact'>
                            <div class="input-prepend" id='search-business-impact-bloc'>
                                <select id='input-business-impact-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Priority'>
                                    <option value=''></option>
                                    <option value='5' style='font-weight: bold;color:#FFA500;'>&#x24;&#x24;&#x24;&#x24;&#x24;&#x24;</option>
                                    <option value='4' style='font-weight: bold;color:#FFA500;'>&#x24;&#x24;&#x24;&#x24;&#x24;</option>
                                    <option value='3' style='font-weight: bold;color:#FFA500;'>&#x24;&#x24;&#x24;&#x24;</option>
                                    <option value='2' style='font-weight: bold;color:#54676C'>&#9733;&#9733;&#9733;</option>
                                    <option value='1' style='font-weight: bold;color:#54676C'>&#9733;&#9733;</option>
                                    <option value='0' style='font-weight: bold;color:#54676C'>&#9733;</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-realm'>
                            <div class="input-prepend" id='search-realm-bloc'>
                                <select id='input-realm-search'  class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Realm'>
                                    <option value=''></option>
                                    %for r in datamgr.get_realms():
                                        <option value='{{r}}'> {{r}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-tags'>
                            <div class="input-prepend" id='search-tag-bloc'>
                                <select id='input-tag-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Host Tag'>
                                    <option value=''></option>
                                    %for t in [t for t in helper.get_all_tags(app) if t not in ('shinken-host', 'shinken-cluster')]:
                                        <option value='{{t}}'>{{t}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-hostgroups'>
                            <div class="input-prepend" id='search-hostgroups-bloc'>
                                <select id='input-hostgroups-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Group'>
                                    <option value=''></option>
                                    %hgnames = [hg.get_name() for hg in app.datamgr.get_hostgroups()]
                                    %hgnames.sort()
                                    %for hg in hgnames:
                                        <option value='{{hg}}'>{{hg.capitalize()}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-servicegroups'>
                            <div class="input-prepend" id='search-servicegroups-bloc'>
                                <select id='input-servicegroups-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Service Group'>
                                    <option value=''></option>
                                    %hgnames = [hg.get_name() for hg in app.datamgr.get_servicegroups()]
                                    %hgnames.sort()
                                    %for hg in hgnames:
                                        <option value='{{hg}}'>{{hg.capitalize()}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-contacts'>
                            <div class="input-prepend" id='search-contacts-bloc'>
                                <select id='input-contacts-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Managed By'>
                                    <option value=''></option>
                                    %cnames = [c.get_name() for c in app.datamgr.get_contacts()]
                                    %cnames.sort()
                                    %for cname in cnames:
                                        <option value='{{cname}}'>{{cname}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-parents'>
                            <div class="input-prepend" id='search-parents-bloc'>
                                <input id='input-parents-search' type="text" class='' style='width:100%; padding-left:0px; padding-right:0px;' placeholder='{{app._("list.filter_link_to")}}'>
                            </div>
                        </td>
                        <td class='td-state-type'>
                            <div class="input-prepend" id='search-state-type'>
                                <select id='input-state-type-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Confirmed or Not'>
                                    <option value=''></option>
                                    <option value='HARD'>Yes</option>
                                    <option value='SOFT'>No</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-last-check'>
                            <div class="input-prepend" id='search-last-check'>
                                <select id='input-last-check-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Last Check'>
                                    <option value=''></option>
                                    <option value='60'  >Last Minute</option>
                                    <option value='300' >Last 5 minutes</option>
                                    <option value='3600'>Last Hour</option>
                                    <option value='86400'>Today</option>
                                    <option value='{{86400*7}}'>This week</option>
                                    <option value='>{{86400*7}}'>Old checks</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-attempts'>
                            <div class="input-prepend" id='search-attempts'>
                                <select id='input-attempts-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Attempts'>
                                    <option value=''></option>
                                    %for r in range(1, 11):
                                        <option value='{{r}}'>>={{r}}</option>
                                    %end
                                </select>
                            </div>
                        </td>
                        <td class='td-duration'>
                            <div class="input-prepend" id='search-duration'>
                                <select id='input-duration-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Duration'>
                                    <option value=''></option>
                                    <option value='60'  >Last Minute</option>
                                    <option value='300' >Last 5 Minutes</option>
                                    <option value='3600'>Last Hour</option>
                                    <option value='86400'>Today</option>
                                    <option value='{{86400*7}}'>This Week</option>
                                    <option value='>{{86400*7}}'>Before This Week</option>
                                    <option value=''>All</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-root-problem'>
                            <div class="input-prepend" id='search-root-problem-bloc'>
                                <select id='input-root-problem-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Is Root Problem'>
                                    <option value=''></option>
                                    <option value='1'>Yes</option>
                                    <option value='0'>No</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-acknowledged'>
                            <div class="input-prepend" id='search-acknowledged-bloc'>
                                <select id='input-acknowledged-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Is Acknowledged'>
                                    <option value=''></option>
                                    <option value='1'>Yes</option>
                                    <option value='0'>No</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-downtime'>
                            <div class="input-prepend" id='search-downtime-bloc'>
                                <select id='input-downtime-search' class='' style='width:100%; padding-left:0px; padding-right:0px;' title='Select Is Downtime'>
                                    <option value=''></option>
                                    <option value='1'>Yes</option>
                                    <option value='0'>No</option>
                                </select>
                            </div>
                        </td>
                        <td class='td-output'>
                            <div class="input-prepend" id='search-output'>
                                <input id='input-output-search' class="" type="text" style='width:100%; padding-left:0px; padding-right:0px;' placeholder="{{app._('list.filter_output')}}">
                            </div>
                        </td>
                        <td class='td-long_output'>
                            <div class="input-prepend" id='search-long_output'>
                                <input id='input-long_output-search' class="" type="text" style='width:100%; padding-left:0px; padding-right:0px;' placeholder="{{app._('list.filter_long_output')}}">
                            </div>
                        </td>
                        <td class='td-impact'>
                            <div class="input-prepend" id='search-impact'>
                                <input id='input-impact-search' class="" type="text" style='width:100%; padding-left:0px; padding-right:0px;' placeholder="{{app._('list.filter_impact')}}">
                            </div>
                        </td>
                    </tr>
                    %for pb in pbs:
                        %# " We check for the same output and the same host. If we got more than 3 of same, make them opacity effect"
                        %if pb.output == last_output and pb.host_name == last_hname:
                            %nb_same_output += 1
                        %else:
                            %nb_same_output = 0
                        %end

                        %last_output = pb.output
                        %class_tr = ''
                        <tr class='{{class_tr}} element' id='{{helper.get_html_id(pb)}}' data-uuid='{{"%s-%s" % (pb.host.uuid, pb.uuid) if pb.__class__.my_type == 'service' else pb.uuid}}' data-raw-obj-name='{{pb.get_full_name()}}'  style='height:30px;'>
                            <td class='tick' style="cursor:pointer;" onmouseover="hovering_selection('{{helper.get_html_id(pb)}}')" onclick="add_remove_elements('{{helper.get_html_id(pb)}}')">
                                <div>
                                    <img id='selector-{{helper.get_html_id(pb)}}' class='img_tick' src='/static/{{app.http_start_time}}/images/tick.png' style='display:none;'/>
                                </div>
                            </td>

                            <td  class='td-tag'>
                                %if pb.__class__.my_type == 'service':
                                    <center><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/depgraph/images/check.png" /></center>
                                    %else:
                                        %__default_type = 'hardware'
                                    %if pb.got_business_rule:
                                        %__default_type = 'cluster'
                                    %end
                                    <center><img style="width:30px;height:30px;" src="{{helper.get_tag_icon(app, pb, __default_type)}}" /></center>
                                %end
                            </td>

                            <td class='txt_state-type td-summary'>
                                %__d = app.helper.get_summary(pb)
                                %__summary = __d['summary']
                                %if __summary == 'NOTHING':
                                    &nbsp;
                                %end
                                %if __summary in ['PARTIAL-ACKNOWLEDGED']:
                                    <center class='context_acknowledged'><span style="float: left;margin-top: 10px;"><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_partial-acknowledged.png" /></span>
                                        <span>partial ACKNOWLEDGED</span>
                                    </center>
                                %end
                                %if __summary in ['ACKNOWLEDGED']:
                                    <center class='context_acknowledged'><span style="float: left;"><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_acknowledged.png" /></span>
                                        <span>ACKNOWLEDGED</span>
                                    </center>
                                %end
                                %if __summary in ['PARTIAL-FLAPPING']:
                                    <center class='context_flapping'><span style="float: left;margin-top: 10px;"><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_partial-flapping.png" /></span>
                                        <span>partial FLAPPING</span>
                                    </center>
                                %end
                                %if __summary in ['FLAPPING']:
                                    <center class='context_flapping'><span style="position: absolute;float: left;margin-left: -35px;"><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_flapping.png" /></span>
                                        <span>FLAPPING</span>
                                    </center>
                                %end
                                %if __summary in ['DOWNTIME']:
                                    <center class='context_downtime'><span style="position: absolute;float: left;margin-left: -30px;"><img style="width:30px;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_downtime.png" /></span>
                                        <span>DOWNTIME</span>
                                    </center>
                                %end
                            </td>

                            %__state = pb.state
                            %if pb.got_business_rule and pb.__class__.my_type == 'host':
                                %if pb.bp_state == 1:
                                    %__state = 'WARNING'
                                %end
                            %end
                            <td class='txt_status state_{{__state.lower()}} td-state'>
                                <img style="float:left;margin-left:5px;width:30px;;height:30px;" src="/static/{{app.http_start_time}}/img/icons/state_{{__state.lower()}}.png" />
                                %if pb.state == 'PENDING':
                                    UNKNOWN
                                %else:
                                    {{__state}}
                                %end
                            </td>

                            <td  class='td-type'>
                                %if pb.__class__.my_type == 'host' and not pb.got_business_rule:
                                    Host
                                %else:
                                    %if pb.got_business_rule:
                                        Cluster
                                    %else:
                                        Check
                                    %end
                                %end
                            </td>

                            <td class="hostname cut_long">
                                %if pb.host_name == last_hname:
                                    <span style='opacity:0.4;'>{{!helper.get_host_link(pb)}}</span>
                                %else:
                                    {{!helper.get_host_link(pb)}}
                                %end
                            </td>

                            %last_hname = pb.host_name
                            <td class="srvdescription cut_long">
                                %if pb.__class__.my_type == 'service':
                                    {{pb.service_description}}
                                %else:
                                    &nbsp;
                                %end
                            </td>

                            <td class='txt_display-name td-display-name'>
                                %if pb.__class__.my_type == 'service':
                                    {{pb.host.display_name}}
                                %else:
                                    {{pb.display_name}}
                                %end
                            </td>

                            <td class='txt_address td-address'>
                                %if pb.__class__.my_type == 'host':
                                    {{pb.address}}
                                %end
                            </td>

                            <td class='txt_business-impact td-business-impact'>
                                %__bi_icon = 'silver-star'
                                %if pb.business_impact >= 3:
                                    %__bi_icon = 'dollar'
                                %end
                                %for j in range(0, pb.business_impact+1):
                                    <img src='/static/{{app.http_start_time}}/images/{{__bi_icon}}.png' alt='Priority' style='margin:0px;'>
                                %end
                            </td>

                            <td class='txt_realm td-realm'>
                                <a href='/{{page}}?global_search=realm:{{pb.get_realm()}}'>{{pb.get_realm()}}</a>
                            </td>

                            <td class='tags td-tags'>
                                %__o = pb
                                %if pb.__class__.my_type == 'service':
                                    %__o = pb.host
                                %end
                                %for t in [t for t in __o.tags if t not in ('shinken-host', 'shinken-cluster')]:
                                    <a href='/{{page}}?global_search=tag:{{t}}'><span class='label'>{{t}}</span><br></a>
                                %end
                            </td>

                            <td class='tags td-hostgroups'>
                                %__elt = pb
                                %if pb.__class__.my_type == 'service':
                                    %__elt = pb.host
                                %end
                                %for hg in __elt.hostgroups:
                                    <a href='/{{page}}?global_search=hostgroups:{{hg.get_name()}}'><span class='label'>{{hg.get_name()}}</span><br></a>
                                %end
                            </td>

                            <td class='tags td-servicegroups'>
                                %__elt = pb
                                %if pb.__class__.my_type == 'service':
                                    %for hg in __elt.servicegroups:
                                        <a href='/{{page}}?global_search=servicegroups:{{hg.get_name()}}'><span class='label'>{{hg.get_name()}}</span><br></a>
                                    %end
                                %end
                            </td>

                            <td class='tags td-contacts'>
                                %for c in pb.contacts:
                                    <a href='/{{page}}?global_search=contacts:{{c.get_name()}}'><span class='label'>{{c.get_name()}}</span><br></a>
                                %end
                            </td>

                            <td class='parents td-parents'>
                                %if pb.__class__.my_type == 'host':
                                    %for p in getattr(pb, 'my_parents', []):
                                        <span class='label'>{{p}}</span><br>
                                    %end
                                %else:
                                    &nbsp;
                                %end
                            </td>

                            <td class='txt_state-type td-state-type'>
                                %if pb.state_type == 'HARD':
                                    Yes
                                %else:
                                    No
                                %end
                            </td>

                            <td class='txt_last-check td-last-check' data-toggle="tooltip" data-original-title='{{helper.print_date(pb.last_chk)}}'>
                                {{helper.print_duration(pb.last_chk, just_duration=True, x_elts=2)}}
                            </td>

                            <td class='txt_realm td-attempts'>
                                {{pb.attempt}}/{{pb.max_check_attempts}}
                            </td>

                            <td class='duration td-duration' data-toggle="tooltip" data-original-title='{{helper.print_date(pb.last_state_change)}}'>
                                {{helper.print_duration(pb.last_state_change, just_duration=True, x_elts=2)}}
                            </td>

                            <td  class='td-root-problem'>
                                %if pb.is_problem:
                                    Yes
                                %else:
                                    No
                                %end
                            </td>

                            <td  class='td-acknowledged'>
                                %if pb.problem_has_been_acknowledged:
                                    Yes
                                %else:
                                    No
                                %end
                            </td>

                            <td  class='td-downtime'>
                                %if pb.in_scheduled_downtime:
                                    Yes
                                %else:
                                    No
                                %end
                            </td>

                            %# "We put a title (so a tip) on the output only if need"
                            <td class='output td-output' data-toggle="tooltip" data-original-title="{{!pb.output.replace(chr(34), chr(39))}}" >
                                {{!helper.print_output(app, pb.output)}}
                            </td>

                            <td class='output td-long_output' data-toggle="tooltip" data-original-title="{{!pb.long_output.replace(chr(34), chr(39))}}" data-container="#accordion">
                                {{!helper.print_output(app, pb.long_output)}}
                            </td>

                            <td class='output td-impact' >
                                {{pb.is_impact}} - {{pb.source_problems}} - {{pb.is_problem}} - {{pb.impacts}}
                            </td>

                        </tr>
                    %end
                </tbody>
            </table>

            <script>
                $('[data-toggle="tooltip"]').tooltip({container:'#accordion'})
            </script>
        </div>
        %include pagination_element navi=navi, app=app, page=page, div_class="center"
    </div>
</div>

%# """ This div is an image container and will move hover the perfometer with mouse hovering """
<div id="img_hover" class='degraded-back'></div>

<div id="save_search_div" class='hide well' style="position:absolute;">
    <a id="save_search_close_btn" href='javascript:close_save_bookmark();'><i class="icon-remove"></i></a>
    <form id='save_search_form' name='save_search_form' class='form-horizontal'>
        <input type="text" id="save_filter_name" placeholder="Filter name"/>
        <a class="btn" href="javascript:do_save_new_bookmark();">Save</a>
    </form>
</div>

%include table_options_div app=app

%rebase layout globals(), title='All problems', top_right_banner_state=top_right_banner_state, js=['tabular/js/img_hovering.js', 'tabular/js/accordion.js', 'tabular/js/sliding_navigation.js', 'tabular/js/filters.js', 'tabular/js/filtering.js', 'tabular/js/filters2.js', 'tabular/js/bookmarks.js'], css=['tabular/css/filtering.css', 'tabular/css/table_view.css', 'tabular/css/pagenavi.css', 'tabular/css/perfometer.css', 'tabular/css/img_hovering.css', 'tabular/css/sliding_navigation.css', 'tabular/css/filters.css', 'tabular/css/accordion.css'], refresh=True, menu_part='/'+page, user=user
