﻿requestAnimFrame = (function () {
    return window.requestAnimationFrame ||
           window.webkitRequestAnimationFrame ||
           window.mozRequestAnimationFrame ||
           window.oRequestAnimationFrame ||
           window.msRequestAnimationFrame ||
           function ( callback, element ) {
               window.setTimeout( callback, 1000 / 60 );
           };
})();

var elapsedTime    = 0;
var _display_state = 'none';
var _initial_focus = null;

// Save the global grapher
var g;
var engine;
//var main_focus = null;
var __enable_redraw = false;

function el ( s ) {
    return document.getElementById( s );
}


function onLoad () {
}

function BlockMove ( event ) {
    event.preventDefault();
}


// On simple click, we try to look if we click on an object
// and if so we "selecte" it
function on_click ( event ) {
    var obj = look_for_selection( event );
    if ( obj != null ) {
        var selected_cube = obj.parent_group.selected_cube;
        // Ok first unselect all elements before select the new one
        // but not the selected one of course
        
        for ( var j = 0; j < hit_boxes.length; j++ ) {
            var b = hit_boxes[ j ].parent_group.selected_cube;
            if ( b !== selected_cube ) {
                b.visible = false;
            }
        }
        selected_cube.visible = true;
    }
}

function focus_on ( dest, save_cam_potition ) {
    //console.log('FOCUS');
    //console.log(dest);
    // Ok now the same but for the camera orientation
    // WARNING : we give the control object the ocntrol over the camera
    // so we must give him the camera new orientation
    var tgt         = controls.target;
    var target_from = { x: tgt.x, y: tgt.y, z: tgt.z };
    
    var tween_ori = new TWEEN.Tween( target_from ).to( dest, 500 ).easing( TWEEN.Easing.Cubic.EaseOut );
    // Here we can't give the controls.target object, so we update for each step
    tween_ori.onUpdate( function () {
        controls.target.set( this.x, this.y, this.z );
    } );
    if ( typeof save_cam_potition !== 'undefined' && save_cam_potition ) {
        tween_ori.onComplete( function () {
            camera_init_rotation = camera.rotation.clone();
        } );
    }
    tween_ori.start();
}

function update_bottom_panel ( obj ) {
    return;
    //console.log('WIL UPDATE BOTTOM PANEL WITH');
    //console.log(obj.parent_group._element_id);
    var hname = obj.parent_group._element_id;
    $( '#bottom-panel' ).load( '/360-bottom-panel/' + hname );
}

function zoom_on ( obj ) {
    var camera_dest = obj.parent_group;
    
    // We search the PATH to get closer
    var diffx  = camera.position.x - camera_dest.position.x;
    var diffy  = camera.position.y - camera_dest.position.y;
    var diffz  = camera.position.z - camera_dest.position.z;
    var v_diff = new THREE.Vector3( diffx, diffy, diffz );
    // We want just teh direction
    v_diff.normalize();
    // And we go at a 300px close
    var distance = 400;
    // Our final camera destination point
    var to       = {
        x: camera_dest.position.x + distance * v_diff.x,
        y: camera_dest.position.y + distance * v_diff.y,
        z: camera_dest.position.z + distance * v_diff.z
    };
    // Go! (1s mouve)
    //var tween    = new TWEEN.Tween( camera.position ).to( to, 1000 ).easing( TWEEN.Easing.Cubic.EaseOut ).start();
    focus_on( camera_dest.position );
}

// On double click on an element, we focus on the element
function on_double_click ( event ) {
    var obj = look_for_selection( event );
    if ( obj != null ) {
        zoom_on( obj );
        update_bottom_panel( obj );
    }
}

function look_for_selection ( event ) {
    var cont        = $( '#container' );
    var cont_width  = cont.width();
    var cont_height = cont.height();
    
    var x = event.offsetX;
    var y = event.offsetY;
    // On some browser like Firefox, ther is no 'offset' from our parent
    // .... so we must compute it....
    if ( typeof x === 'undefined' || typeof y === 'undefined' ) {
        // Get the offset of the container from the whole document
        // And reduce our global click position
        var off = cont.offset();
        x       = event.pageX - off.left;
        y       = event.pageY - off.top;
    }
    
    var vector    = new THREE.Vector3( (x / cont_width) * 2 - 1, -(y / cont_height) * 2 + 1, 1 );
    var projector = new THREE.Projector();
    projector.unprojectVector( vector, camera );
    
    var ray = new THREE.Raycaster( camera.position, vector.sub( camera.position ).normalize() );
    
    // warning : do not recursive this, or your will intersec the show cube selected
    var intersects = ray.intersectObjects( hit_boxes );
    
    if ( intersects.length > 0 ) {
        return intersects[ 0 ].object;
    }
    return null;
}

// Mouse down
function onMD ( e ) {
    g.SetDragged( mouseX( e ) - hw, mouseY( e ) - hh, 30 );
}

function onMM ( e ) {
    g.MoveDragged( mouseX( e ) - hw, mouseY( e ) - hh );
}

function onMU ( e ) {
    g.StopDragging();
}

function mouseX ( e ) {
    var cx;
    if ( e.type == "touchstart" || e.type == "touchmove" ) {
        cx = e.touches.item( 0 ).clientX;
    }
    else {
        cx = e.clientX;
    }
    return (cx + document.body.scrollLeft + document.documentElement.scrollLeft);
}

function mouseY ( e ) {
    var cy;
    if ( e.type == "touchstart" || e.type == "touchmove" ) {
        cy = e.touches.item( 0 ).clientY;
    }
    else {
        cy = e.clientY;
    }
    return (cy + document.body.scrollTop + document.documentElement.scrollTop);
}

function rebuildGraph () {
    g.MakeGraph();
    // Now create the spheres things
    for ( var i = 0, size = g.graph.n; i < size; i++ ) {
        var node = g.graph.find_node( i );
        engine.add_sphere( i, node.icon, node.name, node.state, node.business_impact, node.summary, node.authorized );
    }
    for ( var i = 0, size = g.graph.edgesl.length; i < size; i++ ) {
        engine.add_line( i );
    }
    redraw();
}

var _timeout = false;
var stable;

function onEF () {
    window.requestAnimFrame( onEF );
    stable = g.Iterate();
    if ( stable && !g.is3D ) {
        return;
    }
    
    
    if ( __enable_redraw && !_timeout ) {
        _timeout = setTimeout( function () {
            _timeout = false;
            redraw();
        }, 50 );
    }
}

function sorter ( a, b ) {
    return a.z - b.z;
}


function get_3d_pos ( sn, cs, v ) {
    var r = {};
    r.x   = cs * v.x - sn * v.z;
    r.z   = sn * v.x + cs * v.z;
    r.y   = v.y;
    return r;
}


function redraw () {
    var u,
    v,
    nx,
    ny,
    nz;
    
    c3d.ang += c3d.d;
    var sn = Math.sin( c3d.ang );
    var cs = Math.cos( c3d.ang );
    var _pos;
    var sphere;
    for ( var i = 0, _size = g.graph.n; i < _size; i++ ) {
        v = g.vertices[ i ];
        if ( g.is3D ) {
            _pos = get_3d_pos( sn, cs, v );
            nx   = _pos.x;
            nz   = _pos.z;
            ny   = _pos.y;
        }
        else {
            nx = v.x;
            ny = v.y;
            nz = v.z;
        }
        v.px = c3d.camz * nx / (c3d.camz - nz);
        v.py = c3d.camz * ny / (c3d.camz - nz);
        v.pz = nz;
        
        // Now really update our objects positions
        sphere            = spheres[ i ];
        sphere.position.x = nx;
        sphere.position.y = ny;
        sphere.position.z = nz;
        sphere.rotation   = camera.rotation;
        
        // Also move the hit box
        sphere.hit_box.position = sphere.position;
        sphere.hit_box.rotation = camera.rotation;
        
        // If the object is near the camera, show the side panel
        sphere.side_panel.visible = sphere.position.distanceTo( camera.position ) < 500;
    }
    var from;
    var to;
    var is_visible = false;
    var s1 ;
    var s2 ;
    for ( var i = 0, size = g.graph.edgesl.length; i < size; i++ ) {
        u = g.vertices[ g.graph.edgesl[ i ] ];
        v = g.vertices[ g.graph.edgesr[ i ] ];
        
        from = get_3d_pos( sn, cs, u );
        to   = get_3d_pos( sn, cs, v );
        
        s1          = spheres[ g.graph.edgesl[ i ] ];
        if ( typeof s1 !== 'undefined' ) {
            is_visible = s1.selected_cube.visible;
        }
        s2 = spheres[ g.graph.edgesr[ i ] ];
        if ( typeof s2 !== 'undefined' ) {
            is_visible |= s2.selected_cube.visible;
        }
        engine.update_line( i, from, to, is_visible );
    }
    
    // On the first draw, compute the initial camera position
    if ( !camera_init_position ) {
        var r = Math.random();
        if ( r > 0.9 ) {
            // Minimum distance is 100
            var max_distance = 100;
            var _size_graph  = g.graph.n;
            for ( var i = 0; i < _size_graph; i++ ) {
                var a = spheres[ i ];
                for ( var j = 0; j < _size_graph; j++ ) {
                    if ( i !== j ) {
                        var b          = spheres[ j ];
                        var local_dist = a.position.distanceTo( b.position );
                        if ( local_dist > max_distance ) {
                            max_distance = local_dist;
                        }
                    }
                }
            }
            
            camera.position.z = max_distance * 1.5;
            // Maybe the graph is still not stable, if so, don't fix the value
            if ( g.stable ) {
                camera_init_position = new THREE.Vector3( 0, 0, camera.position.z );
                _display_state       = 'pending-rotation';
                // And hide the #waiting div
                $( '#waiting' ).hide();
                // Now focus on the root elements of the view
                var elt = null;
                for ( var i = 0; i < data_graph.length; i++ ) {
                    var idx = data_graph[ i ].id;
                    if ( spheres[ idx ]._element_id === main_focus ) {
                        elt = spheres[ idx ];
                    }
                }
                _initial_focus = elt;
                if ( elt != null ) {
                    focus_on( elt.hit_box.position, true );  // focus but not go close and save the initial camera rotation
                }
            }
        }
    }
    
    var now = Math.round( (new Date()).getTime() / 1000 );
    if ( controls.getState() === -1 && (controls.last_move === 0 || controls.last_move < now - 120) ) {
        // Maybe we are just going from user-interaction to a waiting state, if so get back to our central
        // position
        if ( _display_state === 'user-interaction' ) {
            if ( _initial_focus ) {
                focus_on( _initial_focus.hit_box.position );
            }
            camera.position.copy( camera_init_position );
        }
        _display_state = 'rotation';
        var constant   = 0.01;
        elapsedTime += 1;
        camera.position.x += 0.5 * Math.cos( constant * elapsedTime );
        camera.position.y += 0.5 * Math.sin( constant * elapsedTime );
        camera.position.z += 0.5 * Math.sin( constant * elapsedTime );
    }
    else {
        // Reset our timer to restart from scartch if need
        elapsedTime    = 0;
        _display_state = 'user-interaction';
    }
    
    // Update the camera place
    controls.update();
    
    // Also update all TWEEN things
    TWEEN.update();
    
    $( '#stable' ).html( 'Is stable?' + g.stable );
    
    if ( g.stable ) {
        renderer.render( scene, camera );
    }
    __enable_redraw = true;
}
    


