function Engine3D ( scene ) {
    this.init  = false;
    this.scene = null;
}

function get_color_from_state ( state ) {
    state = state.toLowerCase();
    if ( state == 'up' || state == 'ok' ) {
        return 'rgba(142,227,120,.7)';
    } // #8ee378
    if ( state == 'warning' ) {
        return 'rgba(248,148,6,.7)';
    } //#f89406
    if ( state == 'down' || state == 'critical' ) {
        return 'rgba(185,74,72,.7)';
    } // b94a48
    // Unknown or pending? purple
    return '#a79fcb';
}

function draw_ressources_on_canvas ( ctx, i, pct ) {
    var x = 50;
    var y = 50;
    
    // About main radius and donut size
    var radius = 48;
    //var i = 1;
    // The start and end of the donu
    angles       = { 1: Math.PI / 3, 2: Math.PI, 3: -Math.PI / 3 };
    var refAngle = angles[ i ];//i * Math.PI/3;
    // We fill 80% of the Math.PI/3 arc length
    var startAngle = refAngle + 0.90 * (5 / 6) * Math.PI;
    var endAngle   = refAngle + 1.10 * (1 / 6) * Math.PI;
    var clockwise  = true;
    // The space between the 2 main arcs
    var space_l    = 8;
    // The size of the lines
    var line_size  = 1.5;
    
    // Value gradient and some colors
    var grd = ctx.createRadialGradient( x, y, radius, x, y, radius - space_l );
    
    // The color depends on the state, so first get it
    grd.addColorStop( 0, '#c1bad9' );
    grd.addColorStop( 1, '#a79fcb' );
    
    color_value      = grd;
    color_external   = 'rgba(0,0,0,.2)';
    color_background = '#eeeeee';
    
    // Animation time in ms, here 1s
    animation_time  = 1000;
    // And animate each 50ms
    interval_update = 50;
    
    // Now search the ending round, the more funny part indeed
    final_pct = pct;
    
    nb_steps = animation_time / interval_update;
    pct_step = (final_pct - pct) / nb_steps;
    
    // fist the outter arc
    draw_arc( ctx, x, y, radius, startAngle, endAngle, clockwise, color_external, line_size );
    
    // Then the inner one
    draw_arc( ctx, x, y, radius - space_l, startAngle, endAngle, clockwise, color_external, line_size );
    
    // Fill the background of the MAIN part
    draw_arc( ctx, x, y, radius - (space_l / 2), startAngle, endAngle, clockwise, color_background, space_l );
    
    // i == 1 is the botom left curve
    if ( i == 1 ) {
        // Now The the left ending arc
        draw_arc( ctx, 48, 94, space_l / 2, (3 / 2) * Math.PI, (1 / 2) * Math.PI, false, color_external, line_size );
        // And fill the background
        fill_arc( ctx, 48, 94, space_l / 2, (3 / 2) * Math.PI, (1 / 2) * Math.PI, false, color_background );
        
        // And the Right one
        draw_arc( ctx, 7, 41, space_l / 2, Math.PI, 0, false, color_external, line_size );
        // Fil lthe background color into it
        fill_arc( ctx, 7, 41, space_l / 2, Math.PI, 0, false, color_background );
        
        // Now fill the starting value
        fill_arc( ctx, 48, 94, space_l / 2, 0, 2 * Math.PI, false, color_value );
    }
    
    // i == 2 is the top curve
    if ( i == 2 ) {
        // Now The the left ending arc
        draw_arc( ctx, 13, 27, space_l / 2, 0.1 * (Math.PI / 2), (3 / 2) * Math.PI, false, color_external, line_size );
        // And fill the background
        fill_arc( ctx, 13, 27, space_l / 2, 0.1 * (Math.PI / 2), (3 / 2) * Math.PI, false, color_background );
        
        // And the Right one
        draw_arc( ctx, 80, 18, space_l / 2, (3 / 4) * Math.PI, -(Math.PI / 4), true, color_external, line_size );
        // Fil lthe background color into it
        fill_arc( ctx, 80, 18, space_l / 2, (3 / 4) * Math.PI, -(Math.PI / 4), true, color_background );
        
        // Now fill the starting value
        fill_arc( ctx, 13, 27, space_l / 2, 0, 2 * Math.PI, false, color_value );
    }
    
    // i == 3 is the right curve
    if ( i == 3 ) {
        // Now The the left ending arc
        draw_arc( ctx, 90, 30, space_l / 2, (3 / 4) * Math.PI, -(1 / 4) * Math.PI, false, color_external, line_size );
        // And fill the background
        fill_arc( ctx, 90, 30, space_l / 2, (3 / 4) * Math.PI, -(1 / 4) * Math.PI, false, color_background );
        
        // Now The the left ending arc
        draw_arc( ctx, 62, 92, space_l / 2, (3 / 2) * Math.PI, 0.3 * Math.PI, true, color_external, line_size );
        // And fill the background
        fill_arc( ctx, 62, 92, space_l / 2, (3 / 2) * Math.PI, 0.3 * Math.PI, true, color_background );
        
        // Now fill the starting value
        fill_arc( ctx, 90, 30, space_l / 2, 0, 2 * Math.PI, false, color_value );
    }
    
    var o = Math.max( 0.01, pct );
    o     = Math.min( 0.99, o );
    o     = 1 - o;
    
    // Now go from polar to cartesian
    var theta = startAngle + (endAngle - startAngle) * o;
    var end_x = x + (radius - (space_l / 2)) * Math.cos( theta );
    var end_y = y + (radius - (space_l / 2)) * Math.sin( theta );
    
    fill_arc( ctx, end_x, end_y, space_l / 2, 0, 2 * Math.PI, false, grd );
    
    draw_arc( ctx, x, y, radius - (space_l / 2), theta, endAngle, clockwise, grd, space_l );
    
}

function draw_outter_circle ( ctx, state ) {
    var x = 50;
    var y = 50;
    
    // About main radius and donut size
    var radius    = 42;
    var clockwise = true;
    // The space between the 2 main arcs
    var space_l   = 4;
    // The size of the lines
    var line_size = 1.5;
    
    // Value gradient and some colors
    var grd   = ctx.createRadialGradient( x, y, radius, x, y, radius - space_l );
    var color = get_color_from_state( state );
    
    // The color depends on the state, so first get it
    grd.addColorStop( 1, '#a79fcb' );
    
    color_value = grd;
    
    draw_arc( ctx, x, y, radius - space_l, 0, 2 * Math.PI, clockwise, color, space_l );
    
}

function get_resource_panel ( plane, state ) {
    var canvas    = document.createElement( "canvas" );
    canvas.width  = 100;
    canvas.height = 100;
    var context   = canvas.getContext( '2d' );
    
    draw_outter_circle( context, state );
    /*draw_ressources_on_canvas(context, 1, Math.random());

     draw_ressources_on_canvas(context, 2, Math.random());

     draw_ressources_on_canvas(context, 3, Math.random());
     */
    
    // A texture with our text canvas
    var res_texture         = new THREE.Texture( canvas );
    // Need to be refresh each step
    res_texture.needsUpdate = true;
    
    // We create a real material from it and a mesh objects
    var res_material = new THREE.MeshBasicMaterial( {
        map: res_texture, overdraw: true, side: THREE.DoubleSide, transparent: true
    } );
    
    // PlaneGeometry
    var geo                    = new THREE.CircleGeometry( 15, 30 );
    var resources_plane        = new THREE.Mesh( geo, res_material );
    resources_plane.position.z = plane.position.z - 1;
    return resources_plane;
}

Engine3D.prototype.add_scene = function ( scene ) {
    this.scene = scene;
};

Engine3D.prototype.add_hitbox = function () {
    
    /////////////////////////////   HIT BOX  ////////
    // Also add an hit box for this object, that will have real coordonate
    // from the group
    var hit_box_canvas    = document.createElement( "canvas" );
    hit_box_canvas.width  = 20;
    hit_box_canvas.height = 20;
    // We do not want to see it :)
    
    var texture         = new THREE.Texture( hit_box_canvas );
    // Need to be refresh each step
    texture.needsUpdate = true;
    
    // We create a real material from it and a mesh objects
    var material = new THREE.MeshBasicMaterial( {
        map: texture, transparent: true, opacity: 0
    } );
    
    // If we put another THREE.MeshFaceMaterial()  it crash... ??
    var hit_box          = new THREE.Mesh( new THREE.CubeGeometry( 20, 20, 20, 1, 1, 1, material ) );
    // Cross references
    hit_box.visible      = false;
    hit_box.parent_group = this.group;
    this.group.hit_box   = hit_box;
    hit_boxes.push( hit_box );
    hit_box.name = 'HIT BOX';
    scene.add( hit_box );
};

Engine3D.prototype.add_side_panel = function ( name ) {
    //////////////////////////////////  Element panel with the name
    // Create a canvas where we show some element data
    var canvas        = document.createElement( "canvas" );
    canvas.width      = 120;
    canvas.height     = 50;
    var context       = canvas.getContext( '2d' );
    context.fillStyle = '#3a3f44';
    context.fillRect( 0, 0, canvas.width, canvas.height );
    context.beginPath();
    context.font         = '12pt Arial';
    context.fillStyle    = '#c8c8c8';
    context.textAlign    = "center";
    context.textBaseline = "left";
    // Name parts, to split, into parts
    var parts            = name.match( /[\s\S]{1,15}/g ) || [];
    
    // First part into top
    if ( parts.length == 1 ) {
        // only a short name, put in the middle
        context.fillText( name, canvas.width / 2, 0.5 * canvas.height );
    }
    else if ( parts.length == 2 ) { // ok more than one part, so show
        // part1
        // part2
        context.font = '8pt Arial';
        context.fillText( parts[ 0 ], 0.45 * canvas.width, 1 / 4 * canvas.height );
        context.fillText( parts[ 1 ], 0.45 * canvas.width, 3 / 4 * canvas.height );
    }
    else { // ok 3 parts and more
        // part1
        // part2
        // ... <- to show we did drop the name
        context.font = '8pt Arial';
        context.fillText( parts[ 0 ], 0.45 * canvas.width, 1 / 4 * canvas.height );
        context.fillText( parts[ 1 ], 0.45 * canvas.width, 2 / 4 * canvas.height );
        context.fillText( '...', 0.1 * canvas.width, 3 / 4 * canvas.height );
    }
    
    
    // A texture with our text canvas
    var texture         = new THREE.Texture( canvas );
    // Need to be refresh each step
    texture.needsUpdate = true;
    
    var plane_size   = 50; // by default, large panel
    var plane_height = 15;
    if ( name.length < 10 ) {
        plane_size   = 20;
        plane_height = 8;
    }
    // We create a real material from it and a mesh objects
    var material   = new THREE.MeshBasicMaterial( { map: texture, transparent: true, opacity: 0.8 } );
    var side_plane = new THREE.Mesh( new THREE.PlaneGeometry( plane_size, plane_height ), material );
    
    side_plane.position.x = this.plane.position.x;
    side_plane.position.y = this.plane.position.y - 20;
    side_plane.position.z = this.plane.position.z + 10;
    
    this.group.add( side_plane );
    
    // Save our side panel object
    this.group.side_panel = side_plane;
    
};

Engine3D.prototype.add_back_pane = function ( state ) {
    ////////////////////////////////   Back panel with the status color
    // Now a back panel
    var back_pane_url = static_pth + '/threed/img/red_back.png';
    
    // The icon texture
    var back_pane_img = new THREE.MeshLambertMaterial( {
        map: THREE.ImageUtils.loadTexture( back_pane_url ), transparent: true, opacity: 1
    } );
    
    var back_panel = new THREE.Mesh( new THREE.CircleGeometry( 20, 30 ), back_pane_img );
    
    back_panel.position.x = this.plane.position.x;
    back_panel.position.y = this.plane.position.y;
    back_panel.position.z = this.plane.position.z - 2;
    
    if ( state == 'down' || state == 'critical' || state == 'warning' ) {
        this.group.back_panel = back_panel;
        // Animate the opacity of this panel
        var go_tween          = new TWEEN.Tween( back_pane_img ).to( { opacity: 0.3 }, 2000 );
        var back_tween        = new TWEEN.Tween( back_pane_img ).to( { opacity: 1 }, 2000 );
        go_tween.chain( back_tween );
        back_tween.chain( go_tween );
        go_tween.start();
        
        this.group.add( back_panel );
    }
    else {
        this.group.back_panel = null;
    }
};

Engine3D.prototype.add_selected_cube = function () {
    //////////////////////////// Selected box 
    // Add a selected box around the items, but disabled by default
    var selected_cube = new THREE.BoxHelper();
    selected_cube.material.color.setRGB( 0, 255, 255 );  //HIVE: color.setHex(0xFF530D);
    selected_cube.scale.set( 15, 15, 15 );
    
    // By default it will be disabled
    selected_cube.visible    = false;
    selected_cube.name       = 'Shown selected cube of ' + name;
    this.group.selected_cube = selected_cube;
    this.group.add( selected_cube );
};

Engine3D.prototype.add_sphere = function ( i, icon_url, name, state, criticity, summary, authorized ) {
    // Sphere with a texture
    var url = icon_url;
    
    // The icon texture
    var img = new THREE.MeshLambertMaterial( {
        map    : THREE.ImageUtils.loadTexture( url ), /*side: THREE.DoubleSide,*/ /*This won't work under IE11 :(*/
        ambient: 0xFFFFFF, transparent: true
    } );
    
    var plane = new THREE.Mesh( new THREE.CircleGeometry( 10, 30 ), img );
    
    this.plane = plane;
    
    // add the sphere to the scene
    var group        = new THREE.Object3D();
    this.group       = group;
    group.main_panel = plane;
    group.add( plane );
    scene.add( group );
    group._element_id = name;
    
    // Add this group to our spheres list
    spheres[ i ] = group;
    
    //////////////////////////////////  Ressources panel with the CPU / Memory / Disks
    // Create a canvas where we show some element data
    //resources_plane.rotation.x = Math.PI;
    var resources_plane = get_resource_panel( plane, state );
    group.add( resources_plane );
    // Save our side panel object
    group.resources_plane = resources_plane;
    
    // This hitbox is here to catch the mouse click
    this.add_hitbox();
    
    // The side panel is here to display the name
    this.add_side_panel( name );
    
    // This back pane is to show the resources
    this.add_back_pane( state );
    
    // This is a cube showing the selected element
    this.add_selected_cube();
    
    // Show the status icon on bottom right
    this.add_status_circle( state );
    
    if ( !authorized ) {
        this.add_unauthorized_circle();
    }
    
    this.add_summary_circle( summary );
    
    if ( criticity > 2 ) {
        this.group.scale.x = 2;
        this.group.scale.y = 2;
        this.group.scale.z = 2;
    }
    
};

Engine3D.prototype.update_line = function ( i, from, to, is_visible ) {
    // First delete the previous line
    var prev_line = d3_lines[ i ];
    scene.remove( prev_line );
    
    // Also remove the lines from memory!!
    prev_line.geometry.dispose();
    prev_line.material.dispose();
    
    var lineGeo = new THREE.Geometry();
    lineGeo.vertices.push( this.createVector3( from.x, from.y, from.z ), this.createVector3( to.x, to.y, to.z ) );
    
    var style_line_basic_material = {};
    if ( is_visible ) {
        style_line_basic_material.color     = '#FF530D';//'#54d87c';//HIVE: #FF530D
        style_line_basic_material.opacity   = 1;
        style_line_basic_material.linewidth = 4;
    }
    else {
        style_line_basic_material.color     = 'black';//'#b8dc00';//HIVE: black
        style_line_basic_material.linewidth = 2;
        style_line_basic_material.opacity   = 0.3;
    }
    
    var lineMat         = new THREE.LineBasicMaterial( style_line_basic_material );
    lineMat.transparent = true;
    var line            = new THREE.Line( lineGeo, lineMat );
    line.type           = THREE.Lines;
    scene.add( line );
    d3_lines[ i ] = line;
};

Engine3D.prototype.add_line = function ( i ) {
    var lineGeo = new THREE.Geometry();
    lineGeo.vertices.push( this.createVector3( 0, 0, 0 ), this.createVector3( 1, 1, 1 ) );
    var lineMat = new THREE.LineBasicMaterial( {
        color: 0x0000ff, linewidth: 4
    } );
    var line    = new THREE.Line( lineGeo, lineMat );
    line.type   = THREE.Lines;
    scene.add( line );
    
    d3_lines[ i ] = line;
};

// Add a bottom right status icon
Engine3D.prototype.add_status_circle = function ( status ) {
    var icon_src      = static_pth + '/img/icons/state_' + status + '.png';
    // The icon texture
    var back_pane_img = new THREE.MeshLambertMaterial( {
        map: THREE.ImageUtils.loadTexture( icon_src ), transparent: true, opacity: 1
    } );
    
    var back_panel = new THREE.Mesh( new THREE.CircleGeometry( 5, 30 ), back_pane_img );
    
    back_panel.position.x = this.plane.position.x + 8;
    back_panel.position.y = this.plane.position.y - 10;
    back_panel.position.z = this.plane.position.z + 1; // In front of the main
    this.group.add( back_panel );
};

// Add a bottom left authorized icon
Engine3D.prototype.add_unauthorized_circle = function () {
    
    var icon_src = static_pth + '/img/icons/unauthorized.png';
    
    // The icon texture
    var back_pane_img = new THREE.MeshLambertMaterial( {
        map: THREE.ImageUtils.loadTexture( icon_src ), transparent: true, opacity: 1
    } );
    
    var back_panel = new THREE.Mesh( new THREE.CircleGeometry( 5, 30 ), back_pane_img );
    
    back_panel.position.x = this.plane.position.x - 8;
    back_panel.position.y = this.plane.position.y - 10;
    back_panel.position.z = this.plane.position.z + 1; // In front of the main
    
    this.group.add( back_panel );
};

// Add a top left icon for summary if provided
Engine3D.prototype.add_summary_circle = function ( summary ) {
    var _summary = '';
    switch ( summary ) {
        case 'DOWNTIME':
            _summary = 'downtime';
            break;
        case 'PARTIAL-DOWNTIME':
            _summary = 'partial-downtime';
            break;
        case 'INHERITED-DOWNTIME':
            _summary = 'inherited-downtime';
            break;
        case 'ACKNOWLEDGED':
            _summary = 'acknowledged';
            break;
        case 'PARTIAL-ACKNOWLEDGED':
            _summary = 'partial-acknowledged';
            break;
        case 'INHERITED-ACKNOWLEDGED':
            _summary = 'inherited-acknowledged';
            break;
        case 'FLAPPING':
            _summary = 'flapping';
            break;
        case 'PARTIAL-FLAPPING':
            _summary = 'partial-flapping';
            break;
        default:
            return;
    }
    
    if ( _summary != null ) {
        var icon_src = static_pth + '/img/icons/state_' + _summary + '.png';
    }
    
    // The icon texture
    var back_pane_img = new THREE.MeshLambertMaterial( {
        map: THREE.ImageUtils.loadTexture( icon_src ), transparent: true, opacity: 1
    } );
    
    var back_panel = new THREE.Mesh( new THREE.CircleGeometry( 5, 30 ), back_pane_img );
    
    back_panel.position.x = this.plane.position.x - 8;
    back_panel.position.y = this.plane.position.y + 10;
    back_panel.position.z = this.plane.position.z + 1; // In front of the main
    
    this.group.add( back_panel );
};

Engine3D.prototype.createVector3 = function ( x, y, z ) {
    return new THREE.Vector3( x, y, z );
};