<?php
/*******************************************************************************
 *
 * CoreAuthModSQLite.php - Authentication module based on a SQLite database
 *
 * Copyright (c) 2004-2016 NagVis Project (Contact: info@nagvis.org)
 *
 * License:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

class CoreAuthModShinken extends CoreAuthModule {
    private $user;
    private $user_id;
    private $auth_username;
    private $auth_passwd;

    public function __construct() {
        parent::$aFeatures = Array(
            // General functions for authentication
            'passCredentials' => false,
            'getCredentials' => false,
            'isAuthenticated' => true,
            'getUser' => true,
            'getUserId' => true,

            // Changing passwords
            'passNewPassword' => false,
            'changePassword' => false,
            'passNewPassword' => false,

            // Managing users
            'createUser' => false,
        );
    }

    public function getAllUsers() {
        die('getAllUsers');
        return array();
    }

    public function checkUserExists($name) {
        return true;
    }

    private function updatePassword() {
        return true;
    }

    private function addUser($user, $hash) {
        return true;
    }

    public function passCredentials($aData) {
        //print_r($aData);
        if (isset($aData['user'])) {
            $this->auth_username = $aData['user'];
        }
        if (isset($aData['password'])) {
            $this->auth_passwd = $aData['password'];
        }
        if (isset($aData['userId'])) {
            $this->user_id = $aData['userId'];
        }
        // die('pass ' . print_r($aData, 1));
        // eventually has user, password and passwordHash
    }

    public function passNewPassword($aData) {
        // die('new pass');
        // eventually has user, password and passwordHash
    }

    public function getCredentials() {
        return Array('user' => $this->getUser(),
                     'passwordHash' => null,
                     'userId' => $this->getUserId());
    }

    public function createUser($user, $password) {
        return false;
    }

    public function changePassword() {
        return false;
    }

    private function resetAuthInfo() {
        $this->auth_username = null;
        $this->auth_passwd = null;
    }

    public function isAuthenticated($bTrustUsername = AUTH_NOT_TRUST_USERNAME) {
        if ($bTrustUsername != AUTH_NOT_TRUST_USERNAME) {
            return true;
        }

        global $_BACKEND;
        if ($this->user != null or $this->user_id != null) {
            return true;
        }

        if ($this->auth_username == null or $this->auth_passwd == null) {
            return false;
        }

        // Get connection parameters from configuration file
        $protocol = cfg("global", "shinken_auth_protocol");
        $port     = cfg("global", "shinken_auth_port");
        $address  = cfg("global", "shinken_auth_address");
        $shinken_admin_only     = cfg("global", "shinken_auth_restrict_to_shinken_admin");
        if ($shinken_admin_only == '1') {
            $shinken_admin_only = true;
        } else {
            $shinken_admin_only = false;
        }
        if ($address == '') {
            // If no address defined, get address from default backend socket
            $default_backend_name = cfg('defaults', 'backend');
            $socket = cfg('backend_' .$default_backend_name[0], 'socket');
            preg_match("/^tcp:(.*):\w*/", $socket, $matches);
            $address = $matches[1];
        }

        $url = $protocol. '://' .$address. ':' .$port. '/auth_nagvis';

        $data = array('login' => base64_encode($this->auth_username), 'password' => base64_encode($this->auth_passwd), 'restrict_to_shinken_admin' => base64_encode($shinken_admin_only));

        // use key 'http' even if you send the request to https://...
        $options = array(
            'http' => array(
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                'method'  => 'POST',
                'content' => http_build_query($data)
            )
        );
        $context  = stream_context_create($options);
        $result = @file_get_contents($url, false, $context);
        # Request failed, either address cannot be joined, or credentials are invalid
        if ($result === false) {
            $this->resetAuthInfo();
            return false;
        }

        # Had result from request. Checking if retrieved result is a correctly formatted token
        if (preg_match("/!.*?.*/", $result)) {
            $this->user = $this->auth_username;
            $this->user_id = $this->auth_username;
            return true;
        }

        $this->resetAuthInfo();
        return false;
    }

    public function getUser() {
        return $this->user_id;
    }

    public function getUserId() {
        return $this->getUser();
    }
}

