#!/usr/bin/python

# This script is designed to take a cfg file in entry, and output a json file with an object & key/values matched from the source file
# * only keys that are selected will be migrated
# * migrated keys will be set in a json object in the distant file
# * migrated values will be commented in the original file
# * a comment can be set about migrated lines

import json
import shutil
import optparse
import os
import sys
import re

if __name__ == '__main__':
    parser = optparse.OptionParser("%prog --sources-dir SOURCES_DIR --modules-dir MODULES_DIR", version="%prog: ", description='This tool is used for merge a source with its associated module\nWARNING: Only supports a single module and source per file')
    parser.add_option('--sources-dir', dest='sources_dir', help="Sources directory (merge destination)")
    parser.add_option('--modules-dir', dest='modules_dir', help="Modules directory (merge source)")

    opts, args = parser.parse_args()

    # Look if the user ask for local or global, and if not, guess

    if not opts.sources_dir or not opts.modules_dir:
        parser.print_help()
        sys.exit(1)

    sdir = os.path.abspath(opts.sources_dir)
    mdir = os.path.abspath(opts.modules_dir)

    if not os.path.exists(sdir):
        print "Error: Cannot find source directory: %s" % sdir
        sys.exit(2)
    if not os.path.exists(mdir):
        print "Error: Cannot find modules directory: %s" % mdir
        sys.exit(2)

    sources = {}
    modules = {}
    for root, _, files in os.walk(mdir):
        for name in files:
            if not name.endswith(".cfg"):
                continue
            buf = []
            path = os.path.join(root, name)
            with open(path) as f:
                key = ''
                for line in f.readlines():
                    line_striped = line.strip()
                    if re.match("^}", line_striped) or re.match("^define", line_striped) or re.match("^_SE_UUID", line_striped):
                        continue
                    if line_striped in ("# End of Shinken Enterprise part",
                                "# Shinken Enterprise. Lines added by import core. Do not remove it, it's used by Shinken Enterprise to update your objects if you re-import them."):
                        continue
                    if re.search("^module_name", line_striped):
                        key = line_striped[11:].strip()
                    else:
                        buf.append(line)
                if key:
                    modules[key] = {"path": path, "buf": buf}

    for root, _, files in os.walk(sdir):
        for name in files:
            if not name.endswith(".cfg"):
                continue
            buf = []
            with open(os.path.join(root, name)) as f:
                key = ''
                for line in f.readlines():
                    line_striped = line.strip()
                    if re.search("^modules", line_striped):
                        key = line_striped[7:].strip()
                        if key in modules:
                            buf += modules[key]['buf']
                            try:
                                os.unlink(modules[key]['path'])
                            except OSError as e:
                                # Maybe the file was already deleted
                                pass
                        else:
                            buf.append(line)
                    else:
                        buf.append(line)
            with open(os.path.join(root, name), 'w') as f:
                f.write(''.join(buf))
