#!/usr/bin/python

import optparse
import os
import sys
import string
import re

if not os.getuid() == 0:
    print "ERROR: this script must be run as root"
    sys.exit(2)


def cut_line(line):
    tmp = re.split("[" + string.whitespace + "]+", line, 1)
    r = [elt for elt in tmp if elt != '']
    return r


if __name__ == '__main__':
    parser = optparse.OptionParser("%prog INTPUT_FILE -k KEY -v VALUE", version="%prog: ", description='This tool is used to remove a given object from a configuration file.')
    parser.add_option('-k', dest='key', help="Configuration key to check.")
    parser.add_option('-v', dest='value', help="Parameter to set in the input_file to call the new output json file.")
    
    opts, args = parser.parse_args()
    if len(args) != 1 or not opts.key or not opts.value:
        parser.error('Error: Input file, key and value are mandatory')
    
    out_lines = []
    current_item = []
    to_keep = True
    
    with open(args[0]) as f:
        for line in f.readlines():
            line_parsed = line
            # Strip comments
            if '#' in line:
                line_parsed = line_parsed[:line_parsed.index('#')]
            if '}' in line_parsed:
                if to_keep:
                    out_lines.extend(current_item)
                    out_lines.append(line)
                current_item = []
                to_keep = True
            # Check for values...
            else:
                lst = [s for s in re.split('\s+', line_parsed.strip()) if s]
                if len(lst) == 2:
                    key, value = lst
                    if key == opts.key and value == opts.value:
                        to_keep = False
                current_item.append(line)
    
    with open(args[0], 'w') as f:
        f.write(''.join(out_lines))

