#!/bin/bash

args_list=""
for arg in "$@"; do
    args_list="$args_list \"$arg\""
done

VERSION_NUMBER=$(grep "export VERSION=" lib/common.sh | cut -d'=' -f 2)
export OUTPUT_FOLDER="$HOME/shinken/$(date +%F-%Hh%Mm%S)-update-${VERSION_NUMBER}"
mkdir -p "$OUTPUT_FOLDER"

# The script command do not manage the -e on centos 7, so try it before run the real script call
script_arg=" -e "
script -e -c 'ls > /dev/null' -q 2>/dev/null
if [ $? != 0 ];then
   script_arg=""
   echo "Please Note that the update.sh return exit code is only available on centos 7."
fi

# Real launch
script $script_arg -c "dependencies/update.sh $args_list" -q "${OUTPUT_FOLDER}/shinken.enterprise.update.log"
# The exit will be valid only for centos7
exit $?
