#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from .satellitelink import SatelliteLinks
from .property import IntegerProp, StringProp, BoolProp
from .withinventorysatellitelink import WithInventorySatelliteLink


class BrokerLink(WithInventorySatelliteLink):
    """TODO: Add some comment about this class for the doc"""
    id = 0
    my_type = 'broker'
    properties = WithInventorySatelliteLink.properties.copy()
    properties.update({
        'broker_name'                                                              : StringProp(fill_brok=['full_status'], to_send=True),
        'port'                                                                     : IntegerProp(default='7772', fill_brok=['full_status']),
        'broker__manage_brok__enable_sub_processes_memory_usage_protection'        : BoolProp(default='1', fill_brok=['full_status'], to_send=True),
        'broker__manage_brok__sub_process_memory_usage_system_reserved_memory'     : IntegerProp(default='0', fill_brok=['full_status'], to_send=True),
        'broker__manage_brok__sub_processes_memory_usage_protection_max_retry_time': IntegerProp(default='5', fill_brok=['full_status'], to_send=True),
        
        'broker__manage_brok__sub_process_broks_pusher_max_execution_timeout'      : IntegerProp(default='240', fill_brok=['full_status'], to_send=True),
        'broker__manage_brok__sub_process_broks_pusher_security_ratio'             : IntegerProp(default='5', fill_brok=['full_status'], to_send=True),
        'broker__manage_brok__sub_process_broks_pusher_min_execution_timeout'      : IntegerProp(default='5', fill_brok=['full_status'], to_send=True),
        'broker__manage_brok__sub_process_broks_pusher_max_retry'                  : IntegerProp(default='3', fill_brok=['full_status'], to_send=True),
    })
    
    
    def get_name(self):
        return self.broker_name
    
    
    def register_to_my_realm(self):
        self.realm.brokers.append(self)


class BrokerLinks(SatelliteLinks):
    """TODO: Add some comment about this class for the doc"""
    name_property = "broker_name"
    inner_class = BrokerLink
