import hashlib

# Used to invalidate previous inventories when updating or such things
INVENTORY_FORMAT_VERSION = '1'


class _HASHER(object):
    def __init__(self):
        self._hasher = hashlib.sha1(INVENTORY_FORMAT_VERSION)
    
    
    # Note: protect against not ascii characters
    def update(self, s):
        if isinstance(s, unicode):
            s = s.encode('utf8')
        self._hasher.update(s)
    
    
    def hexdigest(self):
        return self._hasher.hexdigest()


# IMPORTANT: as we will update it a lot, create a new object each time
def get_hasher():
    return _HASHER()
