#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

import time

from shinken.log import logger
from ..dao.def_items import ITEM_TYPE, DEF_ITEMS

CORE_ITEMS = {
    ITEM_TYPE.CONTACTS        : [{
        'use'                      : {'has_plus': False, 'links': [{'exists': False, 'name': 'generic-contact'}]},
        'contact_name'             : 'admin',
        'email'                    : 'shinken@localhost',
        'password'                 : 'admin',
        'is_admin'                 : '1',
        'expert'                   : '1',
        'default_submit_to_staging': '1',
        '_SYNC_KEYS'               : ['admin', 'core-contacts-30067cfe5adf11e59a28080027f08538'],
        '_id'                      : '30067cfe5adf11e59a28080027f08538',
        '_SE_UUID'                 : 'core-contacts-30067cfe5adf11e59a28080027f08538',
        '_SE_UUID_HASH'            : '27987657cca7c71bb608d64be45c1f09',
        'contactgroups'            : {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.CONTACTGROUPS, '_id': 'de64007c5ae011e592c8080027f08538'}]}
    }],
    ITEM_TYPE.CONTACTGROUPS   : [{
        'contactgroup_name'  : 'admins',
        'alias'              : 'admins',
        'members'            : {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.CONTACTS, '_id': '30067cfe5adf11e59a28080027f08538'}]},
        '_SYNC_KEYS'         : ['admins', 'core-contactgroups-de64007c5ae011e592c8080027f08538'],
        '_id'                : 'de64007c5ae011e592c8080027f08538',
        '_SE_UUID'           : 'core-contactgroups-de64007c5ae011e592c8080027f08538',
        '_SE_UUID_HASH'      : 'c99d02a8470e546a3f62ff2cf245dfb1',
        'presence_protection': '1'
    }],
    ITEM_TYPE.SERVICETPLS     : [{
        '_id'                   : '0eeb62945ae111e59fac080027f08538',
        'name'                  : 'generic-service',
        '_SYNC_KEYS'            : ['generic-service-tpl', 'core-servicetpls-0eeb62945ae111e59fac080027f08538'],
        'check_command'         : {'raw_value': 'no-check', 'node': {'link': {'exists': True, 'item_type': ITEM_TYPE.COMMANDS, '_id': 'c464d9ca5ae111e5b0b2080027f08538'}, 'args': '', }},
        'active_checks_enabled' : '1',
        'passive_checks_enabled': '1',
        'notification_options'  : 'w,u,c,r,f',
        'flap_detection_enabled': '1',
        'process_perf_data'     : '1',
        'is_volatile'           : '0',
        'max_check_attempts'    : '2',
        'check_interval'        : '5',
        'retry_interval'        : '1',
        'register'              : '0',
        '_SE_UUID'              : 'core-servicetpls-0eeb62945ae111e59fac080027f08538',
        '_SE_UUID_HASH'         : '9716e5c1e7583e470fb2da909be68f2a',
        'presence_protection'   : '1'
    }],
    ITEM_TYPE.NOTIFICATIONWAYS: [{
        '_id'                          : '2ccd33005ae111e5842f080027f08538',
        '_SYNC_KEYS'                   : ['email', 'core-notificationways-2ccd33005ae111e5842f080027f08538'],
        'notificationway_name'         : 'email',
        'service_notification_period'  : {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.TIMEPERIODS, '_id': '4476cf345ae111e5b51d080027f08538'}]},
        'host_notification_period'     : {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.TIMEPERIODS, '_id': '4476cf345ae111e5b51d080027f08538'}]},
        'service_notification_options' : 'c,w,r,f,s',
        'host_notification_options'    : 'd,u,r,f,s',
        'service_notification_commands': {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.COMMANDS, '_id': '8611fd1a5ae111e5aa89080027f08538'}]},
        'host_notification_commands'   : {'has_plus': False, 'links': [{'exists': True, 'item_type': ITEM_TYPE.COMMANDS, '_id': '6a8c857e5ae111e5a28e080027f08538'}]},
        '_SE_UUID'                     : 'core-notificationways-2ccd33005ae111e5842f080027f08538',
        '_SE_UUID_HASH'                : 'ea2052312d9884f9a01507c5909c4c75',
        'presence_protection'          : '1'
    }],
    ITEM_TYPE.COMMANDS        : [
        {
            '_id'                : '6a8c857e5ae111e5a28e080027f08538',
            '_SYNC_KEYS'         : ['notify-host-by-email', 'core-commands-6a8c857e5ae111e5a28e080027f08538'],
            'command_name'       : 'notify-host-by-email',
            'command_line'       : r'''$NOTIFPLUGINDIR$/notify_by_email.py --title-tpl $NOTIFPLUGINDIR$/host_alert_title_template.tpl --content-tpl $NOTIFPLUGINDIR$/host_alert_content_template.tpl -F "$SENDER$" -r "$CONTACTEMAIL$" -n $NOTIFICATIONTYPE$ -H "$HOSTNAME$" --address "$HOSTADDRESS$" --url $MAILURL$ --huuid $HOSTUUID$ --state $HOSTSTATE$ --last-state $LASTHOSTSTATEID$ --last-change $LASTHOSTSTATECHANGE$  --last-check "$DATE$ $TIME$" --output "$HOSTOUTPUT$" --long-output "$LONGHOSTOUTPUT$" --ack-author "$ACKAUTHOR$" --ack-data "$ACKDATA$" --downtime-comment "$HOSTDOWNTIMECOMMENT$" --downtime-author "$HOSTDOWNTIMEAUTHOR$" --first-notification-delay "$HOSTFIRSTNOTIFICATIONDELAY$" --notification-number "$HOSTNOTIFICATIONNUMBER$" --realm "$HOSTREALM$"''',
            '_SE_UUID'           : 'core-commands-6a8c857e5ae111e5a28e080027f08538',
            '_SE_UUID_HASH'      : '7f75de8a92ef782413e5a66b6fa5f171',
            'shell_execution'    : '0',  # we allow the shell for this command
            'presence_protection': '1'
        },
        {
            '_id'                : '8611fd1a5ae111e5aa89080027f08538',
            '_SYNC_KEYS'         : ['notify-service-by-email', 'core-commands-8611fd1a5ae111e5aa89080027f08538'],
            'command_name'       : 'notify-service-by-email',
            'command_line'       : r'''$NOTIFPLUGINDIR$/notify_by_email.py --title-tpl $NOTIFPLUGINDIR$/service_alert_title_template.tpl --content-tpl $NOTIFPLUGINDIR$/service_alert_content_template.tpl -F "$SENDER$" -r "$CONTACTEMAIL$" -n $NOTIFICATIONTYPE$ -H "$HOSTNAME$" --address "$HOSTADDRESS$" --url $MAILURL$ --huuid $HOSTUUID$ --serviceuuid $SERVICEUUID$ --check "$SERVICEDESC$" --state $SERVICESTATE$ --last-state $LASTSERVICESTATEID$ --last-change $LASTSERVICESTATECHANGE$ --last-check "$DATE$ $TIME$" --output "$SERVICEOUTPUT$" --long-output "$LONGSERVICEOUTPUT$" --ack-author "$ACKAUTHOR$" --ack-data "$ACKDATA$" --downtime-comment "$SERVICEDOWNTIMECOMMENT$" --downtime-author "$SERVICEDOWNTIMEAUTHOR$" --first-notification-delay "$SERVICEFIRSTNOTIFICATIONDELAY$" --notification-number "$SERVICENOTIFICATIONNUMBER$" --realm "$HOSTREALM$"''',
            '_SE_UUID'           : 'core-commands-8611fd1a5ae111e5aa89080027f08538',
            '_SE_UUID_HASH'      : '1e5631e038c674d70cc24373f4967ebe',
            'shell_execution'    : '0',  # we allow the shell for this command
            'presence_protection': '1'
        },
        {
            '_id'                : '9dcb763e5ae111e59a52080027f08538',
            '_SYNC_KEYS'         : ['bp_rule', 'core-commands-9dcb763e5ae111e59a52080027f08538'],
            'command_name'       : 'bp_rule',
            'command_line'       : '''bp_rule''',
            'editable'           : '0',
            '_SE_UUID'           : 'core-commands-9dcb763e5ae111e59a52080027f08538',
            '_SE_UUID_HASH'      : '221301ffeed548d96547339571e90457',
            'presence_protection': '1'
        },
        {
            '_id'                : 'b019331c5ae111e59dd1080027f08538',
            '_SYNC_KEYS'         : ['check-host-alive', 'core-commands-b019331c5ae111e59dd1080027f08538'],
            'command_name'       : 'check-host-alive',
            'command_line'       : '''$NAGIOSPLUGINS$/check_ping -H "$HOSTADDRESS$" -w 1000,100% -c 3000,100% -p 1''',
            '_SE_UUID'           : 'core-commands-b019331c5ae111e59dd1080027f08538',
            '_SE_UUID_HASH'      : 'd2cb75430e5767767611f71c6d8439d4',
            'presence_protection': '1'
        },
        {
            '_id'                : 'c464d9ca5ae111e5b0b2080027f08538',
            '_SYNC_KEYS'         : ['no-check', 'core-commands-c464d9ca5ae111e5b0b2080027f08538'],
            'command_name'       : 'no-check',
            'command_line'       : '''/bin/echo "No check command"''',
            '_SE_UUID'           : 'core-commands-c464d9ca5ae111e5b0b2080027f08538',
            '_SE_UUID_HASH'      : '4e7f3c3c67eff3f59fe5ed5bd5dac975',
            'presence_protection': '1'
        }
    ],
    ITEM_TYPE.TIMEPERIODS     : [{
        '_id'                : '4476cf345ae111e5b51d080027f08538',
        '_SYNC_KEYS'         : ['24x7', 'core-timeperiods-4476cf345ae111e5b51d080027f08538'],
        'timeperiod_name'    : '24x7',
        'alias'              : '24_Hours_A_Day,_7_Days_A_Week',
        'sunday'             : '00:00-24:00',
        'monday'             : '00:00-24:00',
        'tuesday'            : '00:00-24:00',
        'wednesday'          : '00:00-24:00',
        'thursday'           : '00:00-24:00',
        'friday'             : '00:00-24:00',
        'saturday'           : '00:00-24:00',
        '_SE_UUID'           : 'core-timeperiods-4476cf345ae111e5b51d080027f08538',
        '_SE_UUID_HASH'      : 'fd56884050be367f619fc912a3c90793',
        'presence_protection': '1'
    }]
}


def add_core_items(_app):
    global app
    app = _app
    
    for item_type, items in CORE_ITEMS.iteritems():
        for item in items:
            app.database_cipher.cipher(item=item, item_type=item_type)
            table = DEF_ITEMS[item_type]['table']
            col = getattr(app.mongodb_db, 'configuration-stagging-%s' % table)
            __add_core_item(col, item, item_type)
            col = getattr(app.mongodb_db, 'configuration-production-%s' % table)
            __add_core_item(col, item, item_type)


def __add_core_item(col, entry, item_type):
    _id = entry['_id']
    _key = DEF_ITEMS[item_type]['key_name']
    
    _name = entry[_key]
    
    found = col.find_one({'_id': _id}) or col.find_one({_key: _name})
    
    if not found:
        logger.info('Core item of type %s named %s is missing. Creating it.' % (item_type, _name))
        
        entry['sources'] = 'shinken-core'
        entry['pack'] = 'shinken-core'
        entry["last_modification"] = {
            "action"          : "ELEMENT_ADD",
            "date"            : time.time(),
            "contact_name"    : "shinken-core",
            "show_diffs_state": {},
            "show_diffs"      : False,
            "contact"         : {"has_plus": False, "links": [{"name": "shinken-core", "exists": False}]}
        }
        col.insert(entry)
    else:
        col.remove({'_id': found['_id']}, w=1)
        found.update(
            {
                'presence_protection': entry.get('presence_protection', '0'),
                '_id'                : entry['_id'],
                '_SE_UUID'           : entry['_SE_UUID'],
                '_SYNC_KEYS'         : entry['_SYNC_KEYS']
            }
        )
        col.insert(found)
