#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from def_items import METADATA, NOT_TO_LOOK, HISTORY_ACTION
from ..business.source.sourceinfo import SourceInfo
from ..dao.helpers import get_property_def, split_and_strip_list, remove_plus


def compute_item_diff_existing_vs_from_source(item_type, existing_item, from_sources_item, datamanagerV2):
    source_info = METADATA.get_metadata(from_sources_item, METADATA.SOURCE_INFO)
    if source_info and isinstance(source_info, dict):
        source_info = SourceInfo.from_dict(source_info, item_type)
    
    from_sources_item = datamanagerV2.get_raw_item(from_sources_item, item_type=item_type)
    existing_item = datamanagerV2.get_raw_item(existing_item, item_type=item_type)
    
    changes = {}
    from_sources_properties = set(from_sources_item.keys()) - NOT_TO_LOOK
    existing_item_properties = set(existing_item.keys()) - NOT_TO_LOOK
    for item_property in from_sources_properties & existing_item_properties:  # for the keys in both
        value_from_sources = from_sources_item[item_property]
        value_from_existing = existing_item[item_property]
        source_info_property = source_info.get_property(item_property)
        element_rule = get_property_def(item_type, item_property)
        
        if source_info_property.modif_auto() == HISTORY_ACTION.AUTO_MODIFICATION:
            continue
        
        value_not_only_from_syncui = [_from_source for _from_source, _ in source_info_property.value() if _from_source is not None and _from_source != 'syncui']
        if not source_info_property.force() and (element_rule and element_rule.merging in ('join', 'ordered', 'duplicate')) and (item_property != 'use'):
            _separator = element_rule.separator
            value_from_sources_has_plus = value_from_sources.startswith('+')
            value_from_stagging_has_plus = value_from_existing.startswith('+')
            value_in_source = set(split_and_strip_list(remove_plus(value_from_sources), _separator))
            value_in_existing = set(split_and_strip_list(remove_plus(value_from_existing), _separator))
            if value_from_sources_has_plus != value_from_stagging_has_plus and value_not_only_from_syncui:
                changes[item_property] = [value_from_existing, value_from_sources, source_info_property.as_dict()]
            elif value_in_source ^ value_in_existing:  # if elements in either s or t but not both
                source_values = [_source_value for _from_source, _source_value in source_info_property.value() if (_from_source is not None and _from_source != 'syncui') or _source_value in value_in_existing]
                for source_value in source_values:
                    if source_value not in value_in_existing:
                        changes[item_property] = [value_from_existing, value_from_sources, source_info_property.as_dict()]
                        break
        
        # For field use case if is not FORCE
        elif item_property == 'use' and not source_info_property.force() and value_not_only_from_syncui:
            _separator = element_rule.separator
            value_in_source = split_and_strip_list(value_from_sources, _separator)
            value_in_existing = split_and_strip_list(value_from_existing, _separator)
            if len(value_in_source) > len(value_in_existing):
                changes[item_property] = [value_from_existing, value_from_sources, source_info_property.as_dict()]
            else:
                for i, source_value in enumerate(value_in_source):
                    # we have already test the len of the second list, so it can't crash here
                    if source_value != value_in_existing[i]:
                        changes[item_property] = [value_from_existing, value_from_sources, source_info_property.as_dict()]
                        break
        
        # classic compare direct values, not list/set
        elif source_info_property.value() and (value_not_only_from_syncui or source_info_property.force()) and value_from_sources != value_from_existing:
            changes[item_property] = [value_from_existing, value_from_sources, source_info_property.as_dict()]
    
    # then the one in the new one but not in the already in stagging
    for item_property in from_sources_properties - existing_item_properties:
        source_info_property = source_info.get_property(item_property)
        value_not_only_from_syncui = [_from_source for _from_source, _ in source_info_property.value() if _from_source is not None and _from_source != 'syncui']
        if source_info_property.value() and value_not_only_from_syncui and from_sources_item[item_property] and source_info_property.modif_auto() != HISTORY_ACTION.AUTO_MODIFICATION:
            changes[item_property] = [None, from_sources_item[item_property], source_info_property.as_dict()]
    
    return changes
