#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from baseitem import BaseItem
from ..def_items import ITEM_TYPE, DEF_ITEMS
from shinken.property import BoolProp
from mixins import UseMixin


class ContactItem(BaseItem, UseMixin):
    
    def is_admin(self):
        return self.get('is_admin', '0') == '1'
    
    
    def is_expert(self):
        return self.get('expert', '0') == '1'
    
    def get_admin_level(self):
        if self.is_admin():
            admin_level = 'shinken_admin'
        elif self.is_expert():
            admin_level = 'si_admin'
        else:
            admin_level = 'user'
        return admin_level

    def can_bypass_working_area(self):
        return self.is_admin()
    
    
    @property
    def acl_try_check_on_synchronizer(self):
        acl_try_check_on_synchronizer = self.get('acl_try_check_on_synchronizer', 'null')
        if acl_try_check_on_synchronizer == 'null':
            _prop = DEF_ITEMS[ITEM_TYPE.CONTACTS]['class'].properties['acl_try_check_on_synchronizer']
            acl_try_check_on_synchronizer = _prop.default
        return BoolProp().unpythonize(acl_try_check_on_synchronizer)
    
    
    @property
    def acl_try_check_on_poller(self):
        acl_try_check_on_poller = self.get('acl_try_check_on_poller', 'null')
        if acl_try_check_on_poller == 'null':
            _prop = DEF_ITEMS[ITEM_TYPE.CONTACTS]['class'].properties['acl_try_check_on_poller']
            acl_try_check_on_poller = _prop.default
        return BoolProp().unpythonize(acl_try_check_on_poller)

    @property
    def get_raw_item_for_front(self):
        raw_item = self.get_raw_item()
        return {
            'acl_try_check_on_synchronizer' : int(self.acl_try_check_on_synchronizer),
            'acl_try_check_on_poller' : int(self.acl_try_check_on_poller),
            'is_admin' : self.is_admin(),
            '_id' : raw_item.get('_id'),
            '@metadata' : {'type': 'contacts'},
            'default_submit_to_staging' : raw_item.get('default_submit_to_staging'),
            'contact_name' : raw_item.get('contact_name'),
            'contactgroups' : raw_item.get('contactgroups')
        }