'use strict';

COMPONENT.InheritanceArborescence           = function ( parent_name, dom_element_parent ) {
    // parent_name
    // dom_element_parent
    // dom_element
    // list_template_property
    this.init( parent_name, dom_element_parent );
};
COMPONENT.InheritanceArborescence.prototype = {
    init                  : function ( parent_name, dom_element_parent ) {
        this.parent_name        = parent_name;
        this.dom_element_parent = dom_element_parent;
        this.dom_element        = null;
    },
    buildFromTemplateArbo : function ( list_template_property, dom_element ) {
        this.list_template_property = list_template_property;
        this.dom_element            = dom_element;
        this.dom_element.innerHTML  = '';
        
        var _size = this.list_template_property.length;
        var _template_property;
        for ( var i = 0; i < _size; i++ ) {
            _template_property = this.list_template_property[ i ];
            
            if ( _template_property.is_stopped ) {
                var _nbSkippedTemplate = _size - i - 1;
                if ( _nbSkippedTemplate ) {
                    _template_property.setIsLast( false );
                }
                
                this.addRowStopped( this.dom_element );
                this.addRowFromTemplateName( _template_property, this.dom_element, {
                    is_stopped    : true,
                    is_arbo_dashed: {
                        top   : true,
                        bottom: true
                    }
                } );
                this.addRowTemplate( _template_property, this.dom_element );
                this.addRowSkippedTemplate( _nbSkippedTemplate, this.dom_element );
                break;
            }
            
            this.addRowFromTemplateName( _template_property, this.dom_element, { is_stopped: false } );
            this.addRowTemplate( _template_property, this.dom_element );
        }
    },
    askUpdateHTML         : function () {
        var self = this;
        if ( this.timer_ask_html ) {
            clearTimeout( this.timer_ask_html );
        }
        this.timer_ask_html = setTimeout( function () {
            self.timer_ask_html = null;
            self.updateHTML();
        }, COMPONENT.CONST.BTN_INHERITANCE.TIMER_DELAY_BUILD_HTML );
    },
    addRowTitle           : function ( target, options ) {
        options                 = options || {};
        options.title           = options.title || '';
        options.attr            = options.attr || {};
        options.tag             = options.tag || 'div';
        options.is_arbo_connect = options.is_arbo_connect || false;
        options.is_arbo_dashed  = options.is_arbo_dashed || {};
        options.is_stopped      = options.is_stopped || false;
        options.is_last         = options.is_last || false;
        
        // Gestion de dashed
        var _class_line_1       = {};
        var _class_col_arbo_1_1 = '';
        var _class_col_arbo_1_2 = '';
        var _class_col_arbo_2_1 = '';
        
        if ( options.is_stopped ) {
            _class_line_1 = { class: 'stopped' };
        }
        
        if ( options.is_arbo_dashed.top === true ) {
            _class_col_arbo_1_1 = 'dashed';
        }
        if ( options.is_arbo_dashed.right === true ) {
            _class_col_arbo_1_2 = 'dashed arbo';
        }
        if ( options.is_arbo_dashed.bottom === true ) {
            _class_col_arbo_2_1 = 'dashed';
        }
        
        _class_col_arbo_1_2 += options.is_arbo_connect ? ' arbo' : '';
        _class_col_arbo_2_1 += options.is_last ? ' end' : '';
        
        var _line_1       = DOM.Service.createElement( 'tr', _class_line_1 );
        var _line_2       = DOM.Service.createElement( 'tr', {} );
        var _col_arbo_1_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-1 ' + _class_col_arbo_1_1 } );
        var _col_arbo_1_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-2 ' + _class_col_arbo_1_2 } );
        var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' + _class_col_arbo_2_1 } );
        var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' } );
        var _col_title    = DOM.Service.createElement( 'td', { class: 'col-content', colspan: '2', rowspan: '2' } );
        var _title        = DOM.Service.createElement( options.tag, options.attr, options.title );
        
        DOM.Service.addElementTo( _col_arbo_1_1, _line_1 );
        DOM.Service.addElementTo( _col_arbo_1_2, _line_1 );
        DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
        DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
        DOM.Service.addElementTo( _col_title, _line_1 );
        DOM.Service.addElementTo( _title, _col_title );
        DOM.Service.addElementTo( _line_1, target );
        DOM.Service.addElementTo( _line_2, target );
    },
    addRowSkippedTemplate : function ( size, target ) {
        if ( !size ) {
            return;
        }
        
        var _title = _( 'element.and' ) + ' ' + size + ' ';
        _title += (size > 1) ? _( 'element.skipped_templates' ) : _( 'element.skipped_template' );
        
        this.addRowTitle( target, {
            title         : _title,
            is_stopped    : true,
            is_arbo_dashed: {
                top   : true,
                right : true,
                bottom: true
            },
            is_last       : true
        } );
    },
    addRowFromTemplateName: function ( _template_property, target, options ) {
        options    = options || {};
        var _title = '<span class="shinken-between-bracket">' + _( 'source.tag' ) + "&nbsp;" + SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( shinken_link_tpl, _template_property.template_id, _template_property.template_name ).outerHTML + '</span>';
        if ( options.is_stopped ) {
            _title = _( 'element.skipped_template' ) + ' ' + _template_property.template_name;
        }
        options.title = _title;
        this.addRowTitle( target, options );
    },
    addRowStopped         : function ( target ) {
        this.addRowTitle( target, {
            title          : _( 'element.inheritance_stopped' ),
            attr           : { class: 'tag' },
            is_arbo_connect: true,
            is_arbo_dashed : {
                bottom: true
            }
        } );
    },
    addRowTemplate        : function ( _template_property, target ) {
        // Gestion de dashed
        var _class_line_1       = {};
        var _class_col_arbo_1_1 = '';
        var _class_col_arbo_1_2 = '';
        var _class_col_arbo_2_1 = '';
        var _class_col_arbo_2_2 = '';
        
        if ( _template_property.is_stopped ) {
            _class_line_1 = { class: 'stopped' };
            _class_col_arbo_1_1 += ' dashed';
            _class_col_arbo_1_2 += ' dashed';
            _class_col_arbo_2_1 += ' dashed';
        }
        if ( _template_property.is_last ) {
            _class_col_arbo_2_1 += ' end';
        }
        
        var _line_1       = DOM.Service.createElement( 'tr', _class_line_1 );
        var _line_2       = DOM.Service.createElement( 'tr', {} );
        var _col_arbo_1_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-1 ' + _class_col_arbo_1_1 } );
        var _col_arbo_1_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-1-2 arbo ' + _class_col_arbo_1_2 } );
        var _col_arbo_2_1 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-1 ' + _class_col_arbo_2_1 } );
        var _col_arbo_2_2 = DOM.Service.createElement( 'td', { class: 'col-arbo-2-2 ' + _class_col_arbo_2_2 } );
        var _col_icon     = DOM.Service.createElement( 'td', { class: 'col-icon', rowspan: '2' } );
        var _col_content  = DOM.Service.createElement( 'td', { class: 'col-content', rowspan: '2' } );
        
        var _class_icon = (_template_property.hasPlus()) ? 'token-plus' : 'token-stop';
        var _icon       = DOM.Service.createElement( 'div', { class: _class_icon } );
        
        var _tags = _template_property.getTags();
        for ( var i = 0; i < _template_property.size_tags; i++ ) {
            DOM.Service.addElementTo( _icon, _col_icon );
            DOM.Service.addElementTo( _tags[ i ].getDomElement(), _col_content );
        }
        
        DOM.Service.addElementTo( _col_arbo_1_1, _line_1 );
        DOM.Service.addElementTo( _col_arbo_1_2, _line_1 );
        DOM.Service.addElementTo( _col_arbo_2_1, _line_2 );
        DOM.Service.addElementTo( _col_arbo_2_2, _line_2 );
        DOM.Service.addElementTo( _col_icon, _line_1 );
        DOM.Service.addElementTo( _col_content, _line_1 );
        DOM.Service.addElementTo( _line_1, target );
        DOM.Service.addElementTo( _line_2, target );
    },
    getDomElement         : function () {
        return this.dom_element;
    }
};