'use strict';

MANAGER.DistributorElementManager           = function () {
    this.current_element = null;
    this.current_user    = null;
    this.elements        = {};
    this.mapping_by_name = {};
    this.list_templates;
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( datas ) {
        var _to_return = new OBJECT.ShinkenElement();
        _to_return.updateData( datas );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( se_uuid, datas ) {
        if ( !se_uuid ) {
            return;
        }
        var _to_return = this.getElement( se_uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( datas );
        }
        else {
            _to_return.updateData( datas );
        }
        return _to_return;
    },
    getElementByDict              : function ( object ) {
        return this.getElement( OBJECT.ShinkenElement.generateSEUUID( object[ OBJECT.CONST.ELEMENT.FIELD.ITEM_TYPE ], object[ OBJECT.CONST.ELEMENT.FIELD.UUID ] ) );
    },
    getElementByName              : function ( name ) {
        return this.getElement( this.mapping_by_name[ name ] );
    },
    getTypeElementWithName              : function ( shinken_element_type, shinken_element_name ) {
        var _keys = Object.keys( this.elements );
        var _current_key;
        for( var i = 0, _size = _keys.length ; i < _size; i++ ) {
            _current_key = _keys[i];
            if ( this.elements[_current_key].type !== shinken_element_type ){
                continue;
            }
            if ( this.elements[_current_key].name_element !== shinken_element_name ){
                continue;
            }
            return this.elements[_current_key];
        }
        return null;
    },
    getElement                    : function ( se_uuid ) {
        return this.elements[ se_uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getSEUUID() ]      = element;
        this.mapping_by_name[ element.getName() ] = element.getSEUUID();
    },
    setCurrentElement             : function ( element ) {
        this.current_element = element;
        this.addElement( element );
        element.dom_form = document.getElementById( 'id-shinken-form-element' );
    },
    setCurrentUser                : function ( element ) {
        this.current_user = element;
        this.addElement( element );
    },
    getAllElements                : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
    },
    getAllElementsOfTypeCheck     : function () {
        var _to_return   = [];
        var all_elements = SHINKEN.TOOLS.ARRAY.parseToArray( this.elements );
        for ( var i = 0, _size_i = all_elements.length; i < _size_i; i++ ) {
            if ( all_elements[ i ].isCheck() ) {
                _to_return.push( all_elements[ i ] );
            }
        }
        return _to_return;
    },
    getCheckForCurrentElement     : function () {
        return this.getCheckForElement( this.current_element.uuid, true );
    },
    getCheckForElement            : function ( host_uuid, is_current ) {
        if ( is_current ) {
            return this.current_element.getValidCheck();
        }
        return this.list_templates.getTemplateByUuid( host_uuid ).getValidCheck();
    },
    getAllChecksDFE               : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.is_obsolete || !_current.is_dfe ) {
                continue;
            }
            _to_return.push( _current );
        }
        return _to_return;
    },
    setAllChecksElementsToObsolete: function () {
        var _keys = Object.keys( this.elements );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.getElement( _keys[ i ] );
            if ( _current.isCheck() ) {
                _current.is_obsolete = true;
            }
        }
    },
    getElementValueOfLink         : function ( link ) {
        if ( typeof link === 'string' ) {
            return link;
        }
        var _to_return = "";
        var _current;
        for ( var i = 0, _size_i = link.links.length; i < _size_i; i++ ) {
            _current = this.getElement( link.links[ i ]._id );
            if ( _to_return ) {
                _to_return += ",";
            }
            if ( _current ) {
                _to_return += _current.getName();
            }
            else {
                _to_return += link.links[ i ].name;
            }
        }
        return _to_return;
    },
    getNumberShinkenElement       : function () {
        var _keys = Object.keys( this.elements );
        return _keys.length;
    }
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();