SHINKEN.MODAL = (function( self ) {
    "use strict";
    
    var getDomElementAnchor = function() {
        if ( !self.dom_element_anchor ) {
            self.dom_element_anchor = document.getElementsByClassName( self.MODAL_ANCHOR )[ 0 ];
        }
        return self.dom_element_anchor;
    };
    
    var move        = function( xpos, ypos ) {
        self.getElement().style.top  = ypos + 'px';
        self.getElement().style.left = xpos + 'px';
    };
    var startMoving = function( container, evt ) {
        evt                    = evt || window.event;
        var modal              = self.getElement();
        var bounding_modal     = modal.getBoundingClientRect();
        var bounding_container = container.getBoundingClientRect();
        var posX               = evt.clientX;
        var posY               = evt.clientY;
        var divTop             = bounding_modal.top;
        var divLeft            = bounding_modal.left;
        var eWi                = parseInt( bounding_modal.width );
        var eHe                = parseInt( bounding_modal.height );
        var cTop               = parseInt( bounding_container.top );
        var cLeft              = parseInt( bounding_container.left );
        var cWi                = parseInt( bounding_container.width );
        var cHe                = parseInt( bounding_container.height );
        var diffX              = posX - divLeft;
        var diffY              = posY - divTop;
        document.onmousemove   = function( evt ) {
            evt      = evt || window.event;
            var posX = evt.clientX,
                posY = evt.clientY,
                aX   = posX - diffX,
                aY   = posY - diffY;
            if ( aX < cLeft ) {
                aX = cLeft;
            }
            if ( aY < cTop ) {
                aY = cTop;
            }
            if ( aX + eWi > cWi + cLeft ) {
                aX = cWi - eWi + cLeft;
            }
            if ( aY + eHe > cHe + cTop ) {
                aY = cHe - eHe + cTop;
            }
            move( aX, aY );
        };
    };
    var stopMoving  = function( container ) {
        document.onmousemove = function() {
        };
    };
    
    self.MODAL_ID           = "shinken-modal";
    self.MODAL_ANCHOR       = "shinken-modal-anchor";
    self.dom_element        = null;
    self.dom_element_anchor = null;
    self.is_visible         = false;
    
    self.toggle     = function() {
        self.is_visible ? self.hide() : self.show();
    };
    self.show       = function() {
        self.is_visible = true;
        SHINKEN.DOM.show( self.getElement() );
    };
    self.hide       = function() {
        self.is_visible = false;
        SHINKEN.DOM.hide( self.getElement() );
    };
    self.getElement = function() {
        if ( !self.dom_element ) {
            self.dom_element = document.getElementById( self.MODAL_ID );
        }
        return self.dom_element;
    };
    
    self.setDraggable = function( isDraggable, container ) {
        if ( isDraggable ) {
            getDomElementAnchor().onmousedown = function( e ) {
                startMoving( container, e );
            };
            getDomElementAnchor().onmouseup   = function( e ) {
                stopMoving( container );
            };
        }
        else {
            getDomElementAnchor().onmousedown = null;
            getDomElementAnchor().onmouseup   = null;
        }
    };
    self.createHtmlAndAddToBody = function() {
        var _html = '<div id="shinken-modal" class="shinken-modal" tabindex="-1" role="dialog" style="display: none;" data-backdrop="false">' +
                    '    <div class="modal-header shinken-modal-anchor">' +
                    '        <button type="button" class="btn btn-close-modal" onclick="javascript:SHINKEN.MODAL.hide();">' +
                    '            <i class="shinkon-times-bold"></i>' +
                    '        </button>' +
                    '        <h3 id="saving-log-modal-header" class="saving-log-modal-header"></h3>' +
                    '    </div>' +
                    '    <div id="saving-log-modal-body" class="modal-body"></div>' +
                    '</div>'
        var _to_return = DOM.Service.createElement("div", "shinken-modal-container", _html);
        DOM.BodyService.getDomElement().appendChild(_to_return);
    };
    
    return self;
})( SHINKEN.MODAL || {} );
