'use strict';

OBJECT.Macro           = function ( name, value, type ) {
    name                   = name.toUpperCase();
    this.name              = name;
    this.key               = name.substr( 1, name.length - 2 );
    this.property          = null;
    this.value             = value;
    this.final_value       = value;
    this.type              = type;
    this.macro_used        = {};
    this.is_loop           = false;
    this.is_protected      = false;
    this.is_unknown        = false;
    this.is_herited        = false;
    this.is_double_dollar  = !this.key;
    this.is_force_to_empty = false;
};
OBJECT.Macro.prototype = {
    init                 : function ( forced ) {
        if ( this.value && !forced ) {
            return;
        }
        if ( forced ) {
            if ( !this.is_loop ) {
                var _keys = Object.keys( this.macro_used );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    _current_key = _keys[ i ];
                    this.macro_used[ _current_key ].init( forced );
                }
            }
            this.macro_used = {};
            this.is_loop    = false;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.HOST_LOCAL ) ) {
            this.type       = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL;
            var _key        = "_" + this.key.substr( OBJECT.CONST.MACRO.TYPE.HOST_LOCAL.length );
            var _local_data = MANAGER.__instance_property_distributor.getDataWithName( _key );
            if ( !_local_data ) {
                this.setUnknown( true );
                return;
            }
            this.setUnknown( false );
            if ( _local_data.isProtected() ) {
                this.is_protected = true;
                return;
            }
            var _value = '';
            switch ( _local_data.state ) {
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                    _value = _local_data.getValue();
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    this.is_herited = true;
                    _value          = _local_data.getValueInherited();
                    break;
            }
            this.setValue( _value );
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL ) ) {
            this.type = OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL;
            return;
        }
        else if ( this.key === 'VALUE' ) {
            this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
            this.index_dfe = 0;
            return;
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( this.key, 'VALUE' ) ) {
            var _index = parseInt( this.key.replace( 'VALUE', '' ) );
            if ( isNaN( _index ) ) {
                this.type = this.getTypeMacrosNotLocal( this.key );
            }
            else {
                this.type      = OBJECT.CONST.MACRO.TYPE.VALUE_DFE;
                this.index_dfe = _index - 1;
            }
            return;
        }
        else if ( this.name === OBJECT.CONST.MACRO.TYPE.DFE_KEY ) {
            this.type = OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            return;
        }
        else {
            this.type = this.getTypeMacrosNotLocal( this.key );
            return;
        }
    },
    hasUsedInLoop        : function ( to_set ) {
        var _keys = Object.keys( this.macro_used );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.macro_used[ _keys[ i ] ].is_loop ) {
                return true;
            }
        }
        return false;
    },
    setUnknown           : function ( to_set ) {
        this.is_unknown = to_set;
    },
    setValue             : function ( to_set, property ) {
        this.setUnknown( !to_set );
        if ( property ) {
            this.is_herited = property.state_inheritance;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.VALUE_DFE:
            case OBJECT.CONST.MACRO.TYPE.HOST_LOCAL:
                this.final_value = "";
                this.value       = to_set;
                if ( to_set === undefined ) {
                    return;
                }
                var _splitted = MANAGER.__instance_macro_distributor.splitCommand( to_set );
                var _current;
                
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    _current = _splitted[ i ];
                    if ( typeof _current === 'string' ) {
                        this.final_value += SHINKEN.TOOLS.STRING.cleanXss( _current );
                    }
                    else {
                        this.macro_used[ _current.name ] = _current;
                        if ( _current.macro_used[ this.name ] ) {
                            this.macro_used[ _current.name ] = _current;
                            this.is_loop                     = true;
                            _current.is_loop                 = true;
                            return;
                        }
                        else {
                            for ( var macro in _current.macro_used ) {
                                this.macro_used[ macro ] = _current.macro_used[ macro ];
                            }
                        }
                        this.final_value += _current.getValue();
                    }
                }
                break;
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
                this.value       = to_set;
                this.final_value = to_set;
                break;
            default:
                this.value = to_set;
        }
        //if ( this.hasUsedInLoop() ) {
        //    this.is_loop = true;
        //}
    },
    getValue             : function () {
        var _to_return = this.final_value;
        if ( this.is_force_to_empty ) {
            return "";
        }
        if ( this.is_double_dollar ) {
            return "$";
        }
        if ( this.is_unknown || this.type === OBJECT.CONST.MACRO.TYPE.UNKNOWN || (this.type === OBJECT.CONST.MACRO.TYPE.VALUE_DFE && !this.final_value) ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class         : "shinken-macro-warning value",
                    onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                    'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), this.name ),
                    onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            return _to_return.outerHTML;
        }
        switch ( this.type ) {
            case OBJECT.CONST.MACRO.TYPE.DFE_KEY:
                return OBJECT.CONST.MACRO.TYPE.DFE_KEY;
            case OBJECT.CONST.MACRO.TYPE.SERVICE_LOCAL:
            case OBJECT.CONST.MACRO.TYPE.HOST_PROPERTY:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL:
            case OBJECT.CONST.MACRO.TYPE.GLOBAL_INTERPRETED:
            case OBJECT.CONST.MACRO.TYPE.SERVICE_PROPERTY:
                _to_return = DOM.Service.createElement( "span",
                    {
                        class         : "shinken-macro-warning value",
                        onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
                        'shi-tip-html': SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_evaluated' ), this.name ),
                        onmouseleave  : "SHINKEN_TOOLTIP.hideTooltip()"
                    }, this.name );
                return _to_return.outerHTML;
        }
        if ( this.is_loop || this.is_protected ) {
            _to_return = DOM.Service.createElement( "span",
                {
                    class       : "shinken-macro-error value",
                    onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                    onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
                }, this.name );
            if ( this.is_loop ) {
                _to_return.setAttribute( "shi-tip-html", SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_infinity_loop' ), this.name ) );
            }
            else if ( this.is_protected ) {
                _to_return.setAttribute( "shi-tip-html", _( 'element.password_protected' ) );
                _to_return.classList.add( "shinken-macro-protected" );
            }
            return _to_return.outerHTML;
        }
        if ( this.is_herited ) {
            _to_return = "<span class='shinken-macro-inherited'>" + _to_return + "</span>";
        }
        return _to_return;
    },
    getTypeMacrosNotLocal: function ( key ) {
        var _list_names_properties;
        var _current_type_name;
        var _key_types_macros = Object.keys( OBJECT.CONST.MACRO.TYPE );
        for ( var i = 0, _size_types = _key_types_macros.length; i < _size_types; i++ ) {
            _current_type_name     = OBJECT.CONST.MACRO.TYPE[ _key_types_macros[ i ] ];
            _list_names_properties = all_macros_name_not_resolved[ _current_type_name ];
            if ( !_list_names_properties ) {
                continue;
            }
            
            for ( var j = 0, _size_macro_name = _list_names_properties.length; j < _size_macro_name; j++ ) {
                if ( key === _list_names_properties[ j ] ) {
                    return _current_type_name;
                }
                
            }
        }
        return OBJECT.CONST.MACRO.TYPE.UNKNOWN;
    }
};
