'use strict';

OBJECT.ServiceOverrideUnvalids           = function ( name ) {
    //name
    //type
    //dom_element
    //check
    //host
    this.__class   = "ServiceOverrideUnvalids";
    this.name      = name;
    this.overrides = [];
};
OBJECT.ServiceOverrideUnvalids.prototype = {
    addUnvalidOverride  : function ( override ) {
        this.overrides.push( override );
    },
    setType             : function ( to_set ) {
        this.type = to_set;
    },
    setCheck            : function ( to_set ) {
        this.check = to_set;
    },
    setHost             : function ( to_set ) {
        this.host = to_set;
    },
    setDfeKey           : function ( to_set ) {
        this.key_dfe = to_set;
    },
    getHostName         : function () {
        if ( this.host ) {
            return this.host.getName();
        }
        return "";
    },
    getCheckName        : function () {
        if ( this.check ) {
            return this.check.getName();
        }
        return "";
    },
    buildHtml           : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'shinken-container-host-in-page-host shinken-container-unvalid-override' } );
        var div_footer = DOM.Service.createElement( 'div', { class: 'footer' } );
        
        DOM.Service.addElementTo( this.buildHtmlHeader(), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', { class: 'shinken-container-table-checks' }, this.buildHtmlContent().outerHTML ), _to_return );
        DOM.Service.addElementTo( div_footer, _to_return );
        this.dom_element = _to_return;
        return _to_return;
    },
    buildHtmlContent    : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'container-table' } );
        var table_html = DOM.Service.createElement( 'table', { class: 'shinken-table-checks' } );
        
        DOM.Service.addElementTo( this.buildHtmlTableHeader(), table_html );
        DOM.Service.addElementTo( this.buildHtmlTableBody(), table_html );
        DOM.Service.addElementTo( table_html, _to_return );
        return _to_return;
    },
    buildHtmlTableBody  : function () {
        var _to_return = DOM.Service.createElement( 'tbody' );
        for ( var i = 0, _size_i = this.overrides.length; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.overrides[ i ].buildHtml(), _to_return );
        }
        return _to_return.hasChildNodes() ? _to_return : null;
    },
    buildHtmlHeader     : function () {
        var _to_return = DOM.Service.createElement( 'div', { class: 'header' } );
        var _table     = DOM.Service.createElement( 'table', {} );
        var _tr        = DOM.Service.createElement( 'tr', {} );
        var _td_delete = DOM.Service.createElement( 'td', {
            class: "shinken-delete-btn-cell", onclick: "MANAGER.EventManager.clickOnDeleteInvalidOverride('" + this.type + "','" + this.name + "')"
        }, "<span class='shinken-btn shinkon shinkon-broom'></span>" );
        var _td_title  = DOM.Service.createElement( 'td', { class: "shinken-title-cell" } );
        var _text      = "";
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE:
                _text = SHINKEN.TOOLS.STRING.format( this.host.isTemplate() ? _( 'element.unvalids_override_inactive_check_title_tpl' ) : _( 'element.unvalids_override_inactive_check_title_host' ), SHINKEN.TOOLS.buildLinkShinkenElement( this.check ).outerHTML, SHINKEN.TOOLS.buildLinkShinkenElement( this.host ).outerHTML );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_inactive_template_title' ), this.overrides[ 0 ].override.check_name, SHINKEN.TOOLS.buildLinkShinkenElement( this.host ).outerHTML );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_not_used_template_title' ), this.overrides[ 0 ].override.check_name, this.getHostName() );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                _text      = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_dfe_title' ), SHINKEN.TOOLS.buildLinkShinkenElement( this.check ).outerHTML, this.key_dfe );
                _td_delete = DOM.Service.createElement( 'td', {
                    class: "shinken-delete-btn-cell", onclick: "MANAGER.EventManager.clickOnDeleteInvalidOverride('" + this.type + "','" + this.name + '-' + this.key_dfe + "')"
                }, "<span class='shinken-btn shinkon shinkon-broom'></span>" );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_title' ), this.name );
                break;
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL:
                _text = SHINKEN.TOOLS.STRING.format( _( 'element.unvalids_override_unknown_check_final_title' ), this.name );
                break;
        }
        var _text = DOM.Service.createElement( 'span', { class: 'shinken-title' }, _text );
        DOM.Service.addElementTo( DOM.Service.createElement( 'div', { class: 'shinken-title-unvalid-override' }, _text.outerHTML ), _td_title );
        DOM.Service.addElementTo( _td_delete, _tr );
        DOM.Service.addElementTo( _td_title, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _to_return );
        return _to_return;
    },
    buildHtmlTableHeader: function () {
        var _to_return = DOM.Service.createElement( 'thead', { class: 'bold' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-property shinken-space" }, _( 'element.column_property_data' ) ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-value shinken-space" }, _( 'element.value' ) ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: "shinken-unvalid-override-col shinken-col-definition shinken-space" }, _( 'element.column_complete_definition' ) ), _to_return );
        return _to_return;
    },
    delete              : function () {
        for ( var i = 0, _size_i = this.overrides.length; i < _size_i; i++ ) {
            this.overrides[ i ].delete();
        }
        DOM.Service.removeElement( this.dom_element );
    }
    
};

OBJECT.ServiceOverrideUnvalid           = function ( index, override ) {
    //override
    //index
    //type
    this.__class  = "ServiceOverrideUnvalid";
    this.override = override;
    this.index    = index;
    this.init();
};
OBJECT.ServiceOverrideUnvalid.prototype = {
    init        : function () {
        this.computeType();
    },
    computeType : function () {
        this.type = this.override.has_already_been_linked ? OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK_FINAL : OBJECT.CONST.OVERRIDE_UNVALID.TYPE.UNLINK;
        if ( this.override.host_uuid && this.override.host_uuid !== MANAGER.__instance_element_distributor.current_element.uuid ) {
            if ( !MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( this.override.host_uuid ) ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_NOT_USED;
                return;
            }
            var _host = MANAGER.__instance_element_distributor.getElement( 'core-host-' + this.override.host_uuid );
            if ( _host && !_host.isEnabled() ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_TEMPLATE_INACTIVE;
                return;
            }
        }
        if ( this.override.check_uuid ) {
            var _check = MANAGER.__instance_element_distributor.getElement( "core-service-" + this.override.check_uuid );
            if ( _check && !_check.isEnabled() ) {
                this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_CHECK_INACTIVE;
                return;
            }
        }
        if ( this.override.old_check_in_page_host && this.override.old_check_in_page_host.element.is_dfe ) {
            this.type = OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT;
        }
    },
    getCheckName: function () {
        return this.override.getCheckName();
    },
    getCheckUuid: function () {
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                return this.override.old_check_in_page_host.element.getUUID();
            
        }
        return this.override.check_uuid;
    },
    getHostUuid : function () {
        switch ( this.type ) {
            case OBJECT.CONST.OVERRIDE_UNVALID.TYPE.LINK_DFE_NOT_PRESENT:
                return this.override.old_check_in_page_host.element.host_uuid;
            
        }
        if ( this.override.host_uuid ) {
            return this.override.host_uuid;
        }
        if ( this.override.check_in_page_host ) {
            return this.override.check_in_page_host.element.host_uuid;
        }
        return MANAGER.__instance_element_distributor.current_element.getUUID();
    },
    getDfeKey   : function () {
        return this.override.old_check_in_page_host.key_dfe;
    },
    buildHtml   : function () {
        var _to_return = DOM.Service.createElement( 'tr', { class: 'shinken-check-line shinken-override-unvalid' } );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-property shinken-space' }, this.override.property ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-value shinken-space' }, this.override.label_complete ), _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( 'td', { class: 'shinken-unvalid-override-col shinken-col-definition shinken-space' }, this.override.complete_definition ), _to_return );
        return _to_return;
    },
    delete      : function () {
        MANAGER.__instance_element_distributor.current_element.override.cleanOverride( this.override );
    }
};
OBJECT.CONST.OVERRIDE_UNVALID           = {
    TYPE: {
        LINK_CHECK_INACTIVE   : "1_link_check_inactive",
        LINK_TEMPLATE_INACTIVE: "3_link_template_inactive",
        LINK_TEMPLATE_NOT_USED: "2_link_template_not_used",
        LINK_DFE_NOT_PRESENT  : "4_link_dfe_not_present",
        UNLINK_FINAL          : "5_unlinked_final",
        UNLINK                : "6_unlinked"
    }
};
