//priority 20
'use strict';

SOURCE.Sources           = function ( type ) {
    // list_source
    // list_source_mapping
    this.type               = type;
    this.timer_auto_refresh = null;
    this.init();
};
SOURCE.Sources.prototype = {
    init                   : function ( data ) {
        this.stopAutoRefresh();
        this.list_source         = [];
        this.list_source_mapping = {};
        
        if ( !data ) {
            return;
        }
        
        var _size = data.length;
        var _current;
        var _name;
        for ( var i = 0; i < _size; i++ ) {
            _current              = data[ i ];
            this.list_source[ i ] = new SOURCE.Source( _current );
            this.list_source[ i ].loadDomElements();
            _name                             = this.list_source[ i ].getName();
            this.list_source_mapping[ _name ] = i;
        }
    },
    sanatizeObject         : function () {
        this.reorderRanking();
    },
    updateData             : function ( data ) {
        var _keys = Object.keys( data );
        var _size = _keys.length;
        var _current_name;
        var _current_source;
        for ( var i = 0; i < _size; i++ ) {
            _current_name   = _keys[ i ];
            _current_source = this.getSource( _keys[ i ] );
            if ( _current_source ) {
                _current_source.updateData( data[ _keys[ i ] ] );
            }
            else {
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }
    },
    resetExisting          : function () {
        for ( var i = 0, _size_i = this.list_source.length; i < _size_i; i++ ) {
            this.list_source[ i ].resetExisting();
        }
    },
    removeNonExistingSource: function () {
        for ( var i = 0, _size_i = this.list_source.length; i < _size_i; i++ ) {
            if ( !this.list_source[ i ].is_existing ) {
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }
    },
    refresh                : function () {
        if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
            return;
        }
        var self = this;
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.REFRESH.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.REFRESH.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                //console.log( "[refresh] data", data );
                self.resetExisting();
                self.updateData( data );
                if ( self.needReorder( false ) ) {
                    MANAGER.__instance_source_distributor.reorderAllSourceDom();
                    self.sendNewOrderToBackend();
                }
                self.removeNonExistingSource();
            },
            error  : function ( data, txt ) {
                console.error( 'Refresh source', 'Got bad result for' + data, txt );
                SHINKEN.COMMUNICATION.handleResponse( data.status );
            }
        } );
    },
    stopAutoRefresh        : function ( data ) {
        if ( this.timer_auto_refresh ) {
            clearInterval( this.timer_auto_refresh );
            this.timer_auto_refresh = null;
        }
        
    },
    startAutoRefresh       : function ( data ) {
        this.stopAutoRefresh();
        var self                = this;
        this.timer_auto_refresh = setInterval( function () {
            self.refresh();
        }, 1000 );
    },
    addAllSource           : function ( sources ) {
        this.list_source = [];
        var _size        = sources.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current                                       = sources[ i ];
            this.list_source[ i ]                          = _current;
            this.list_source_mapping[ _current.getName() ] = i;
        }
    },
    getSource              : function ( name ) {
        return this.getObjectByName( name );
    },
    getObjectByName        : function ( name ) {
        var _index = this.list_source_mapping[ name ];
        if ( _index === undefined ) {
            return null;
        }
        return this.getObjectByIndex( _index );
    },
    getObjectByIndex       : function ( index ) {
        return this.list_source[ index ];
    },
    getSourceByType        : function ( type ) {
        var _to_return = [];
        var _current;
        var _size      = this.list_source.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.list_source[ i ];
            if ( _current[ SOURCE.CONST.FIELD.TYPE ] === type ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    reorderRanking         : function () {
        if ( !this.needReorder( true ) ) {
            return;
        }
        
        return this.sendNewOrderToBackend();
    },
    sendNewOrderToBackend  : function () {
        var _size = this.list_source.length;
        var order = '';
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                order += ',';
            }
            order += this.list_source[ i ].getName();
        }
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.URL
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow()
                     + COMMUNICATION.QUERY.GET.SOURCE.SET_ORDER.OPTIONS.ORDER
                     + order,
            success: function ( data ) {
                return true;
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
                return false;
            }
        } );
    },
    changeSourcePosition   : function ( source_1, source_2 ) {
        var _index_1 = this.list_source_mapping[ source_1.getName() ];
        var _index_2 = this.list_source_mapping[ source_2.getName() ];
        
        if ( _index_1 < _index_2 ) {
            for ( var i = _index_1; i < _index_2; i++ ) {
                this.switchSource( this.list_source[ i ], this.list_source[ i + 1 ] );
            }
        }
        else {
            for ( var i = _index_1 - 1; i >= _index_2; i-- ) {
                this.switchSource( this.list_source[ i ], this.list_source[ i + 1 ] );
            }
            
        }
        
    },
    switchSource           : function ( source_1, source_2 ) {
        var _index_dom_element;
        if ( this[ SOURCE.CONST.FIELD.TYPE ] === SOURCE.CONST.TYPES.ALL ) {
            _index_dom_element = 0;
        }
        else {
            _index_dom_element = 1;
        }
        var _index_1 = this.list_source_mapping[ source_1.getName() ];
        var _index_2 = this.list_source_mapping[ source_2.getName() ];
        
        if ( _index_1 > _index_2 ) {
            DOM.Service.insertElementBefore( source_2.getDomElement( _index_dom_element ), source_1.getDomElement( _index_dom_element ) );
        }
        else {
            DOM.Service.insertElementBefore( source_1.getDomElement( _index_dom_element ), source_2.getDomElement( _index_dom_element ) );
        }
        
        SHINKEN.TOOLS.ARRAY.swap( this.list_source, _index_1, _index_2 );
        
        if ( this.type === SOURCE.CONST.TYPES.ALL ) {
            //WE INFORM ONLY IF THE SOURCE IS THE ALL ONE
            source_1.setOrder( _index_2 + 1 );
            source_2.setOrder( _index_1 + 1 );
        }
        
        this.list_source_mapping[ source_1.getName() ] = _index_2;
        this.list_source_mapping[ source_2.getName() ] = _index_1;
    },
    needReorder            : function ( force_set_order ) {
        var _size = this.list_source.length;
        var _need = false;
        if ( !_size ) {
            return;
        }
        for ( var i = 0; i < _size; i++ ) {
            if ( this.list_source[ i ].getOrder() === i + 1 ) {
                continue;
            }
            if ( force_set_order ) {
                this.list_source[ i ].setOrder( i + 1 );
            }
            _need = true;
        }
        return _need;
    },
    reorderDomElement      : function () {
        var _size = this.list_source.length;
        
        var _sources = [];
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = {
                'order' : this.list_source[ i ].getOrder(),
                'source': this.list_source[ i ]
            };
            _sources.push( _current );
        }
        _sources = SHINKEN.TOOLS.ARRAY.sortArray( _sources, 'order' );
        
        for ( var i = _size; i > 0; i-- ) {
            this.changeSourcePosition( _sources[ i - 1 ][ 'source' ], this.list_source[ 0 ] );
        }
    }
};