%import shinkensolutions.shinkenjson as json
%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS, WORKING_AREA_STATUS, WORKING_AREA_LAST_ACTION, ITEM_STATE
%from shinken.synchronizer.business.item_controller.massive_change.massive_change_type import MASSIVE_CHANGE_TYPE
%from shinken.synchronizer.plugins.elements.massive_change import __compute_massive_change_title

%if 'is_new_object' not in locals():
    %is_new_object=False
%end

%if 'working_area' not in locals():
    %working_area=False
%end

%item_state = ITEM_STATE.STAGGING
%have_propose = False
%print_button_propose = False
%display_changes = False

%selected_tab = 'generic'
%propose_delete = 'false'
%working_area_class = ''
%is_disabled = False
%is_admin = user.is_admin()


<div id="id-shinken-mass-change-tunnel-step3" class="shinken-mass-change-tunnel-step shinken-mass-change-property-step">
    %if type_modification == MASSIVE_CHANGE_TYPE.PROPERTIES and item_type in (ITEM_TYPE.HOSTS, ITEM_TYPE.HOSTTPLS, ITEM_TYPE.CLUSTERS, ITEM_TYPE.CLUSTERTPLS):
        <div id="id-shinken-user-list" class="shinken-hidden">{{!json.dumps(user_list)}}</div>
    %end
    <table class="shinken-width-100 shinken-height-100 shinken-mass-change-container">
        <tr class="shinken-header-row">
            <td class="shinken-cell-title">
                <div class="shinken-title-container">
                    <table class="shinken-width-100 shinken-height-100">
                        <tr>
                            <td colspan="3">
                                <div class="shinken-title">
                                    {{__compute_massive_change_title(3, type_modification)}}
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div class="shinken-nb-element-affected">
                                    {{!app._("mass-change.nb-element-affected").format(nb_elements,type_label)}}
                                    <div class="shinken-id-nb-checks-affected"></div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div class="shinken-type-step">
                                    %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                                        {{app._('mass-change.step-3.type_override')}}
                                    % elif type_modification == MASSIVE_CHANGE_TYPE.LOCAL_DATAS:
                                        {{app._('mass-change.step-3.type_local_data')}}
                                    % elif type_modification == MASSIVE_CHANGE_TYPE.DFE_DATAS:
                                        {{app._('mass-change.step-3.type_dfe_data')}}
                                    %else:
                                        {{app._('mass-change.step-3.type')}}
                                    %end
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
            <td class="shinken-action-container-cell">
                <div class="shinken-width-100 shinken-button-table-container">
                    <table class="shinken-table-action-btn shinken-width-100">
                        <tr>
                            <td>
                                {{!helper_object.get_button_html(id_button="id-shinken-btn-step3-next", label=app._('mass-change.button.show_recap'), onclick="CONTROLLER.MassChange.goNextStep()", datas={"name":"show_recap"}, class_to_add="shinken-disabled-if-not-set shinken-disabled")}}
                            </td>
                        </tr>
                        <tr>
                            <td>
                                {{!helper_object.get_button_html(id_button="id-shinken-btn-step3-previous", label=app._('mass-change.button.return'), onclick="CONTROLLER.MassChange.goPreviousStep(event)", datas={"name":"return"})}}
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
        <tr class="shinken-user-container-row">
            <td class="shinken-form-container-cell shinken-height-100">
                <div class="shinken-form-container shinken-width-100 shinken-height-100">
                    %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                        %include( "edition_element_form/serviceshosts", is_mass_change=True, is_override=True, item_type = ITEM_TYPE.SERVICESHOSTS )
                    %elif type_modification in (MASSIVE_CHANGE_TYPE.LOCAL_DATAS, MASSIVE_CHANGE_TYPE.DFE_DATAS):
                        %include( "massive_change/step_3/elements_data", is_mass_change=True )
                    %else:
                        %include( "edition_element_form/%s" % item_type, is_mass_change=True )
                    %end
                </div>
            </td>
            <td class="shinken-help-container-cell">
                <div class="shinken-help-container">
                    %include( "__print_right_help_bloc", changes=False, app=app)
                </div>
            </td>
        </tr>
    </table>
</div>


