#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

import shinkensolutions.shinkenjson as json
from shinken.log import logger
from ...dao.def_items import ITEM_STATE, DEF_ITEMS

### Will be populated by the UI with it's own value
app = None


def lookup(item_type='', name=''):
    app.response.content_type = 'application/json'
    return do_lookup(item_type, name)


def do_lookup(item_type='', name='', uuid_filter=''):
    user = app.get_user_auth()
    logger.debug("[do_lookup] Lookup for [%s] in [%s]" % (name, item_type))
    
    name = name.lower()
    
    where = None
    if uuid_filter:
        where = {'_id': {'$ne': uuid_filter}}
    match_template = app.datamanagerV2.find_items(DEF_ITEMS[item_type]['template'], ITEM_STATE.STAGGING, where=where)
    # logger.debug("[do_lookup] match_template = %s " % pformat(match_template))
    return_match_template_inherit = []
    for template in match_template:
        if 'name' in template and template['name'] != '' and name in template['name'].lower():
            return_match_template_inherit.append(template)
    
    lookups = [{"id": e['name'], "name": e['name'], "is_tag_exist": app.is_tag_exist(e['name'])}
               for e in return_match_template_inherit
               if app.verify_access_element(e, item_type, user)]
    
    # sort by name
    lookups.sort(key=lambda x: x['name'].lower())
    return json.dumps([app.frontend_cipher.cipher(e, item_type=item_type, user=user) for e in lookups])


# Same but in post mode :)
def lookup_tag_post(item_type='', item_id=''):
    app.response.content_type = 'application/json'
    name = app.request.forms.get('value').decode('utf-8', 'ignore')
    return do_lookup(item_type, name, uuid_filter=item_id)


pages = {
    lookup_tag_post: {'routes': ['/lookup/:item_type/tag/:item_id'], 'method': 'POST', 'wrappers': ['auth']},
    lookup         : {'routes': ['/lookup/:item_type/tag/:name'], 'wrappers': ['auth']},
}
