%from shinken.basemodule import SOURCE_STATE

<div class="box-container" id="unsortable-container-source-listener-container" >
    <div class="box-header" >
        <div class="title" >
            <h3 ><span >{{app._("source.listener")}}</span ></h3 >
            <img src="/static/{{app.http_start_time}}/main/img/source/x70/listener.png" alt="listener" >
        </div >
    </div >
    <div class="box-content" >
        <table id="unsortable-container-source-listener" class="table-bordered table-source">
            <thead >
                <tr class="table-header-row" >
                    <th class="shinken-cell-no-border column-order" >{{app._('main.order')}}</th >
                    <th class="shinken-cell-no-border cell column-source-name" >{{app._('main.name')}}</th >
                    <th class="shinken-cell-no-border cell column-enabled" >{{app._('main.enabled')}}</th >
                    <th class="shinken-cell-no-border cell column-state" >{{app._('main.state')}}</th >
                    %if app.me.show_refresh_and_clean_column:
                        <th class="shinken-cell-no-border cell column-force-import">{{app._('main.refresh')}}</th>
                        <th class="shinken-cell-no-border cell column-clean-import">{{app._('main.clean_import')}}</th>
                    %end
                    <th class="shinken-cell-no-border cell column-nb-elements" >{{app._('main.elements')}}</th >
                    <th class="shinken-cell-no-border cell column-output" >{{app._('main.output')}}</th >
                    <th class="shinken-cell-no-border cell column-last-import" >{{app._('main.last_listening')}}</th >
                </tr >
            </thead >
            %sorted_sources = [source for source in sources if source['type'] == 'listener' ]
            %if not len(sorted_sources):
                <tbody class="line-source table-row-color" >
                    <tr>
                        <td class="no-active-source" colspan="10">{{app._('source.no_active_source')}}</td>
                    </tr>
                </tbody>
            %else:
                %for source in sorted_sources:
                    %hname = source['source_name']
                    %is_active = 'is-active' if source['enabled'] else 'is-not-active'
                    %state = source['state']
                    %always_enabled = source.get('always_enabled', False)
                    %hide_class = 'hide' if always_enabled else ''
                    %is_configured = 'is-not-configured' if source['state'] == SOURCE_STATE.NOT_CONFIGURED  else 'is-configured'
                    %_element_in_warning = 'shinken-element-in-warning' if source['nb_elements_warning'] else ''
                    %_element_in_error = 'shinken-element-in-error' if source['nb_elements_error'] else ''

                    <tbody class="line-source shinken-source-state-container table-row-color {{is_active}} {{is_configured}}"
                           data-name="{{hname}}"
                           data-type="{{source['module_type']}}"
                           data-state="{{state}}"
                           draggable="false"
                           ondragstart="MANAGER.DragNDropSourceManager.dragStartSource(event, '{{hname}}')"
                           ondragover="MANAGER.DragNDropSourceManager.dragOverSource(event,'{{hname}}')"
                           ondragend="MANAGER.DragNDropSourceManager.dragEndSource(event)"
                           ondrop="MANAGER.DragNDropSourceManager.dropSource(event)" >
                        <tr id="{{hname}}-link">
                            <td class="shinken-cell-no-border column-order order-index text-center" >
                                <!--listener-->
                                <table >
                                    <tr >
                                        <td ><span class="shinken-line-number" >{{!source['order']}}</span ></td >
                                    </tr >
                                </table >
                            </td >
                            <td class="shinken-cell-no-border column-source-name" >
                                <a href="/sources/{{hname}}?tab=tab-detail-last-run" target="_blank" class="shinken-title-source-name" draggable="false">{{hname}}</a>
                            </td >
                            <td class="shinken-cell-no-border column-enabled" >
                                %if not always_enabled:
                                    <table class="column-enabled-table" >
                                        <tr onclick="MANAGER.EventManager.clickOnActivatedSource('{{hname}}')">
                                            <td >
                                                <div class="switch-button-wrapper" data-source-name="{{hname}}" >
                                                    <div class="switch-button" ></div >
                                                </div >
                                            </td >
                                        </tr>
                                        <tr>
                                            <td class="show-if-source-activated column-enabled-label" >
                                                {{app._('main.enabled')}}
                                            </td >
                                            <td class="hide-if-source-activated column-enabled-label" >
                                                {{app._('main.disabled')}}
                                            </td >
                                        </tr >
                                    </table >
                                %else:
                                    <table class="column-enabled-table" >
                                        <tr>
                                            <td class="show-if-source-activated column-enabled-label" >
                                                {{app._('main.enabled')}}
                                            </td >
                                        </tr >
                                    </table >
                                %end
                            </td >
                            <td class="shinken-cell-no-border column-state" >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label default">{{!state}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label ">{{app._('main.state-pending')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label ok">{{app._('main.state-ok')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label warning">{{app._('main.state-warning')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label critical">{{app._('main.state-critical')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label difference-computing">{{app._('main.computing_differences')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label not-configured">{{app._('main.state-not_configured')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label running">{{app._('main.import_progress')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label never-import">{{app._('main.never_imported')}}</span></span >
                                <span class="state-label state-current-status show-if-source-activated" ><span class="shinken-state-label ready-for-import">{{app._('main.ready-for-import')}}</span></span >
                            </td >
                            %if app.me.show_refresh_and_clean_column:
                                <td class="shinken-cell-no-border column-force-import">
                                    <div class="show-if-source-activated clickable-div"
                                         onclick="MANAGER.EventManager.clickOnForceSource('{{hname}}')"
                                         onmouseenter="SHINKEN_TOOLTIP.showTooltip(this);"
                                         onmouseleave="SHINKEN_TOOLTIP.hideTooltip();"
                                         shi-tip-placement="bottom"
                                         shi-tip-html="{{app._('main.tooltip_refresh_sources')}}">
                                        <span class="icon-refresh"></span>
                                    </div>
                                </td>
                                <td class="shinken-cell-no-border column-clean-import">
                                    <div class="show-if-source-activated clickable-div" onclick="MANAGER.EventManager.clickOnCleanSource('{{hname}}')">
                                        <span class="shinkon shinkon-broom discreet"></span>
                                    </div>
                                </td>
                            %end
                            <td class="shinken-cell-no-border column-nb-elements" >
                                <div class="nb-elements-content show-if-source-activated {{_element_in_warning}} {{_element_in_error}}">
                                    <a href="/sources/{{hname}}?tab=tab-detail-last-run&filter=status:ok" target="_blank" class="shinken-nb-elements shinken-nb-elements-ok">{{!source['nb_elements_ok']}}</a>
                                    <div class="shinken-show-if-elements-in-warning">/ <a href="/sources/{{hname}}?tab=tab-detail-last-run&filter=status:warning" target="_blank" class="shinken-nb-elements shinken-nb-elements-warning" >{{!source['nb_elements_warning']}}</a></div>
                                    <div class="shinken-show-if-elements-in-error">/ <a href="/sources/{{hname}}?tab=tab-detail-last-run&filter=status:error" target="_blank" class="shinken-nb-elements shinken-nb-elements-error">{{!source['nb_elements_error']}}</a></div >
                                </div>
                            </td >
                            <td class="shinken-cell-no-border column-output" >
                                <div class=" show-if-source-activated" >
                                    <table>
                                        <td>
                                            <div class="shinken-last-execution-link" onclick="MANAGER.EventManager.clickOnLastExecutionSource('{{hname}}')"
                                                  onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                                                  onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                                                  shi-tip-html="{{app._('main.show_last_run')}}"
                                                  shi-tip-placement="top">
                                                <i class="shinicon-open"></i>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="scrollable-output output-content {{state.lower()}}" >{{!source['output']}}</div >
                                        </td>
                                    </table>
                                </div >
                            </td >
                            <td class="shinken-cell-no-border column-last-import" >
                                %if not always_enabled:
                                    <span class="last-import-content show-if-source-activated" ></span >
                                %end
                            </td >
                        </tr >
                    </tbody >
                %end
            %end
        </table >
    </div >
    <div class="box-footer" ></div >
</div >