function change_protected_value( element, e ) {
    if ( !parseInt( element.dataset.isChanged ) ) {
        element.value             = "";
        element.dataset.isChanged = 1;
    }
};

function updateDisplayBind( element ) {
    var datasetElements = element.dataset;
    for ( var name in datasetElements ) {
        var bindElementName    = datasetElements[ name ];
        var bindedElement      = document.getElementById( bindElementName );
        bindedElement.disabled = !element.checked;
    }
    ;
};

function _compute_ciphering() {
    var inputs = document.querySelectorAll( "input[type=password]" );
    var _size  = inputs.length;
    var _current;
    var _current_is_changed;
    for ( var i = 0; i < _size; i++ ) {
        _current            = inputs[ i ];
        _current_is_changed = parseInt( _current.dataset.isChanged );
        if ( _current_is_changed ) {
            // The value of this password have changed, we need to replace the value by the b64 value
            _current.value = SHINKEN.TOOLS.STRING.b64Encode(_current.value);
        }
    }
    
}

function submit_form_source_conf( elem ) {
    _compute_ciphering();
    
    elem.classList.add( "shinken-content-disabled" );
    elem.parentNode.classList.add( "shinken-pending" );
    setTimeout( function() {
        document.getElementById( 'shinken-form-source-conf' ).submit();
    }, 500 );
}

$( window ).ready( function() {
    // Find the checkbox and call the update updateDisplayBind for each of them
    var checkboxes = document.querySelectorAll( "input[type=checkbox]" );
    for ( checkbox in checkboxes ) {
        updateDisplayBind( checkboxes[ checkbox ] );
    }
} );