#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn, List
from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.shinken_object import ShinkenObject


class ShinkenArray(ShinkenObject):
    def __init__(self):
        # type: ()-> NoReturn
        super(ShinkenArray, self).__init__()
        self.content = []
    
    
    def reset(self):
        # type: ()-> NoReturn
        self.content = []
    
    
    def get_element(self, index):
        # type: (int)-> ShinkenObject
        return self.content[index]
    
    
    def add_element(self, to_add):
        # type: (ShinkenObject)-> NoReturn
        self.content.append(to_add)
    
    
    def insert_element(self, index, to_add):
        # type: (int, ShinkenObject)-> NoReturn
        self.content.insert(index, to_add)
    
    
    def exist(self, to_test):
        # type: (ShinkenObject)-> int
        for index, _current in enumerate(self.content):
            if _current.is_equal(to_test):
                return index
        return -1
    
    
    def exist_by_id(self, _id):
        # type: (str)-> int
        for index, _current in enumerate(self.content):
            if _current.is_id(_id):
                return index
        return -1
    
    
    def get_size(self):
        # type: ()-> int
        return len(self.content)
    
    
    def get_content(self):
        # type: ()-> List
        return self.content
    
    
    def get_html(self, format_html=""):
        # type: ()-> str
        _to_return = ""
        for _current in self.content:
            _to_return += _current.get_html(format_html=format_html)
        return _to_return
