#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.template_html import unescape_XSS
from shinkensolutions.api.synchronizer.source.display_origin_item.abstract_display_origin_item import AbstractDisplayOriginItem


class DisplayOriginItemAsString(AbstractDisplayOriginItem):
    
    def controller(self, item, item_type):
        if not self.title:
            self.title = self.translator.translate('display_origin_item.element_found_by_source')
        
        return {
            'title'   : self.title,
            'raw_data': unescape_XSS(self.raw_data)
        }
